/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.complex_animal;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import team.recrafted.blastfromthepast.entity.misc.ComplexAnimal;

public class MoveToOrSitWithItemGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final Predicate<ItemEntity> wantedItems;
    private int cooldown;
    private final double speedModifier;

    public MoveToOrSitWithItemGoal(T mob, Predicate<ItemEntity> wantedItems, double speedModifier) {
        this.mob = mob;
        this.wantedItems = wantedItems;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.cooldown <= ((Mob)this.mob).f_19797_ && !this.mob.m_6162_() && !this.mob.m_20069_() && ((ComplexAnimal)this.mob).canPerformAction()) {
            if (this.hasItemInMouth()) {
                return true;
            }
            List items = this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(6.0, 6.0, 6.0), this::isWantedItem);
            return !items.isEmpty();
        }
        return false;
    }

    protected boolean isWantedItem(ItemEntity ie) {
        return this.wantedItems.test(ie);
    }

    public void m_8056_() {
        if (this.hasItemInMouth()) {
            ((ComplexAnimal)this.mob).tryToSit();
        } else {
            List items = this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(8.0, 8.0, 8.0), this::isWantedItem);
            if (!items.isEmpty()) {
                this.mob.m_21573_().m_5624_((Entity)items.get(0), this.speedModifier);
            }
        }
        this.cooldown = 0;
    }

    private boolean hasItemInMouth() {
        return !((ComplexAnimal)this.mob).getItemInMouth().m_41619_();
    }

    public boolean m_8045_() {
        return !this.mob.m_20069_() && (this.mob.m_21573_().m_26572_() || this.hasItemInMouth());
    }

    public void m_8037_() {
        if (!((ComplexAnimal)this.mob).isSitting() && this.hasItemInMouth()) {
            ((ComplexAnimal)this.mob).tryToSit();
        }
    }

    public void m_8041_() {
        ItemStack itemBySlot = ((ComplexAnimal)this.mob).getItemInMouth();
        if (!itemBySlot.m_41619_()) {
            this.mob.m_19983_(itemBySlot);
            ((ComplexAnimal)this.mob).putItemInMouth(ItemStack.f_41583_, false);
            int seconds = this.mob.m_217043_().m_188503_(150) + 10;
            this.cooldown = ((Mob)this.mob).f_19797_ + seconds * 20;
        }
        ((ComplexAnimal)this.mob).setSitting(false);
    }
}

