/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.pack;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import team.recrafted.blastfromthepast.entity.pack.EntityPack;
import team.recrafted.blastfromthepast.entity.pack.EntityPackHolder;
import team.recrafted.blastfromthepast.mixin.HurtByTargetGoalAccessor;

public class PackHurtByTargetGoal<T extends PathfinderMob>
extends HurtByTargetGoal {
    protected final T packMob;
    protected final Predicate<T> canRetaliate;
    protected final Predicate<T> canIgnoreAlert;

    public PackHurtByTargetGoal(T packMob, Predicate<T> canRetaliate, Predicate<T> canIgnoreAlert, Class<?> ... toIgnoreDamage) {
        super(packMob, (Class[])toIgnoreDamage);
        this.packMob = packMob;
        this.canRetaliate = canRetaliate;
        this.canIgnoreAlert = canIgnoreAlert;
        this.m_26044_(new Class[0]);
    }

    public void m_8056_() {
        super.m_8056_();
        if (!this.canRetaliate.test(this.packMob)) {
            this.m_26047_();
            this.m_8041_();
        }
    }

    protected void m_26047_() {
        LivingEntity lastHurtByMob = this.packMob.m_21188_();
        if (lastHurtByMob == null) {
            return;
        }
        double followDistance = this.m_7623_();
        AABB searchBounds = AABB.m_82333_((Vec3)this.f_26135_.m_20182_()).m_82377_(followDistance, 10.0, followDistance);
        EntityPack pack = ((EntityPackHolder)this.packMob).getPack();
        if (pack == null) {
            return;
        }
        pack.getMembers().filter(member -> this.canAlert(member, searchBounds, lastHurtByMob)).forEach(member -> this.m_5766_((Mob)member, lastHurtByMob));
    }

    protected boolean canAlert(T member, AABB searchBounds, LivingEntity lastHurtByMob) {
        return member.m_20191_().m_82381_(searchBounds) && this.packMob != member && member.m_5448_() == null && this.hasSameOwnerAs(member).orElse(true) != false && !member.m_7307_((Entity)lastHurtByMob) && !this.canIgnoreAlert.test(member);
    }

    protected Optional<Boolean> hasSameOwnerAs(T member) {
        return Optional.of(this.packMob).filter(arg_0 -> PackHurtByTargetGoal.lambda$hasSameOwnerAs$2(OwnableEntity.class, arg_0)).map(arg_0 -> PackHurtByTargetGoal.lambda$hasSameOwnerAs$3(OwnableEntity.class, arg_0)).map(ownable -> {
            boolean bl;
            if (member instanceof OwnableEntity) {
                OwnableEntity ownableMember = (OwnableEntity)member;
                if (ownable.m_269323_() == ownableMember.m_269323_()) {
                    bl = true;
                    return bl;
                }
            }
            bl = false;
            return bl;
        });
    }

    protected boolean ownership(T member) {
        T t = this.packMob;
        if (t instanceof OwnableEntity) {
            OwnableEntity packMobOwnable = (OwnableEntity)t;
            if (member instanceof OwnableEntity) {
                OwnableEntity memberOwnable = (OwnableEntity)member;
                return packMobOwnable.m_269323_() == memberOwnable.m_269323_();
            }
        }
        return true;
    }

    protected HurtByTargetGoalAccessor access() {
        return (HurtByTargetGoalAccessor)((Object)this);
    }

    private static /* synthetic */ OwnableEntity lambda$hasSameOwnerAs$3(Class rec$, Object x$0) {
        return (OwnableEntity)rec$.cast(x$0);
    }

    private static /* synthetic */ boolean lambda$hasSameOwnerAs$2(Class rec$, Object x$0) {
        return rec$.isInstance(x$0);
    }
}

