/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.roar;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.Roaring;
import team.recrafted.blastfromthepast.util.DebugFlags;
import team.recrafted.blastfromthepast.util.EntityHelper;
import team.recrafted.blastfromthepast.util.HitboxHelper;

public class RoarAtTargetGoal<T extends Mob>
extends Goal {
    private final T mob;
    private boolean didRoar = false;
    @Nullable
    private LivingEntity lastKnownTarget;
    private final double maxDistSqrToTarget;

    public RoarAtTargetGoal(T mob, double maxDistToTarget) {
        this.mob = mob;
        this.maxDistSqrToTarget = Mth.m_144952_((double)maxDistToTarget);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        LivingEntity target;
        if (!((Roaring)this.mob).canRoar()) {
            return false;
        }
        if (this.lastKnownTarget != null && (this.lastKnownTarget.m_213877_() || HitboxHelper.getDistSqrBetweenHitboxes(this.mob, (Entity)this.lastKnownTarget) > Mth.m_144952_((double)EntityHelper.getFollowRange(this.mob)))) {
            this.lastKnownTarget = null;
        }
        if (this.lastKnownTarget != (target = this.mob.m_5448_())) {
            boolean canUse;
            this.lastKnownTarget = target;
            boolean bl = canUse = target != null && HitboxHelper.getDistSqrBetweenHitboxes(this.mob, (Entity)target) > this.maxDistSqrToTarget;
            if (canUse && DebugFlags.DEBUG_ROAR) {
                BlastFromThePast.LOGGER.info("{} wants to roar at {}", this.mob, (Object)target);
            }
            return canUse;
        }
        return false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        this.lookOrRoarAtTarget();
    }

    private void lookOrRoarAtTarget() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && !((Roaring)this.mob).isRoaring()) {
            if (this.isFacingTarget(target)) {
                if (!this.didRoar) {
                    ((Roaring)this.mob).roarIfPossible();
                    if (((Roaring)this.mob).isRoaring()) {
                        if (DebugFlags.DEBUG_ROAR) {
                            BlastFromThePast.LOGGER.info("{} started roaring at {}", this.mob, (Object)target);
                        }
                        this.didRoar = true;
                    }
                }
            } else {
                this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
        } else if (this.mob.m_217043_().m_216332_(1, 2500) == 1 && !this.didRoar) {
            ((Roaring)this.mob).roarIfPossible();
            if (((Roaring)this.mob).isRoaring()) {
                if (DebugFlags.DEBUG_ROAR) {
                    BlastFromThePast.LOGGER.info("{} started roaring at {}", this.mob, (Object)target);
                }
                this.didRoar = true;
            }
        }
    }

    protected boolean isFacingTarget(LivingEntity target) {
        return EntityHelper.isLookingAt(this.mob, target, 0.025, false, true);
    }

    public boolean m_8045_() {
        if (((Roaring)this.mob).isRoaring()) {
            return true;
        }
        if (this.didRoar) {
            return false;
        }
        LivingEntity target = this.mob.m_5448_();
        return target != null && HitboxHelper.getDistSqrBetweenHitboxes(this.mob, (Entity)target) > this.maxDistSqrToTarget;
    }

    public void m_8037_() {
        this.lookOrRoarAtTarget();
    }

    public void m_8041_() {
        if (DebugFlags.DEBUG_ROAR) {
            BlastFromThePast.LOGGER.info("{} finished roaring at target", this.mob);
        }
        this.didRoar = false;
    }
}

