/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.pack;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.pack.EntityPack;
import team.recrafted.blastfromthepast.util.DebugFlags;

public interface EntityPackHolder<T extends Mob> {
    public static final String ENTITY_PACK_TAG_KEY = "EntityPack";

    @Nullable
    public EntityPack<T> getPack();

    default public boolean addPackMember(T newMember) {
        return this.addPackMember(newMember, false);
    }

    default public boolean addPackMember(T newMember, boolean canLeave) {
        return this.addMemberToPack(newMember, this.getPack(), canLeave);
    }

    default public boolean addMemberToPack(T newMember, @Nullable EntityPack<T> pack, boolean canLeave) {
        return EntityPackHolder.addMemberToPackStatic(newMember, pack, canLeave);
    }

    public static <T extends Mob> boolean addMemberToPackStatic(T newMember, @Nullable EntityPack<T> pack, boolean canLeave) {
        if (pack == null) {
            return false;
        }
        EntityPack<T> oldPack = ((EntityPackHolder)newMember).getPack();
        if (oldPack != null && !canLeave) {
            return false;
        }
        boolean added = pack.addMember(newMember);
        if (added) {
            if (DebugFlags.DEBUG_ENTITY_PACK) {
                BlastFromThePast.LOGGER.info("Added {} to entity pack {}, now has {} members", new Object[]{newMember, pack.getPackName(), pack.getCount()});
            }
            ((EntityPackHolder)newMember).setPack(pack);
            if (oldPack != null && oldPack.removeMember(newMember) && DebugFlags.DEBUG_ENTITY_PACK) {
                BlastFromThePast.LOGGER.info("Removed {} from entity pack {}, now has {} members", new Object[]{newMember, oldPack.getPackName(), oldPack.getCount()});
            }
        }
        return added;
    }

    public void setPack(@Nullable EntityPack<T> var1);

    default public void savePackData(CompoundTag saveData) {
        EntityPack<T> myPack = this.getPack();
        if (myPack == null) {
            return;
        }
        saveData.m_128362_(ENTITY_PACK_TAG_KEY, myPack.getUUID());
    }

    default public void readPackData(CompoundTag saveData, T packMob, ServerLevel level) {
        if (saveData.m_128403_(ENTITY_PACK_TAG_KEY)) {
            EntityPack pack = BlastFromThePast.getUniversalEntityPacks(level.m_7654_()).getOrCreatePack(saveData.m_128342_(ENTITY_PACK_TAG_KEY));
            this.addMemberToPack(packMob, pack, true);
        }
    }
}

