/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.pack;

import com.google.common.collect.Maps;
import com.mojang.serialization.DynamicOps;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.pack.EntityPack;

public class EntityPacks
extends SavedData {
    private static final String ENTITY_PACKS_FILE_ID = "entity_packs";
    public static final String ENTITY_PACKS_TAG_KEY = "EntityPacks";
    private final Map<UUID, EntityPack<?>> entityPackMap = Maps.newHashMap();
    private final ServerLevel level;
    private int tick;

    public EntityPacks(ServerLevel level) {
        this.level = level;
        this.m_77762_();
    }

    public EntityPack<?> get(UUID uuid) {
        return this.entityPackMap.get(uuid);
    }

    public void tick() {
        ++this.tick;
        Iterator<EntityPack<?>> iterator = this.entityPackMap.values().iterator();
        while (iterator.hasNext()) {
            EntityPack<?> pack = iterator.next();
            if (pack.isEmpty()) {
                iterator.remove();
                this.m_77762_();
                continue;
            }
            pack.tick(this.level);
        }
        if (this.tick % 200 == 0) {
            this.m_77762_();
        }
    }

    public <U extends Mob> EntityPack<U> getOrCreatePack(UUID uuid) {
        EntityPack pack = this.get(uuid);
        EntityPack typedPack = pack != null ? pack : new EntityPack(uuid);
        this.trackPack(typedPack);
        return typedPack;
    }

    private <U extends Mob> void trackPack(EntityPack<U> typedPack) {
        if (!this.entityPackMap.containsKey(typedPack.getUUID())) {
            this.entityPackMap.put(typedPack.getUUID(), typedPack);
        }
        this.m_77762_();
    }

    public <U extends Mob> EntityPack<U> createFreshPack() {
        EntityPack typedPack = new EntityPack();
        this.trackPack(typedPack);
        return typedPack;
    }

    public static EntityPacks load(ServerLevel level, CompoundTag tag) {
        EntityPacks entityPacks = new EntityPacks(level);
        entityPacks.tick = tag.m_128451_("Tick");
        ListTag entityPacksTag = tag.m_128437_(ENTITY_PACKS_TAG_KEY, 10);
        for (int i = 0; i < entityPacksTag.size(); ++i) {
            CompoundTag entityPackTag = entityPacksTag.m_128728_(i);
            EntityPack.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)entityPackTag).resultOrPartial(partial -> BlastFromThePast.LOGGER.error("Failed to parse entity pack: '{}'", partial)).ifPresent(entityPack -> entityPacks.entityPackMap.put(entityPack.getUUID(), (EntityPack<?>)entityPack));
        }
        return entityPacks;
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128405_("Tick", this.tick);
        ListTag entityPacksTag = new ListTag();
        for (EntityPack<?> entityPack : this.entityPackMap.values()) {
            EntityPack.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, entityPack).resultOrPartial(partial -> BlastFromThePast.LOGGER.error("Failed to encode entity pack: '{}'", partial)).ifPresent(arg_0 -> entityPacksTag.add(arg_0));
        }
        tag.m_128365_(ENTITY_PACKS_TAG_KEY, (Tag)entityPacksTag);
        return tag;
    }

    public static String getFileId() {
        return "blastfromthepast_entity_packs";
    }
}

