/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.speartooth;

import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.GlacerosEntity;
import team.recrafted.blastfromthepast.entity.Roaring;
import team.recrafted.blastfromthepast.entity.ai.goal.CustomPanicGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.pack.PackHurtByTargetGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.roar.RoarAtTargetGoal;
import team.recrafted.blastfromthepast.entity.misc.ComplexAnimal;
import team.recrafted.blastfromthepast.entity.misc.StateValue;
import team.recrafted.blastfromthepast.entity.pack.EntityPack;
import team.recrafted.blastfromthepast.entity.pack.EntityPackAgeableMobData;
import team.recrafted.blastfromthepast.entity.pack.EntityPackHolder;
import team.recrafted.blastfromthepast.entity.speartooth.ai.SpeartoothBiteAttackGoal;
import team.recrafted.blastfromthepast.entity.speartooth.ai.SpeartoothPounceTargetGoal;
import team.recrafted.blastfromthepast.entity.speartooth.ai.SpeartoothRetreatGoal;
import team.recrafted.blastfromthepast.entity.speartooth.ai.SpeartoothSleepGoal;
import team.recrafted.blastfromthepast.entity.speartooth.ai.SpeartoothStalkTargetGoal;
import team.recrafted.blastfromthepast.entity.speartooth.ai.SpeartoothTigerIdleGoal;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModDataSerializers;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.network.ScreenShakePayload;
import team.recrafted.blastfromthepast.util.EntityHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpeartoothEntity
extends TamableAnimal
implements ComplexAnimal,
GeoEntity,
Roaring,
EntityPackHolder<SpeartoothEntity> {
    private static final EntityDimensions BABY_DIMENSIONS = ((EntityType)ModEntities.SPEARTOOTH.get()).m_20680_().m_20388_(0.5f);
    protected static final EntityDataAccessor<State> STATE = SynchedEntityData.m_135353_(SpeartoothEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModDataSerializers.SPEARTOOTH_STATE.get()));
    protected static final EntityDataAccessor<Texture> TEXTURE = SynchedEntityData.m_135353_(SpeartoothEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModDataSerializers.SPEARTOOTH_TEXTURE.get()));
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.speartooth.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation SLEEP = RawAnimation.begin().then("animation.speartooth.sleep", Animation.LoopType.DEFAULT);
    public static final RawAnimation COLD = RawAnimation.begin().then("animation.speartooth.cold", Animation.LoopType.DEFAULT);
    public static final RawAnimation DANCE = RawAnimation.begin().then("animation.speartooth.dance", Animation.LoopType.DEFAULT);
    public static final RawAnimation NOISE = RawAnimation.begin().then("animation.speartooth.noise", Animation.LoopType.DEFAULT);
    public static final RawAnimation EAR = RawAnimation.begin().then("animation.speartooth.ear", Animation.LoopType.DEFAULT);
    public static final RawAnimation STRETCH = RawAnimation.begin().then("animation.speartooth.stretch", Animation.LoopType.DEFAULT);
    public static final RawAnimation SIT = RawAnimation.begin().then("animation.speartooth.sit", Animation.LoopType.DEFAULT);
    public static final RawAnimation STALK = RawAnimation.begin().then("animation.speartooth.stalk", Animation.LoopType.DEFAULT);
    public static final RawAnimation BITE = RawAnimation.begin().then("animation.speartooth.attack", Animation.LoopType.DEFAULT);
    public static final RawAnimation ROAR = RawAnimation.begin().then("animation.speartooth.roar", Animation.LoopType.DEFAULT);
    public static final RawAnimation LUNGE = RawAnimation.begin().then("animation.speartooth.lunge", Animation.LoopType.DEFAULT);
    public static final RawAnimation WALK = RawAnimation.begin().then("animation.speartooth.walk", Animation.LoopType.DEFAULT);
    public static final RawAnimation RUN = RawAnimation.begin().then("animation.speartooth.run", Animation.LoopType.DEFAULT);
    @org.jetbrains.annotations.Nullable
    public UUID lastPouncedAt;
    public long lastPounceTime;
    public long lastStalkTime;
    public long lastRoarTime;
    public LivingEntity lastTarget;
    private int roarTimer;
    private int huntCooldown;
    private boolean party;
    @Nullable
    private BlockPos jukebox;
    private EntityPack<SpeartoothEntity> pack;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SpeartoothEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 5;
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)State.IDLE);
        this.f_19804_.m_135372_(TEXTURE, (Object)Texture.DEFAULT);
    }

    public void m_8099_() {
        super.m_8099_();
        int i = 0;
        this.f_21345_.m_25352_(i++, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(i++, (Goal)new SpeartoothSleepGoal(this));
        this.f_21345_.m_25352_(i++, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(i++, (Goal)new SpeartoothRetreatGoal(this, 1.7f, 1.9f));
        this.f_21345_.m_25352_(i++, new RoarAtTargetGoal<SpeartoothEntity>(this, 3.0));
        SpeartoothPounceTargetGoal pounceGoal = new SpeartoothPounceTargetGoal(this, 0.5f);
        this.f_21345_.m_25352_(i++, (Goal)pounceGoal);
        this.f_21345_.m_25352_(i++, (Goal)new SpeartoothStalkTargetGoal(this, pounceGoal, 30.0f, 4.0f));
        this.f_21345_.m_25352_(i++, (Goal)new SpeartoothBiteAttackGoal(this, 2.0, false));
        this.f_21345_.m_25352_(i++, new CustomPanicGoal<SpeartoothEntity>(this, 2.0, EntityHelper.getPanicInducingDamageTypes()));
        this.f_21345_.m_25352_(i++, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(i++, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.25, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(i++, (Goal)new TemptGoal((PathfinderMob)this, 1.25, this.isTemptItem(), false));
        this.f_21345_.m_25352_(i++, (Goal)new SpeartoothTigerIdleGoal(this));
        this.f_21345_.m_25352_(i++, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(i++, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.f_21345_.m_25352_(i++, (Goal)new RandomLookAroundGoal((Mob)this));
        int t = 0;
        this.f_21346_.m_25352_(t++, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(t++, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(t++, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(t++, new PackHurtByTargetGoal<SpeartoothEntity>(this, Predicate.not(AgeableMob::m_6162_), AgeableMob::m_6162_, new Class[0]));
        this.f_21346_.m_25352_(t, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, GlacerosEntity.class, false, mob -> true));
        this.f_21346_.m_25352_(t, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, true, mob -> true));
    }

    private Ingredient isTemptItem() {
        if (!this.m_21824_() && !this.m_6162_()) {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{((Block)ModBlocks.BEAST_CHOPS.get()).m_5456_()});
        }
        return Ingredient.f_43901_;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.m_6162_() ? BABY_DIMENSIONS : super.m_6972_(pose);
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions entityDimensions) {
        return this.m_6162_() ? 0.55f : 1.25f;
    }

    public boolean shouldRetreat() {
        return this.m_21223_() < this.m_21233_() / 4.0f;
    }

    public void m_6710_(@org.jetbrains.annotations.Nullable LivingEntity target) {
        if (target != null && !this.m_21824_()) {
            if (this.huntCooldown > 0) {
                return;
            }
            this.huntCooldown = 6000;
        }
        if (!this.shouldRetreat() || target == null) {
            super.m_6710_(target);
        }
    }

    public void setTame(boolean tame, boolean applyTamingSideEffects) {
        if (tame) {
            // empty if block
        }
    }

    public void m_8119_() {
        super.m_8119_();
        State state = this.getState();
        if (!this.m_9236_().f_46443_) {
            if (this.lastTarget != null && (this.lastTarget.m_213877_() || !this.m_142582_((Entity)this.lastTarget) && this.lastTarget != this.m_5448_())) {
                this.lastTarget = null;
            }
            --this.huntCooldown;
            if (this.getTexture() == Texture.STALKING && state != State.STALK) {
                this.setTexture(Texture.DEFAULT);
            }
            if (state == State.ROAR) {
                --this.roarTimer;
                if (this.roarTimer <= 0) {
                    this.setRoaring(false);
                }
            }
        }
    }

    public boolean isIdle() {
        State state = this.getState();
        return state == State.IDLE || state == State.NOISE || state == State.EAR || state == State.STRETCH || state == State.COLD;
    }

    public boolean m_6898_(ItemStack itemStack) {
        if (itemStack.getFoodProperties((LivingEntity)this) == null) {
            return false;
        }
        return Objects.requireNonNull(itemStack.getFoodProperties((LivingEntity)this)).m_38746_();
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        SpeartoothEntity speartooth = (SpeartoothEntity)((EntityType)ModEntities.SPEARTOOTH.get()).m_20615_((Level)serverLevel);
        if (speartooth == null) {
            return null;
        }
        speartooth.m_21816_(this.m_21805_());
        speartooth.setTame(true, true);
        speartooth.setPack(this.pack);
        return speartooth;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Animal.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, (double)0.22f);
        builder = builder.m_22268_(Attributes.f_22276_, 30.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        return builder;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.m_9236_().f_46443_) {
            if (this.m_21824_()) {
                if (hand == InteractionHand.MAIN_HAND && this.m_21830_((LivingEntity)player) && this.m_5803_()) {
                    this.setSleeping(false);
                    this.m_21839_(false);
                    return InteractionResult.SUCCESS;
                }
                if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float f = foodproperties != null ? (float)foodproperties.m_38744_() : 1.0f;
                    this.m_5634_(2.0f * f);
                    EntityHelper.consumeStack(1, (LivingEntity)player, itemstack);
                    this.m_146850_(GameEvent.f_157806_);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
                if (this.m_6162_() || itemstack.m_150930_((Item)ModItems.RAW_VENISON.get())) {
                    return super.m_6071_(player, hand);
                }
                if (this.m_21830_((LivingEntity)player) && hand == InteractionHand.MAIN_HAND) {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (itemstack.m_150930_(((Block)ModBlocks.BEAST_CHOPS.get()).m_5456_())) {
                    EntityHelper.consumeStack(1, (LivingEntity)player, itemstack);
                    this.m_21828_(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_21839_(true);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
                return super.m_6071_(player, hand);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof Creeper || target instanceof Ghast || target instanceof ArmorStand)) {
            if (!(target instanceof SpeartoothEntity)) {
                TamableAnimal tamable;
                AbstractHorse horse;
                if (target instanceof Player) {
                    Player ownerPlayer;
                    Player playerTarget = (Player)target;
                    if (owner instanceof Player && !(ownerPlayer = (Player)owner).m_7099_(playerTarget)) {
                        return false;
                    }
                }
                if (target instanceof AbstractHorse && (horse = (AbstractHorse)target).m_30614_()) {
                    return false;
                }
                return !(target instanceof TamableAnimal) || !(tamable = (TamableAnimal)target).m_21824_();
            }
            SpeartoothEntity speartooth = (SpeartoothEntity)target;
            return !speartooth.m_21824_() || speartooth.m_269323_() != owner;
        }
        return false;
    }

    public void m_21837_(boolean sitting) {
        super.m_21837_(sitting);
        this.setState(sitting ? State.SIT : State.IDLE);
    }

    public void m_21839_(boolean orderedToSit) {
        super.m_21839_(orderedToSit);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @org.jetbrains.annotations.Nullable SpawnGroupData spawnGroupData, CompoundTag compoundTag) {
        if (spawnGroupData == null) {
            spawnGroupData = new SpeartoothGroupData(BlastFromThePast.getUniversalEntityPacks(level.m_6018_().m_7654_()).createFreshPack(), true);
        }
        if (spawnGroupData instanceof SpeartoothGroupData) {
            SpeartoothGroupData speartoothGroupData = (SpeartoothGroupData)spawnGroupData;
            speartoothGroupData.addPackMember((Mob)this);
        }
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, compoundTag);
    }

    public boolean isLookingAtMe(LivingEntity pEntity) {
        Vec3 vec3 = pEntity.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - pEntity.m_20185_(), this.m_20188_() - pEntity.m_20188_(), this.m_20189_() - pEntity.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 && pEntity.m_142582_((Entity)this);
    }

    public Texture getTexture() {
        return (Texture)this.f_19804_.m_135370_(TEXTURE);
    }

    public void setTexture(Texture texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public State getState() {
        return (State)this.f_19804_.m_135370_(STATE);
    }

    public void setState(State state) {
        if (state.texture() == Texture.AGGRESSIVE && this.m_6162_()) {
            BlastFromThePast.LOGGER.warn("Baby speartooth cannot have an aggressive state!");
            new Exception().printStackTrace();
            return;
        }
        this.f_19804_.m_135381_(STATE, (Object)state);
        if (state.texture() != null) {
            this.setTexture(state.texture());
        }
    }

    public void m_8107_() {
        if (this.m_5803_() || this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        }
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 7.0) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.party = false;
            this.jukebox = null;
        }
        super.m_8107_();
    }

    public void m_6818_(BlockPos pos, boolean isPartying) {
        this.jukebox = pos;
        this.party = isPartying;
    }

    @Override
    public void tryToSit() {
        if (!this.m_20069_()) {
            this.m_21564_(0.0f);
            this.setState(State.SIT);
            this.setSitting(true);
        }
    }

    @Override
    public boolean isSitting() {
        return this.getState() == State.SIT;
    }

    @Override
    public void setSitting(boolean sitting) {
        this.setState(sitting ? State.SIT : State.IDLE);
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public EntityPack<SpeartoothEntity> getPack() {
        return this.pack;
    }

    @Override
    public void setPack(@org.jetbrains.annotations.Nullable EntityPack<SpeartoothEntity> pack) {
        this.pack = pack;
    }

    @Override
    public boolean canPerformAction() {
        return !this.isEating() && !this.isSitting() && !this.m_5803_();
    }

    @Override
    public boolean isEating() {
        return this.getState() == State.EAT_OFF_GROUND;
    }

    @Override
    public void setEating(boolean eating) {
        this.setState(eating ? State.EAT_OFF_GROUND : State.IDLE);
    }

    @Override
    public ItemStack getItemInMouth() {
        return ItemStack.f_41583_;
    }

    @Override
    public void putItemInMouth(ItemStack item, boolean guaranteeDrop) {
    }

    @Override
    public boolean wantsMoreFood() {
        return false;
    }

    @Override
    public void gotFood(int ticks) {
    }

    @Override
    public boolean isWantedFood(ItemStack stack) {
        return false;
    }

    @Override
    public void takeFood(ItemStack stack) {
    }

    @Override
    public boolean isSleepingFlag() {
        return this.getState() == State.SLEEP;
    }

    public boolean m_5803_() {
        return this.isSleepingFlag();
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.setState(sleeping ? State.SLEEP : State.IDLE);
    }

    @Override
    public void prepareToStartSleeping() {
        this.m_5496_((SoundEvent)ModSounds.SPEARTOOTH_YAWN.get(), this.m_6121_(), this.m_6100_());
        this.setSleeping(true);
    }

    @Override
    public boolean canSleep() {
        if (this.m_21824_() && !this.m_21827_() && !this.m_5803_()) {
            return false;
        }
        return this.m_9236_().m_46462_() && !this.f_146808_ && this.m_21225_() == null && !this.f_146808_ && this.m_5448_() == null && this.m_21225_() == null;
    }

    @Override
    public boolean shouldFindShelter(boolean urgent) {
        return false;
    }

    @Override
    public void clearStates() {
        this.setState(State.IDLE);
        this.setTexture(Texture.DEFAULT);
        this.setSitting(false);
        this.setEating(false);
        this.setSleeping(false);
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.SPEARTOOTH_IDLE.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SPEARTOOTH_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModSounds.SPEARTOOTH_HURT.get();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.huntCooldown > 0 && source.m_7639_() instanceof LivingEntity) {
            this.huntCooldown = 0;
        }
        this.jukebox = null;
        this.party = false;
        return super.m_6469_(source, amount);
    }

    @Override
    public void roarIfPossible() {
        if (this.canRoar()) {
            this.setRoaring(true);
            this.setState(State.ROAR);
            this.roarTimer = State.ROAR.duration();
            this.lastRoarTime = this.m_9236_().m_46467_();
            this.m_5496_((SoundEvent)ModSounds.SPEARTOOTH_ROAR.get(), this.m_6121_(), this.m_6100_());
            for (Player player : this.m_9236_().m_45976_(Player.class, new AABB(this.m_20183_()).m_82400_((double)(((SoundEvent)ModSounds.SPEARTOOTH_ROAR.get()).m_215668_(this.m_6121_()) - 1.0f)))) {
                BlastFromThePast.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ScreenShakePayload(20.0f, 60));
            }
        }
    }

    @Override
    public boolean canRoar() {
        return !this.m_6162_() && this.getState() != State.ROAR && this.lastRoarTime + 400L < this.m_9236_().m_46467_();
    }

    @Override
    public boolean isRoaring() {
        return this.getState() == State.ROAR;
    }

    @Override
    public void setRoaring(boolean roaring) {
        this.setState(roaring ? State.ROAR : State.IDLE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 5, state1 -> {
            State state = this.getState();
            if (state == State.SLEEP) {
                return state1.setAndContinue(SLEEP);
            }
            if (this.m_6162_()) {
                if (state == State.COLD) {
                    return state1.setAndContinue(COLD);
                }
            } else {
                if (state == State.DANCE) {
                    return state1.setAndContinue(DANCE);
                }
                if (state == State.NOISE) {
                    return state1.setAndContinue(NOISE);
                }
                if (state == State.EAR) {
                    return state1.setAndContinue(EAR);
                }
                if (state == State.STRETCH) {
                    return state1.setAndContinue(STRETCH);
                }
                if (state == State.SIT) {
                    return state1.setAndContinue(SIT);
                }
                if (state == State.STALK) {
                    return state1.setAndContinue(STALK);
                }
                if (state == State.BITE) {
                    return state1.setAndContinue(BITE);
                }
                if (state == State.ROAR) {
                    return state1.setAndContinue(ROAR);
                }
                if (state == State.LUNGE) {
                    return state1.setAndContinue(LUNGE);
                }
            }
            if (state1.isMoving()) {
                if (!this.m_6162_() && this.m_5912_()) {
                    return state1.setAndContinue(RUN);
                }
                return state1.setAndContinue(WALK);
            }
            if (this.party && !this.m_6162_()) {
                return state1.setAndContinue(DANCE);
            }
            if (state != State.COLD && !state1.isMoving() && this.m_20096_()) {
                return state1.setAndContinue(IDLE);
            }
            return PlayState.STOP;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum State implements StateValue
    {
        IDLE(0),
        NOISE(1),
        EAR(2, 15),
        ROAR(3, 40),
        STRETCH(4, 45),
        GRIDDY(5),
        EAT_OFF_GROUND(6, 40),
        LUNGE(7, 15),
        RUN(8),
        STALK(9, 40, Texture.STALKING),
        DANCE(10, 30),
        WALK(11),
        SIT(12),
        SLEEP(13, Texture.SLEEPING),
        BITE(14, 15),
        COLD(15, 100);

        private final int id;
        private final int duration;
        @org.jetbrains.annotations.Nullable
        private final Texture texture;

        private State(int id) {
            this.id = id;
            this.duration = -1;
            this.texture = null;
        }

        private State(int id, int length) {
            this.id = id;
            this.duration = length;
            this.texture = null;
        }

        private State(int id, int length, Texture texture) {
            this.id = id;
            this.duration = length;
            this.texture = texture;
        }

        private State(int id, Texture texture) {
            this.id = id;
            this.duration = -1;
            this.texture = texture;
        }

        @Override
        public int id() {
            return this.id;
        }

        public int duration() {
            return this.duration;
        }

        @org.jetbrains.annotations.Nullable
        public Texture texture() {
            return this.texture;
        }
    }

    public static enum Texture implements StateValue
    {
        DEFAULT(0, null),
        AGGRESSIVE(1, "aggressive"),
        SLEEPING(2, "sleeping"),
        STALKING(3, "stalking");

        private final int id;
        @org.jetbrains.annotations.Nullable
        private final String suffix;
        private static final String PATH = "textures/entity/%sspeartooth%s.png";
        private static final BiFunction<Texture, Boolean, ResourceLocation> LOCATION;

        private Texture(int id, String suffix) {
            this.id = id;
            this.suffix = suffix;
        }

        @Override
        public int id() {
            return this.id;
        }

        @org.jetbrains.annotations.Nullable
        public String suffix() {
            return this.suffix;
        }

        public ResourceLocation textureId(boolean isBaby) {
            return LOCATION.apply(this, isBaby);
        }

        static {
            LOCATION = Util.m_143821_((texture, baby) -> BlastFromThePast.location(PATH.formatted(baby != false ? "baby_" : "", texture.suffix == null ? "" : "_" + texture.suffix)));
        }
    }

    protected static class SpeartoothGroupData
    extends EntityPackAgeableMobData<SpeartoothEntity> {
        public SpeartoothGroupData(EntityPack<SpeartoothEntity> entityPack, boolean shouldSpawnBaby) {
            super(entityPack, shouldSpawnBaby);
        }
    }
}

