/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.speartooth.ai;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLEnvironment;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.speartooth.SpeartoothEntity;
import team.recrafted.blastfromthepast.util.HitboxHelper;

public class SpeartoothRetreatGoal
extends Goal {
    protected final SpeartoothEntity tiger;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    @Nullable
    protected LivingEntity toAvoid;
    @Nullable
    protected Path path;
    protected final PathNavigation pathNav;
    private static final Predicate<Entity> PREDICATE = EntitySelector.f_20408_.and(EntitySelector.f_20402_);

    public SpeartoothRetreatGoal(SpeartoothEntity tiger, double walkSpeedModifier, double sprintSpeedModifier) {
        this.tiger = tiger;
        this.walkSpeedModifier = walkSpeedModifier;
        this.sprintSpeedModifier = sprintSpeedModifier;
        this.pathNav = tiger.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.toAvoid != null && (this.toAvoid.m_213877_() || HitboxHelper.getDistSqrBetweenHitboxes((Entity)this.tiger, (Entity)this.toAvoid) > (double)Mth.m_14207_((float)32.0f))) {
            this.toAvoid = null;
        }
        if (this.toAvoid == null) {
            this.toAvoid = this.tiger.m_21188_();
        }
        if (this.toAvoid == null) {
            return false;
        }
        if (this.tiger.shouldRetreat()) {
            Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.tiger, (int)16, (int)7, (Vec3)this.toAvoid.m_20182_());
            if (vec3 == null) {
                return false;
            }
            if (this.toAvoid.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.toAvoid.m_20280_((Entity)this.tiger)) {
                return false;
            }
            this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
            return this.path != null;
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.pathNav.m_26571_();
    }

    public void m_8056_() {
        this.tiger.m_6710_(null);
        this.tiger.setState(SpeartoothEntity.State.IDLE);
        this.tiger.setTexture(SpeartoothEntity.Texture.DEFAULT);
        this.pathNav.m_26536_(this.path, this.walkSpeedModifier);
        if (!FMLEnvironment.production) {
            BlastFromThePast.LOGGER.info("{} is retreating from {}", (Object)this.tiger, (Object)this.toAvoid);
        }
    }

    public void m_8041_() {
        this.toAvoid = null;
    }

    public void m_8037_() {
        if (this.tiger.m_20280_((Entity)this.toAvoid) < 49.0) {
            this.tiger.m_21573_().m_26517_(this.sprintSpeedModifier);
        } else {
            this.tiger.m_21573_().m_26517_(this.walkSpeedModifier);
        }
    }
}

