/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.speartooth.ai;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import team.recrafted.blastfromthepast.entity.speartooth.SpeartoothEntity;
import team.recrafted.blastfromthepast.entity.speartooth.ai.SpeartoothPounceTargetGoal;

public class SpeartoothStalkTargetGoal
extends Goal {
    protected final SpeartoothEntity tiger;
    private float speedModifier;
    private final PathNavigation navigation;
    private final float minStartDistance;
    @Nullable
    protected LivingEntity target;
    private int timeToRecalcPath;
    private final SpeartoothPounceTargetGoal pounceGoal;
    protected final float approachDistanceSqr;

    public SpeartoothStalkTargetGoal(SpeartoothEntity tiger, SpeartoothPounceTargetGoal pounceGoal, float minStartDistance, float approachDistance) {
        this.tiger = tiger;
        this.navigation = tiger.m_21573_();
        this.pounceGoal = pounceGoal;
        this.approachDistanceSqr = approachDistance * approachDistance;
        this.minStartDistance = minStartDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.tiger.m_6162_() || this.tiger.m_21824_() || this.tiger.lastStalkTime + 200L > this.tiger.m_9236_().m_46467_()) {
            return false;
        }
        if (this.tiger.m_5448_() != null && this.tiger.m_5448_() != this.tiger.lastTarget) {
            this.target = this.tiger.m_5448_();
        }
        return this.target != null && this.target.m_142065_() && this.tiger.m_20280_((Entity)this.target) >= (double)this.minStartDistance && !this.pounceGoal.m_8036_() && !this.isTargetPanicking();
    }

    public boolean m_8045_() {
        return this.target.m_142065_() && this.tiger.m_20280_((Entity)this.target) > (double)this.approachDistanceSqr && !this.pounceGoal.m_8036_() && !this.isTargetPanicking();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.speedModifier = 1.02f;
        this.navigation.m_5624_((Entity)this.target, (double)this.speedModifier);
        this.tiger.setState(SpeartoothEntity.State.STALK);
    }

    public void m_8041_() {
        if (!this.target.m_142065_()) {
            this.tiger.setTexture(SpeartoothEntity.Texture.DEFAULT);
            this.tiger.setState(SpeartoothEntity.State.IDLE);
        }
        this.navigation.m_26573_();
        this.tiger.lastTarget = this.target;
        this.target = null;
    }

    public void m_8037_() {
        Player player;
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_20142_()) {
            this.speedModifier = 1.7f;
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
        } else {
            this.navigation.m_5624_((Entity)this.target, (double)this.speedModifier);
        }
    }

    public boolean isTargetPanicking() {
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            for (WrappedGoal goal : mob.f_21345_.m_148105_()) {
                if (!(goal.m_26015_() instanceof PanicGoal) || !goal.m_7620_()) continue;
                return true;
            }
        }
        return false;
    }
}

