/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.events;

import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import team.recrafted.blastfromthepast.client.init.ModLayerLocations;
import team.recrafted.blastfromthepast.client.layers.FrostbiteAntlersLayer;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="blastfromthepast", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModLayerLocations.ANTLERS, FrostbiteAntlersLayer.AntlersModel::createHeadLayer);
    }

    @SubscribeEvent
    public static void construct(EntityRenderersEvent.AddLayers event) {
        ClientEvents.addLayerToHumanoid(event, EntityType.f_20529_, FrostbiteAntlersLayer::new);
        ClientEvents.addLayerToHumanoid(event, EntityType.f_20501_, FrostbiteAntlersLayer::new);
        ClientEvents.addLayerToHumanoid(event, EntityType.f_20524_, FrostbiteAntlersLayer::new);
        ClientEvents.addLayerToHumanoid(event, EntityType.f_20458_, FrostbiteAntlersLayer::new);
        ClientEvents.addLayerToHumanoid(event, EntityType.f_20562_, FrostbiteAntlersLayer::new);
        ClientEvents.addLayerToHumanoid(event, EntityType.f_20481_, FrostbiteAntlersLayer::new);
        for (String skin : event.getSkins()) {
            ClientEvents.addLayerToPlayerSkin(event, skin, FrostbiteAntlersLayer::new);
            ClientEvents.addLayerToPlayerSkin(event, skin, FrostbiteAntlersLayer::new);
        }
    }

    private static <E extends Player, M extends HumanoidModel<E>> void addLayerToPlayerSkin(EntityRenderersEvent.AddLayers event, String skinName, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
        LivingEntityRenderer renderer = event.getSkin(skinName);
        if (renderer != null) {
            renderer.m_115326_(factory.apply(renderer));
        }
    }

    private static <E extends LivingEntity, M extends HumanoidModel<E>> void addLayerToHumanoid(EntityRenderersEvent.AddLayers event, EntityType<E> entityType, Function<LivingEntityRenderer<E, M>, ? extends RenderLayer<E, M>> factory) {
        LivingEntityRenderer renderer = event.getRenderer(entityType);
        if (renderer != null) {
            renderer.m_115326_(factory.apply(renderer));
        }
    }
}

