/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.events;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import team.recrafted.blastfromthepast.block.BFTPWoodGroup;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModDecoratedPatterns;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.worldgen.biome.BFTPOverworldRegion;
import terrablender.api.Region;
import terrablender.api.Regions;

@Mod.EventBusSubscriber(modid="blastfromthepast", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonNeoEvents {
    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(ModDecoratedPatterns::expandVanillaPottery);
        CommonNeoEvents.registerFlammables();
        event.enqueueWork(() -> Regions.register((Region)new BFTPOverworldRegion(ResourceLocation.fromNamespaceAndPath((String)"blastfromthepast", (String)"overworld"), 1)));
    }

    @SubscribeEvent
    public static void registerSpawnPlacement(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)ModEntities.BURREL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.FROSTOMPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.SNOWDO.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.GLACEROS.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.PSYCHO_BEAR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.SPEARTOOTH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void registerFlammables() {
        CommonNeoEvents.registerWoodGroupFlammables(ModBlocks.CEDAR);
        CommonNeoEvents.flammableBlock((Block)ModBlocks.SAPPY_CEDAR_LOG.get(), 5, 6);
    }

    public static void registerWoodGroupFlammables(BFTPWoodGroup woodGroup) {
        CommonNeoEvents.flammableBlock((Block)woodGroup.LEAVES.get(), 5, 30);
        CommonNeoEvents.flammableBlock((Block)woodGroup.BLOCK.get(), 5, 20);
        CommonNeoEvents.flammableBlock((Block)woodGroup.DOOR.get(), 5, 20);
        CommonNeoEvents.flammableBlock((Block)woodGroup.SLAB.get(), 5, 20);
        CommonNeoEvents.flammableBlock((Block)woodGroup.STAIRS.get(), 5, 20);
        CommonNeoEvents.flammableBlock((Block)woodGroup.STRIPPED_LOG.get(), 5, 5);
        CommonNeoEvents.flammableBlock((Block)woodGroup.LOG.get(), 5, 5);
        CommonNeoEvents.flammableBlock((Block)woodGroup.STRIPPED_WOOD.get(), 5, 5);
        CommonNeoEvents.flammableBlock((Block)woodGroup.WOOD.get(), 5, 5);
        CommonNeoEvents.flammableBlock((Block)woodGroup.FENCE.get(), 5, 20);
        CommonNeoEvents.flammableBlock((Block)woodGroup.FENCE_GATE.get(), 5, 20);
    }

    public static void flammableBlock(Block block, int flameOdds, int burnOdds) {
        FireBlock fire = (FireBlock)Blocks.f_50083_;
        fire.m_53444_(block, flameOdds, burnOdds);
    }
}

