/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import team.recrafted.blastfromthepast.access.PlayerBFTPDataAccess;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.event.CurioDropsEvent;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosCompat {
    @SubscribeEvent
    public static void removeDroppedCurios(CurioDropsEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getCurioHandler().getWearer();
        if (livingEntity instanceof ServerPlayer && ((PlayerBFTPDataAccess)(player = (ServerPlayer)livingEntity)).bftp$hasInventoryStored()) {
            event.getDrops().clear();
        }
    }

    @Nullable
    public static List<ItemStack> getCuriosItems(ServerPlayer player) {
        LazyOptional curiosCap = player.getCapability(CuriosCapability.INVENTORY);
        ICuriosItemHandler curioCap = curiosCap.resolve().orElse(null);
        if (curioCap == null) {
            return null;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Map.Entry entry : curioCap.getCurios().entrySet()) {
            int i;
            ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
            IDynamicStackHandler stacks = stacksHandler.getStacks();
            IDynamicStackHandler cosmetics = stacksHandler.getCosmeticStacks();
            for (i = 0; i < stacks.getSlots(); ++i) {
                items.add(stacks.getStackInSlot(i));
            }
            for (i = 0; i < cosmetics.getSlots(); ++i) {
                items.add(cosmetics.getStackInSlot(i));
            }
        }
        return items;
    }
}

