/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.events;

import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.block.BearTrapBlockEntity;
import team.recrafted.blastfromthepast.entity.GlacerosEntity;
import team.recrafted.blastfromthepast.entity.HollowEntity;
import team.recrafted.blastfromthepast.entity.TarArrow;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModMobEffects;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.network.PsychoedEffectPayload;
import team.recrafted.blastfromthepast.util.EntityHelper;

@Mod.EventBusSubscriber(modid="blastfromthepast", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    public static Predicate<BlockState> PERMAFROST_PREDICATE = state -> {
        Block block = state.m_60734_();
        if (block == Blocks.f_50069_) {
            return true;
        }
        if (state.m_60795_()) {
            return false;
        }
        return block == Blocks.f_50228_ || block == Blocks.f_50334_ || block == Blocks.f_50122_ || block == Blocks.f_49997_ || block == Blocks.f_152505_ || block == Blocks.f_50089_ || block == Blocks.f_50264_ || block == Blocks.f_49995_ || block == Blocks.f_49996_ || block == Blocks.f_50059_ || block == Blocks.f_50173_;
    };
    public static Function<BlockState, BlockState> PERMAFROST_FUNCTION = state -> {
        Block block = state.m_60734_();
        if (block == Blocks.f_50069_) {
            return ((Block)ModBlocks.PERMAFROST.STONE.get()).m_49966_();
        }
        ResourceLocation location = BuiltInRegistries.f_256975_.m_7981_((Object)block);
        if (block == Blocks.f_50122_) {
            return Blocks.f_50126_.m_49966_();
        }
        if (block == Blocks.f_50228_) {
            return Blocks.f_50354_.m_49966_();
        }
        if (block == Blocks.f_50334_) {
            return Blocks.f_50568_.m_49966_();
        }
        Block newBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(BlastFromThePast.location("permafrost_" + location.m_135815_()));
        if (newBlock != Blocks.f_50016_) {
            return newBlock.m_49966_();
        }
        return state;
    };

    @SubscribeEvent
    public static void chunkLoad(ChunkEvent.Load event) {
        if (!event.isNewChunk()) {
            return;
        }
    }

    @SubscribeEvent
    public static void playerInteractEvent(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof GlacerosEntity) {
            GlacerosEntity glaceros = (GlacerosEntity)entity;
            if (event.getItemStack().m_150930_(Items.f_42574_) && !glaceros.m_6162_() && !glaceros.isSheared()) {
                glaceros.setSheared(true);
                glaceros.antlerGrowCooldown = 1000 + glaceros.m_217043_().m_188503_(300);
                if (!event.getEntity().m_7500_()) {
                    event.getEntity().m_21120_(event.getHand()).m_41721_(1);
                }
                event.getLevel().m_245803_(event.getTarget(), event.getPos(), (SoundEvent)ModSounds.GLACEROS_SHEAR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                event.getEntity().m_6674_(event.getHand());
                ItemStack antlers = new ItemStack((ItemLike)glaceros.getVariant().getAntlerItem(), 2);
                event.getLevel().m_7967_((Entity)new ItemEntity(event.getLevel(), glaceros.m_20185_(), glaceros.m_20186_() + 0.5, glaceros.m_20189_(), antlers));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (player.m_21023_((MobEffect)ModMobEffects.PSYCHOD.get())) {
                BlastFromThePast.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new PsychoedEffectPayload(false));
            }
            if (EntityHelper.shouldCreateHollow(player)) {
                ItemStack idol = EntityHelper.getIdolOfRetrievalInHand(player);
                if (idol != null) {
                    CriteriaTriggers.f_10592_.m_23682_(player, idol);
                    idol.m_41774_(1);
                }
                HollowEntity hollow = HollowEntity.create(player);
                player.m_284548_().m_7967_((Entity)hollow);
            }
        }
    }

    @SubscribeEvent
    public static void onArrowHit(ProjectileImpactEvent event) {
        if (event.getRayTraceResult().m_6662_() == HitResult.Type.BLOCK && event.getProjectile() instanceof TarArrow) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getHitVec().m_82425_();
        Level level = event.getLevel();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BearTrapBlockEntity) {
            BearTrapBlockEntity blockEntity2 = (BearTrapBlockEntity)blockEntity;
            blockEntity2.interact(level, pos, event.getEntity());
        }
    }

    @SubscribeEvent
    public static void effectAdded(MobEffectEvent.Added event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getEffectInstance().m_19544_().equals(ModMobEffects.PSYCHOD.get())) {
                BlastFromThePast.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new PsychoedEffectPayload(true));
            }
        }
    }

    @SubscribeEvent
    public static void effectRemoved(MobEffectEvent.Remove event) {
        LivingEntity livingEntity;
        if (event.getEffectInstance() != null && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getEffectInstance().m_19544_().equals(ModMobEffects.PSYCHOD.get())) {
                BlastFromThePast.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new PsychoedEffectPayload(false));
            }
        }
    }

    @SubscribeEvent
    public static void effectExpired(MobEffectEvent.Expired event) {
        LivingEntity livingEntity;
        if (event.getEffectInstance() != null && (livingEntity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getEffectInstance().m_19544_().equals(ModMobEffects.PSYCHOD.get())) {
                BlastFromThePast.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new PsychoedEffectPayload(false));
            }
        }
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().m_21023_((MobEffect)ModMobEffects.PSYCHOD.get())) {
            BlastFromThePast.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new PsychoedEffectPayload(true));
        }
    }
}

