/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.init;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModPlacedFeatures;
import team.recrafted.blastfromthepast.init.ModSounds;

public class ModBiomes {
    public static final ResourceKey<Biome> FROSTBITE_FOREST = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"blastfromthepast", (String)"frostbite_forest"));
    public static final ResourceKey<Biome> FROSTBITE_RIVER = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"blastfromthepast", (String)"frostbite_river"));
    public static final int FROSTBITE_WATER_COLOR = 8764102;
    public static final int FROSTBITE_WATER_FOG_COLOR = 8764102;
    public static final int FROSTBITE_GRASS_COLOR = 6000247;
    public static final int FROSBITE_FOLIAGE_COLOR = 6000247;

    public static void register(BootstapContext<Biome> biomeBootstrapContext) {
        HolderGetter holdergetter = biomeBootstrapContext.m_255420_(Registries.f_256988_);
        HolderGetter worldCarvers = biomeBootstrapContext.m_255420_(Registries.f_257003_);
        biomeBootstrapContext.m_255272_(FROSTBITE_FOREST, (Object)ModBiomes.frostbiteForest((HolderGetter<PlacedFeature>)holdergetter, worldCarvers));
        biomeBootstrapContext.m_255272_(FROSTBITE_RIVER, (Object)ModBiomes.frostbiteRiver((HolderGetter<PlacedFeature>)holdergetter, worldCarvers));
    }

    public static Biome frostbiteForest(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        mobspawnsettings$builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.BURREL.get(), 8, 1, 2)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SNOWDO.get(), 8, 2, 5)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GLACEROS.get(), 8, 3, 7)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SPEARTOOTH.get(), 8, 3, 6)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.PSYCHO_BEAR.get(), 8, 1, 1)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.FROSTOMPER.get(), 8, 1, 6));
        BiomeGenerationSettings.Builder biomeGenBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        biomeGenBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, ModPlacedFeatures.FROSTBITE_FOSSILS_UPPER);
        biomeGenBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, ModPlacedFeatures.FROSTBITE_FOSSILS_LOWER);
        ModBiomes.globalOverworldGeneration(biomeGenBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeGenBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeGenBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeGenBuilder);
        ModBiomes.addFrostbiteForestTrees(biomeGenBuilder);
        ModBiomes.addFrostbiteForestFlowers(biomeGenBuilder);
        biomeGenBuilder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, ModPlacedFeatures.PERMAFROST_BOULDERS);
        ModBiomes.addTarPits(biomeGenBuilder);
        BiomeDefaultFeatures.m_126726_((BiomeGenerationSettings.Builder)biomeGenBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeGenBuilder);
        BiomeDefaultFeatures.m_198931_((BiomeGenerationSettings.Builder)biomeGenBuilder);
        biomeGenBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PSYCHO_BERRY);
        return ModBiomes.biome(true, -0.5f, 0.4f, 8764102, 8764102, 6000247, 6000247, mobspawnsettings$builder, biomeGenBuilder);
    }

    private static void addTarPits(BiomeGenerationSettings.Builder biomeBuilder) {
        biomeBuilder.m_255155_(GenerationStep.Decoration.LAKES, ModPlacedFeatures.TAR_PIT);
    }

    private static void addFrostbiteForestTrees(BiomeGenerationSettings.Builder biomegenerationsettings$builder) {
        biomegenerationsettings$builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.CEDAR_TREE);
        biomegenerationsettings$builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.RUSTY_CEDAR_TREE);
    }

    private static void addFrostbiteForestFlowers(BiomeGenerationSettings.Builder biomegenerationsettings$builder) {
        biomegenerationsettings$builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.FROSTBITE_FOREST_FLOWERS);
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder generationSettings) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)generationSettings);
    }

    private static Biome biome(boolean hasPrecipitation, float temperature, float downfall, int waterColor, int waterFogColor, @Nullable Integer grassColorOverride, @Nullable Integer foliageColorOverride, MobSpawnSettings.Builder mobSpawnSettings, BiomeGenerationSettings.Builder generationSettings) {
        BiomeSpecialEffects.Builder biomespecialeffects$builder = new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(12638463).m_48040_(ModBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(new Music(Holder.m_205709_((Object)((SoundEvent)ModSounds.AURORA_FROLICS.get())), 0, 12000, true));
        if (grassColorOverride != null) {
            biomespecialeffects$builder.m_48045_(grassColorOverride.intValue());
        }
        if (foliageColorOverride != null) {
            biomespecialeffects$builder.m_48043_(foliageColorOverride.intValue());
        }
        return new Biome.BiomeBuilder().m_264558_(hasPrecipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(biomespecialeffects$builder.m_48018_()).m_47605_(mobSpawnSettings.m_48381_()).m_47601_(generationSettings.m_255380_()).m_47592_();
    }

    protected static int calculateSkyColor(float temperature) {
        float skyColor = temperature / 3.0f;
        skyColor = Mth.m_14036_((float)skyColor, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - skyColor * 0.05f), (float)(0.5f + skyColor * 0.1f), (float)1.0f);
    }

    public static Biome frostbiteRiver(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        mobspawnsettings$builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.BURREL.get(), 8, 1, 2)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SNOWDO.get(), 8, 2, 5)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GLACEROS.get(), 8, 3, 7)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SPEARTOOTH.get(), 8, 3, 6)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.PSYCHO_BEAR.get(), 8, 1, 1)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.FROSTOMPER.get(), 8, 1, 6));
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        ModBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        ModBiomes.addFrostbiteForestTrees(biomegenerationsettings$builder);
        ModBiomes.addFrostbiteForestFlowers(biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.CHILLY_MOSS);
        return ModBiomes.biome(true, -0.5f, 0.5f, 8764102, 8764102, 6000247, 6000247, mobspawnsettings$builder, biomegenerationsettings$builder);
    }
}

