/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.init;

import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;
import team.recrafted.blastfromthepast.BlastFromThePast;

public class ModCriteriaTriggers {
    public static final DanceTrigger DANCE_TRIGGER = new DanceTrigger();
    public static final PacifyBearTrigger PACIFY_BEAR_TRIGGER = new PacifyBearTrigger();

    public static void init() {
    }

    public static class DanceTrigger
    extends SimpleCriterionTrigger<TriggerInstance> {
        @NotNull
        protected TriggerInstance createInstance(@NotNull JsonObject jsonObject, @NotNull ContextAwarePredicate contextAwarePredicate, @NotNull DeserializationContext deserializationContext) {
            ContextAwarePredicate lootContextPredicate1 = EntityPredicate.m_285855_((JsonObject)jsonObject, (String)"player", (DeserializationContext)deserializationContext);
            ContextAwarePredicate lootContextPredicate2 = EntityPredicate.m_285855_((JsonObject)jsonObject, (String)"entity", (DeserializationContext)deserializationContext);
            return new TriggerInstance(contextAwarePredicate, Optional.of(lootContextPredicate1), Optional.of(lootContextPredicate2));
        }

        public void trigger(ServerPlayer player, Animal entity) {
            LootContext lootcontext = EntityPredicate.m_36616_((ServerPlayer)player, (Entity)entity);
            this.m_66234_(player, p_68838_ -> p_68838_.matches(lootcontext));
        }

        @NotNull
        public ResourceLocation m_7295_() {
            return ResourceLocation.fromNamespaceAndPath((String)"blastfromthepast", (String)"dance_trigger");
        }

        public static class TriggerInstance
        extends AbstractCriterionTriggerInstance {
            Optional<ContextAwarePredicate> player;
            Optional<ContextAwarePredicate> entity;

            public TriggerInstance(ContextAwarePredicate contextAwarePredicate, Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> entity) {
                super(BlastFromThePast.location("dance_trigger"), contextAwarePredicate);
                this.player = player;
                this.entity = entity;
            }

            public static Criterion madeEntityDance(EntityPredicate.Builder entity) {
                return new Criterion((CriterionTriggerInstance)new TriggerInstance(ContextAwarePredicate.f_285567_, Optional.empty(), Optional.of(EntityPredicate.m_285787_((EntityPredicate)entity.m_36662_()))));
            }

            public boolean matches(LootContext lootContext) {
                return this.entity.isEmpty() || this.entity.get().m_285831_(lootContext);
            }
        }
    }

    public static class PacifyBearTrigger
    extends SimpleCriterionTrigger<TriggerInstance> {
        protected TriggerInstance createInstance(JsonObject jsonObject, ContextAwarePredicate contextAwarePredicate, DeserializationContext deserializationContext) {
            ContextAwarePredicate lootContextPredicate1 = EntityPredicate.m_285855_((JsonObject)jsonObject, (String)"player", (DeserializationContext)deserializationContext);
            ContextAwarePredicate lootContextPredicate2 = EntityPredicate.m_285855_((JsonObject)jsonObject, (String)"entity", (DeserializationContext)deserializationContext);
            return new TriggerInstance(contextAwarePredicate, Optional.of(lootContextPredicate1), Optional.of(lootContextPredicate2));
        }

        public void trigger(ServerPlayer player, Animal entity) {
            LootContext lootcontext = EntityPredicate.m_36616_((ServerPlayer)player, (Entity)entity);
            this.m_66234_(player, p_68838_ -> p_68838_.matches(lootcontext));
        }

        public ResourceLocation m_7295_() {
            return BlastFromThePast.location("pacify_bear_trigger");
        }

        public static class TriggerInstance
        extends AbstractCriterionTriggerInstance {
            Optional<ContextAwarePredicate> player;
            Optional<ContextAwarePredicate> entity;

            public TriggerInstance(ContextAwarePredicate contextAwarePredicate, Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> entity) {
                super(BlastFromThePast.location("pacify_bear_trigger"), contextAwarePredicate);
                this.player = player;
                this.entity = entity;
            }

            public static Criterion madeEntityDance(EntityPredicate.Builder entity) {
                return new Criterion((CriterionTriggerInstance)new TriggerInstance(ContextAwarePredicate.f_285567_, Optional.empty(), Optional.of(EntityPredicate.m_285787_((EntityPredicate)entity.m_36662_()))));
            }

            public boolean matches(LootContext lootContext) {
                return this.entity.isEmpty() || this.entity.get().m_285831_(lootContext);
            }
        }
    }
}

