/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.init;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import team.recrafted.blastfromthepast.entity.FrostomperEntity;
import team.recrafted.blastfromthepast.entity.misc.StateValue;
import team.recrafted.blastfromthepast.entity.misc.TransitioningState;
import team.recrafted.blastfromthepast.entity.speartooth.SpeartoothEntity;

public class ModDataSerializers {
    public static final DeferredRegister<EntityDataSerializer<?>> DATA_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)"blastfromthepast");
    public static final RegistryObject<EntityDataSerializer<TransitioningState>> TRANSITIONING_STATE = ModDataSerializers.register("transitioning_state", TransitioningState.class);
    public static final RegistryObject<EntityDataSerializer<FrostomperEntity.IdleState>> FROSTOMPER_IDLE_STATE = ModDataSerializers.register("frostomper_idle_state", FrostomperEntity.IdleState.class);
    public static final RegistryObject<EntityDataSerializer<SpeartoothEntity.State>> SPEARTOOTH_STATE = ModDataSerializers.register("speartooth_state", SpeartoothEntity.State.class);
    public static final RegistryObject<EntityDataSerializer<SpeartoothEntity.Texture>> SPEARTOOTH_TEXTURE = ModDataSerializers.register("speartooth_texture", SpeartoothEntity.Texture.class);

    private static <E extends StateValue> RegistryObject<EntityDataSerializer<E>> register(String name, final Class<E> enumClass) {
        return DATA_SERIALIZERS.register(name, () -> new EntityDataSerializer<E>(){

            public void write(FriendlyByteBuf buf, E value) {
                buf.m_130130_(value.id());
            }

            public E read(FriendlyByteBuf buf) {
                int id = buf.m_130242_();
                StateValue[] values = (StateValue[])enumClass.getEnumConstants();
                return id >= 0 && id < values.length ? values[id] : values[0];
            }

            public E copy(E value) {
                return value;
            }
        });
    }
}

