/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import team.recrafted.blastfromthepast.entity.BurrelEntity;
import team.recrafted.blastfromthepast.entity.FrostomperEntity;
import team.recrafted.blastfromthepast.entity.GlacerosEntity;
import team.recrafted.blastfromthepast.entity.HollowEntity;
import team.recrafted.blastfromthepast.entity.PsychoBearEntity;
import team.recrafted.blastfromthepast.entity.SapEntity;
import team.recrafted.blastfromthepast.entity.SnowdoEntity;
import team.recrafted.blastfromthepast.entity.TarArrow;
import team.recrafted.blastfromthepast.entity.boats.BFTPBoat;
import team.recrafted.blastfromthepast.entity.boats.BFTPChestBoat;
import team.recrafted.blastfromthepast.entity.projectile.ThrownIceSpear;
import team.recrafted.blastfromthepast.entity.speartooth.SpeartoothEntity;
import team.recrafted.blastfromthepast.util.HitboxHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.f_256939_, (String)"blastfromthepast");
    public static final RegistryObject<EntityType<GlacerosEntity>> GLACEROS = ModEntities.registerMob("glaceros", GlacerosEntity::new, 1.0f, 2.2f);
    public static final RegistryObject<EntityType<SnowdoEntity>> SNOWDO = ModEntities.registerMob("snowdo", SnowdoEntity::new, 0.6f, 1.1f);
    public static final RegistryObject<EntityType<FrostomperEntity>> FROSTOMPER = ModEntities.registerMobWithEyeHeight("frostomper", FrostomperEntity::new, 4.0f, HitboxHelper.pixelsToBlocks(70.0f));
    public static final RegistryObject<EntityType<SpeartoothEntity>> SPEARTOOTH = ModEntities.registerMobWithEyeHeight("speartooth", SpeartoothEntity::new, 0.9f, 1.3f);
    public static final RegistryObject<EntityType<BurrelEntity>> BURREL = ModEntities.registerMob("burrel", BurrelEntity::new, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<ThrownIceSpear>> ICE_SPEAR = ENTITIES.register("ice_spear", () -> EntityType.Builder.m_20704_(ThrownIceSpear::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20).m_20712_("ice_spear"));
    public static final RegistryObject<EntityType<SapEntity>> SAP = ENTITIES.register("sap", () -> EntityType.Builder.m_20704_(SapEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(10).m_20717_(Integer.MAX_VALUE).m_20712_(ModEntities.getName("sap")));
    public static final RegistryObject<EntityType<BFTPBoat>> BFTPBOAT = ENTITIES.register("boat", () -> EntityType.Builder.m_20704_(BFTPBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_(ModEntities.getName("boat")));
    public static final RegistryObject<EntityType<BFTPChestBoat>> BFTPCHEST_BOAT = ENTITIES.register("chest_boat", () -> EntityType.Builder.m_20704_(BFTPChestBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_(ModEntities.getName("chest_boat")));
    public static final RegistryObject<EntityType<PsychoBearEntity>> PSYCHO_BEAR = ENTITIES.register("psycho_bear", () -> EntityType.Builder.m_20704_(PsychoBearEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(HitboxHelper.pixelsToBlocks(53.0f), HitboxHelper.pixelsToBlocks(33.0f)).m_20714_(new Block[]{Blocks.f_50685_}).m_20712_("psycho_bear"));
    public static final RegistryObject<EntityType<HollowEntity>> HOLLOW = ENTITIES.register("hollow", () -> EntityType.Builder.m_20704_(HollowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.3f, 2.3f).m_20702_(10).m_20712_(ModEntities.getName("hollow")));
    public static final RegistryObject<EntityType<TarArrow>> TAR_ARROW = ENTITIES.register("tar_arrow", () -> EntityType.Builder.m_20704_(TarArrow::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20712_(ModEntities.getName("tar_arrow")));

    public static <T extends Mob> RegistryObject<EntityType<T>> registerMob(String name, EntityType.EntityFactory<T> entity, float width, float height) {
        RegistryObject entityType = ENTITIES.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)entity, (MobCategory)MobCategory.CREATURE).m_20699_(width, height).m_20712_(name));
        return entityType;
    }

    public static <T extends Mob> RegistryObject<EntityType<T>> registerMobWithEyeHeight(String name, EntityType.EntityFactory<T> entity, float width, float height) {
        return ENTITIES.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)entity, (MobCategory)MobCategory.CREATURE).m_20699_(width, height).m_20712_(name));
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)GLACEROS.get(), GlacerosEntity.createAttributes().m_22265_());
        event.put((EntityType)SNOWDO.get(), SnowdoEntity.createAttributes().m_22265_());
        event.put((EntityType)SPEARTOOTH.get(), SpeartoothEntity.createAttributes().m_22265_());
        event.put((EntityType)BURREL.get(), BurrelEntity.createAttributes().m_22265_());
        event.put((EntityType)FROSTOMPER.get(), FrostomperEntity.createAttributes().m_22265_());
        event.put((EntityType)PSYCHO_BEAR.get(), PsychoBearEntity.createAttributes().m_22265_());
        event.put((EntityType)HOLLOW.get(), HollowEntity.m_21183_().m_22268_(Attributes.f_22276_, 200.0).m_22265_());
    }

    private static String getName(String name) {
        return "blastfromthepast:" + name;
    }
}

