/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.access.PlayerBFTPDataAccess;
import team.recrafted.blastfromthepast.client.vfx.ScreenShake;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.network.BearGloveWallAnimPayload;
import team.recrafted.blastfromthepast.util.ClientUtils;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PlayerBFTPDataAccess {
    @Unique
    private boolean bftp$inventoryStored = false;
    @Unique
    private boolean bftp$shouldPlayBearGloveWallAnim = false;
    @Unique
    private ScreenShake bftp$screenShake = null;

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract SoundSource m_5720_();

    @Inject(method={"dropEquipment"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;destroyVanishingCursedItems()V", shift=At.Shift.AFTER)}, cancellable=true)
    private void dropEquipment(CallbackInfo ci) {
        if (this.bftp$inventoryStored) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        Player player = (Player)this;
        if (!player.m_9236_().f_46443_) {
            return;
        }
        if (ClientUtils.isPlayerHoldingSpace(player) && player.f_19862_ && player.m_21205_().m_41720_() == ModItems.BEAR_GLOVES.get() && player.m_21206_().m_41720_() == ModItems.BEAR_GLOVES.get()) {
            Vec3 delta = player.m_20184_();
            player.m_20334_(delta.f_82479_, 0.0, delta.f_82481_);
            if (!this.bftp$shouldPlayBearGloveWallAnim) {
                this.bftp$shouldPlayBearGloveWallAnim = true;
                player.m_183634_();
                BlastFromThePast.INSTANCE.sendToServer((Object)new BearGloveWallAnimPayload(player.m_20148_(), true));
            }
        } else if (this.bftp$shouldPlayBearGloveWallAnim) {
            this.bftp$shouldPlayBearGloveWallAnim = false;
            BlastFromThePast.INSTANCE.sendToServer((Object)new BearGloveWallAnimPayload(player.m_20148_(), false));
        }
        if (this.bftp$screenShake != null) {
            this.bftp$screenShake.incrementElapsedTicks();
            if (this.bftp$screenShake.elapsedTicks > this.bftp$screenShake.maxDuration) {
                this.bftp$screenShake = null;
            }
        }
    }

    @WrapWithCondition(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V")})
    private boolean shouldPlayAttackSound(Level instance, Player player, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch) {
        return this.m_21205_().m_41720_() != ModItems.BEAR_GLOVES.get();
    }

    @Inject(method={"attack"}, at={@At(value="TAIL")})
    private void playBearClawSound(Entity target, CallbackInfo ci) {
        if (this.m_21205_().m_41720_() != ModItems.BEAR_GLOVES.get()) {
            return;
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.BEAR_GLOVE_SLASH.get(), this.m_5720_(), 1.0f, 1.0f);
    }

    @Override
    @Unique
    public void bftp$markInventoryStored() {
        this.bftp$inventoryStored = true;
    }

    @Override
    @Unique
    public boolean bftp$hasInventoryStored() {
        return this.bftp$inventoryStored;
    }

    @Override
    public void bftp$setShouldPlayBearGloveWallAnim(boolean value) {
        this.bftp$shouldPlayBearGloveWallAnim = value;
    }

    @Override
    public boolean bftp$shouldPlayBearGloveWallAnim() {
        return this.bftp$shouldPlayBearGloveWallAnim;
    }

    @Override
    public void bftp$setScreenShake(ScreenShake screenShake) {
        this.bftp$screenShake = screenShake;
    }

    @Override
    public ScreenShake bftp$getScreenShake() {
        return this.bftp$screenShake;
    }
}

