/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.network.handlers;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.access.PlayerBFTPDataAccess;
import team.recrafted.blastfromthepast.client.vfx.ScreenShake;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.network.BearGloveWallAnimPayload;
import team.recrafted.blastfromthepast.network.PsychoedEffectPayload;
import team.recrafted.blastfromthepast.network.ScreenShakePayload;

public class ClientPayloadHandler {
    public static void handleBearGloveAnim(BearGloveWallAnimPayload payload, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPayloadHandler.handleClientBearGlove(payload)));
        if (payload.shouldPlay()) {
            ctx.get().getSender().m_9236_().m_5594_(null, ctx.get().getSender().m_20183_(), (SoundEvent)ModSounds.WALL_GRAB.get(), SoundSource.PLAYERS, 1.0f, 1.0f + (float)ctx.get().getSender().m_217043_().m_216332_(-5, 5) / 100.0f);
        }
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClientBearGlove(BearGloveWallAnimPayload payload) {
        Player player = Minecraft.m_91087_().f_91073_.m_46003_(payload.player());
        if (player instanceof PlayerBFTPDataAccess) {
            PlayerBFTPDataAccess dataAccess = (PlayerBFTPDataAccess)player;
            dataAccess.bftp$setShouldPlayBearGloveWallAnim(payload.shouldPlay());
        }
    }

    public static void handlePsychoedShader(PsychoedEffectPayload payload, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft.m_91087_().f_91063_.m_109086_();
            if (payload.shouldApply()) {
                Minecraft.m_91087_().f_91063_.m_109128_(BlastFromThePast.location("shaders/post/psycho.json"));
            }
        }));
        ctx.get().setPacketHandled(true);
    }

    public static void handleScreenShake(ScreenShakePayload payload, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ((PlayerBFTPDataAccess)Minecraft.m_91087_().f_91074_).bftp$setScreenShake(new ScreenShake(payload.strength(), payload.duration()))));
        ctx.get().setPacketHandled(true);
    }
}

