/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.util;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import team.recrafted.blastfromthepast.entity.HollowEntity;
import team.recrafted.blastfromthepast.entity.ai.goal.CustomPanicGoal;
import team.recrafted.blastfromthepast.entity.misc.AnimatedAttacker;
import team.recrafted.blastfromthepast.init.ModEnchantments;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.init.ModTags;

public class EntityHelper {
    private static final GameProfile BLAST_FROM_THE_PAST = new GameProfile(UUID.fromString("cf41e056-477d-4afa-bcdb-39d84cb95f14"), "[Blast From The Past]");

    public static void spawnSmashAttackParticles(LevelAccessor level, AABB attackBounds, int power) {
        double zSpeed;
        double ySpeed;
        double xSpeed;
        double z;
        double y;
        double x;
        Vec3 boundsBottomCenter = new Vec3(Mth.m_14139_((double)0.5, (double)attackBounds.f_82288_, (double)attackBounds.f_82291_), attackBounds.f_82289_, Mth.m_14139_((double)0.5, (double)attackBounds.f_82290_, (double)attackBounds.f_82293_));
        double radius = EntityHelper.getXZSize(attackBounds);
        double halfRadius = radius * 0.5;
        BlockPos pos = BlockPos.m_274446_((Position)boundsBottomCenter.m_82492_(0.0, (double)1.0E-5f, 0.0));
        Vec3 particleCenter = boundsBottomCenter.m_82520_(0.0, 0.5, 0.0);
        BlockParticleOption dustPillar = new BlockParticleOption(ParticleTypes.f_123794_, level.m_8055_(pos));
        int index = 0;
        while ((double)index < (double)power / radius) {
            x = particleCenter.f_82479_ + level.m_213780_().m_188583_() / 2.0;
            y = particleCenter.f_82480_;
            z = particleCenter.f_82481_ + level.m_213780_().m_188583_() / 2.0;
            xSpeed = level.m_213780_().m_188583_() * 0.2;
            ySpeed = level.m_213780_().m_188583_() * 0.2;
            zSpeed = level.m_213780_().m_188583_() * 0.2;
            level.m_7106_((ParticleOptions)dustPillar, x, y, z, xSpeed, ySpeed, zSpeed);
            ++index;
        }
        index = 0;
        while ((double)index < (double)power / halfRadius) {
            x = particleCenter.f_82479_ + attackBounds.m_82362_() * Math.cos(index) + level.m_213780_().m_188583_() / 2.0;
            y = particleCenter.f_82480_;
            z = particleCenter.f_82481_ + attackBounds.m_82385_() * Math.sin(index) + level.m_213780_().m_188583_() / 2.0;
            xSpeed = level.m_213780_().m_188583_() * 0.05;
            ySpeed = level.m_213780_().m_188583_() * 0.05;
            zSpeed = level.m_213780_().m_188583_() * 0.05;
            level.m_7106_((ParticleOptions)dustPillar, x, y, z, xSpeed, ySpeed, zSpeed);
            ++index;
        }
    }

    public static double getXZSize(AABB bounds) {
        double xSize = bounds.m_82362_();
        double zSize = bounds.m_82385_();
        return (xSize + zSize) / 2.0;
    }

    public static <T extends Mob, A extends AnimatedAttacker.AttackType<T, A>> List<LivingEntity> hitTargetsWithAOEAttack(T attacker, AABB attackBounds, float attackDamage, float attackKnockback, boolean spawnParticles) {
        ArrayList<LivingEntity> hitTargets = new ArrayList<LivingEntity>();
        if (!attacker.m_9236_().f_46443_) {
            List targets = attacker.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.f_26872_, attacker, attackBounds);
            targets.forEach(target -> {
                boolean hurtTarget;
                if (target.f_19802_ <= 0 && (hurtTarget = EntityHelper.doHurtTarget((LivingEntity)attacker, target, attackDamage, attackKnockback))) {
                    hitTargets.add((LivingEntity)target);
                }
            });
        } else if (spawnParticles) {
            EntityHelper.spawnSmashAttackParticles((LevelAccessor)attacker.m_9236_(), attackBounds, 750);
        }
        return hitTargets;
    }

    public static boolean doHurtTarget(LivingEntity attacker, LivingEntity target, float attackDamage, float attackKnockback) {
        boolean flag;
        int i;
        if (target instanceof LivingEntity) {
            attackDamage += EnchantmentHelper.m_44833_((ItemStack)attacker.m_21205_(), (MobType)target.m_6336_());
            attackKnockback += (float)EnchantmentHelper.m_44894_((LivingEntity)attacker);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)attacker)) > 0) {
            target.m_20254_(i * 4);
        }
        if (flag = target.m_6469_(attacker.m_269291_().m_269333_(attacker), attackDamage)) {
            if (attackKnockback > 0.0f && target instanceof LivingEntity) {
                target.m_147240_((double)(attackKnockback * 0.5f), (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
                attacker.m_20256_(attacker.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (target instanceof Player) {
                Player player = (Player)target;
                if (attacker instanceof Mob) {
                    Mob mob = (Mob)attacker;
                    mob.m_21424_(player, attacker.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
                }
            }
            attacker.m_19970_(attacker, (Entity)target);
            attacker.m_21335_((Entity)target);
        }
        return flag;
    }

    public static void throwTarget(LivingEntity attacker, LivingEntity target, double attackKnockback) {
        double knockbackResistance = target.m_21133_(Attributes.f_22278_);
        double effectiveKnockback = attackKnockback - knockbackResistance;
        if (effectiveKnockback > 0.0) {
            double knockbackScale = effectiveKnockback * 0.5;
            Vec3 knockbackVec = attacker.m_20252_(1.0f).m_82541_().m_82490_(knockbackScale);
            target.m_5997_(knockbackVec.f_82479_, knockbackScale, knockbackVec.f_82481_);
            target.f_19864_ = true;
        }
    }

    public static void strongKnockback(LivingEntity attacker, LivingEntity target, double attackKnockback) {
        double knockbackResistance = target.m_21133_(Attributes.f_22278_);
        double effectiveKnockback = attackKnockback - knockbackResistance;
        if (effectiveKnockback > 0.0) {
            Vec3 knockbackVec = attacker.m_20252_(1.0f).m_82541_().m_82490_(effectiveKnockback);
            target.m_5997_(knockbackVec.f_82479_, target.m_20096_() ? Math.min(0.4, effectiveKnockback) : 0.0, knockbackVec.f_82481_);
            target.f_19864_ = true;
        }
    }

    public static <T extends PathfinderMob> Predicate<T> getPanicInducingDamageTypes() {
        return mob -> mob.m_6162_() ? CustomPanicGoal.isMobDamage((Mob)mob) || CustomPanicGoal.isEnvironmentDamage((Mob)mob) : CustomPanicGoal.isEnvironmentDamage((Mob)mob);
    }

    public static FakePlayer getFakePlayer(ServerLevel serverLevel) {
        return FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)BLAST_FROM_THE_PAST);
    }

    public static double getFollowRange(Mob mob) {
        return mob.m_21133_(Attributes.f_22277_);
    }

    public static boolean hasBlocksAbove(PathfinderMob mob, BlockPos targetPos) {
        return !mob.m_9236_().m_45527_(targetPos) && (double)mob.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, targetPos).m_123342_() > mob.m_20186_();
    }

    public static boolean isLookingAt(LivingEntity looker, LivingEntity target, double leniencyFactor, boolean requireLOS, boolean checkBody) {
        double leniency;
        Vec3 viewVector = looker.m_20252_(1.0f).m_82541_();
        Vec3 vectorToTarget = looker.m_146892_().m_82505_(target.m_146892_());
        double distanceToTarget = vectorToTarget.m_82553_();
        return !(!EntityHelper.sameDirection(viewVector, vectorToTarget = vectorToTarget.m_82541_(), leniency = leniencyFactor / distanceToTarget) || requireLOS && !looker.m_142582_((Entity)target) || checkBody && !EntityHelper.sameDirection(EntityHelper.getBodyViewVector(looker, 1.0f).m_82541_(), vectorToTarget, leniency));
    }

    private static boolean sameDirection(Vec3 a, Vec3 b, double leniency) {
        return a.m_82526_(b) >= 1.0 - leniency;
    }

    public static Vec3 getBodyViewVector(LivingEntity looker, float partialTicks) {
        return looker.m_20171_(looker.m_5686_(partialTicks), partialTicks == 1.0f ? looker.f_20883_ : Mth.m_14179_((float)partialTicks, (float)looker.f_20884_, (float)looker.f_20883_));
    }

    public static boolean isLookingAwayFrom(LivingEntity looker, Vec3 target, double leniencyFactor, boolean checkBody, boolean checkY) {
        double leniency;
        Vec3 viewVector = looker.m_20252_(1.0f).m_82542_(1.0, checkY ? 1.0 : 0.0, 1.0).m_82541_();
        Vec3 vectorAwayFromTarget = target.m_82505_(looker.m_146892_()).m_82542_(1.0, checkY ? 1.0 : 0.0, 1.0);
        double distanceAwayFromTarget = vectorAwayFromTarget.m_82553_();
        return EntityHelper.sameDirection(viewVector, vectorAwayFromTarget = vectorAwayFromTarget.m_82541_(), leniency = leniencyFactor / distanceAwayFromTarget) && (!checkBody || EntityHelper.sameDirection(EntityHelper.getBodyViewVector(looker, 1.0f).m_82542_(1.0, checkY ? 1.0 : 0.0, 1.0).m_82541_(), vectorAwayFromTarget, leniency));
    }

    public static boolean canWalkOnTarBlocks(LivingEntity entity) {
        ItemStack boots = entity.m_6844_(EquipmentSlot.FEET);
        return boots.m_204117_(ModTags.Items.ALLOWS_WALKING_ON_TAR) || boots.getEnchantmentLevel((Enchantment)ModEnchantments.TAR_MARCHER.get()) != 0;
    }

    public static boolean noBlockCollisions(LivingEntity entity) {
        return !entity.m_9236_().m_186434_((Entity)entity, entity.m_20191_()).iterator().hasNext();
    }

    @Nullable
    public static BlockPos findSafeSpot(LivingEntity entity) {
        BlockPos.MutableBlockPos newPos;
        int newY;
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        HollowEntity dummyHollow = (HollowEntity)((EntityType)ModEntities.HOLLOW.get()).m_20615_((Level)serverLevel);
        assert (dummyHollow != null);
        BlockPos validBlockPos = serverLevel.m_6857_().m_187569_(entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_);
        Vec3 validPos = new Vec3((double)validBlockPos.m_123341_(), Mth.m_14008_((double)entity.m_20186_(), (double)serverLevel.m_141937_(), (double)serverLevel.m_151558_()), (double)validBlockPos.m_123343_());
        dummyHollow.m_146884_(validPos);
        if (validPos.f_82480_ > (double)serverLevel.m_141937_()) {
            if (EntityHelper.noBlockCollisions(dummyHollow)) {
                return entity.m_20183_();
            }
            double originalY = entity.m_20186_();
            for (int offsetY = 0; offsetY < 12; offsetY += 2) {
                dummyHollow.m_6034_(entity.m_20185_(), originalY + (double)offsetY, entity.m_20189_());
                if (!EntityHelper.noBlockCollisions(dummyHollow)) continue;
                return entity.m_20183_().m_6630_(offsetY);
            }
        }
        BlockPos teleportPos = null;
        BlockPos potentialPos = null;
        Iterator iterator = BlockPos.m_121935_((BlockPos)BlockPos.m_274446_((Position)dummyHollow.m_20182_()), (int)32, (Direction)Direction.SOUTH, (Direction)Direction.WEST).iterator();
        while (iterator.hasNext() && (newY = serverLevel.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (newPos = (BlockPos.MutableBlockPos)iterator.next()).m_123341_(), newPos.m_123343_())) < serverLevel.m_143344_()) {
            dummyHollow.m_6034_(newPos.m_123341_(), (double)newY + 0.01, newPos.m_123343_());
            if (EntityHelper.noBlockCollisions(dummyHollow)) {
                if (newY == serverLevel.m_141937_()) {
                    if (potentialPos != null) continue;
                    potentialPos = BlockPos.m_274446_((Position)dummyHollow.m_20182_());
                    continue;
                }
                teleportPos = BlockPos.m_274446_((Position)dummyHollow.m_20182_());
                break;
            }
            if (potentialPos != null) continue;
            dummyHollow.m_6034_(newPos.m_123341_(), newY + 1, newPos.m_123343_());
            if (!EntityHelper.noBlockCollisions(dummyHollow)) continue;
            potentialPos = BlockPos.m_274446_((Position)dummyHollow.m_20182_());
        }
        if (teleportPos == null) {
            teleportPos = potentialPos;
        }
        return teleportPos;
    }

    public static boolean shouldCreateHollow(ServerPlayer player) {
        return !player.m_284548_().m_46469_().m_46207_(GameRules.f_46133_) && EntityHelper.getIdolOfRetrievalInHand(player) != null && !player.m_5833_();
    }

    @Nullable
    public static ItemStack getIdolOfRetrievalInHand(ServerPlayer player) {
        if (player.m_21205_().m_150930_((Item)ModItems.IDOL_OF_RETRIEVAL.get())) {
            return player.m_21205_();
        }
        if (player.m_21206_().m_150930_((Item)ModItems.IDOL_OF_RETRIEVAL.get())) {
            return player.m_21206_();
        }
        return null;
    }

    public static boolean isWearingFrostbiteSet(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ModItems.FROST_BITE_HELMET.get()) && entity.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ModItems.FROST_BITE_CHESTPLATE.get()) && entity.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ModItems.FROST_BITE_LEGGINGS.get()) && entity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ModItems.FROST_BITE_BOOTS.get());
    }

    public static boolean isWearingFrostbiteBoots(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ModItems.FROST_BITE_BOOTS.get());
    }

    public static boolean isPanicking(Animal mob) {
        if (mob.m_6274_().m_21874_(MemoryModuleType.f_217768_)) {
            return mob.m_6274_().m_21952_(MemoryModuleType.f_217768_).isPresent();
        }
        for (WrappedGoal wrappedgoal : mob.f_21345_.m_148105_()) {
            if (!wrappedgoal.m_7620_() || !(wrappedgoal.m_26015_() instanceof PanicGoal)) continue;
            return true;
        }
        return false;
    }

    public static EquipmentSlot getSlotForHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
    }

    public static void consumeStack(int i, @Nullable LivingEntity arg, ItemStack stack) {
        Player player;
        if (arg == null || !(arg instanceof Player) || !(player = (Player)arg).m_7500_()) {
            stack.m_41774_(i);
        }
    }
}

