/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.util;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HitboxHelper {
    public static double getDistSqrBetweenHitboxes(AABB first, AABB second) {
        double distSqr = 0.0;
        distSqr += Mth.m_144952_((double)HitboxHelper.getDistBetweenCorners(first.f_82288_, second.f_82288_, first.f_82291_, second.f_82291_));
        distSqr += Mth.m_144952_((double)HitboxHelper.getDistBetweenCorners(first.f_82289_, second.f_82289_, first.f_82292_, second.f_82292_));
        return distSqr += Mth.m_144952_((double)HitboxHelper.getDistBetweenCorners(first.f_82290_, second.f_82290_, first.f_82293_, second.f_82293_));
    }

    private static double getDistBetweenCorners(double min1, double min2, double max1, double max2) {
        if (max2 < min1) {
            return max2 - min1;
        }
        if (min2 > max1) {
            return min2 - max1;
        }
        return 0.0;
    }

    public static double getDistSqrBetweenHitboxes(Entity first, Entity second) {
        return HitboxHelper.getDistSqrBetweenHitboxes(first.m_20191_(), second.m_20191_());
    }

    public static double getDistSqrFromHitbox(Entity entity, Vec3 target) {
        return HitboxHelper.getDistSqrFromHitbox(entity.m_20191_(), target);
    }

    public static double getDistSqrFromHitbox(AABB box, Vec3 target) {
        return box.m_272282_(target);
    }

    public static boolean isCloseEnoughForTargeting(LivingEntity attacker, LivingEntity target, boolean testInvisible, double range) {
        double visibilityPercent = testInvisible ? target.m_20968_((Entity)attacker) : 1.0;
        double maxDistance = Math.max(range * visibilityPercent, 2.0);
        double distanceToSqr = HitboxHelper.getDistSqrBetweenHitboxes((Entity)attacker, (Entity)target);
        return !(distanceToSqr > Mth.m_144952_((double)maxDistance));
    }

    public static float pixelsToBlocks(float pixels) {
        return pixels / 16.0f;
    }

    public static AABB createHitboxRelativeToFront(LivingEntity mob, double xSize, double ySize, double zSize) {
        Vec3 baseOffset = Vec3.f_82478_.m_82520_(0.0, 0.0, (double)mob.m_20205_() * 0.5).m_82524_(-mob.m_6080_() * ((float)Math.PI / 180));
        Vec3 radiusOffset = Vec3.f_82478_.m_82520_(0.0, ySize * 0.5, zSize * 0.5).m_82524_(-mob.m_6080_() * ((float)Math.PI / 180));
        Vec3 centerPos = mob.m_20182_().m_82549_(baseOffset).m_82549_(radiusOffset);
        return AABB.m_165882_((Vec3)centerPos, (double)xSize, (double)ySize, (double)zSize);
    }

    public static double calculateMinimumAttackHitboxWidth(double hitboxWidth) {
        double halfWidth = hitboxWidth * 0.5;
        return 2.0 * (Math.hypot(halfWidth, halfWidth) - halfWidth);
    }

    public static double getHitboxAdjustedDistance(LivingEntity mob, double distance) {
        return HitboxHelper.getHitboxAdjustedDistance(mob.m_20205_(), distance);
    }

    public static double getHitboxAdjustedDistance(float width, double distance) {
        double halfWidth = (double)width * 0.5;
        return Math.hypot(halfWidth, halfWidth) + distance;
    }
}

