/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.util;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShapeUtils {
    public static VoxelShape orUnoptimized(VoxelShape first, VoxelShape second) {
        return Shapes.m_83148_((VoxelShape)first, (VoxelShape)second, (BooleanOp)BooleanOp.f_82695_);
    }

    public static VoxelShape orUnoptimized(VoxelShape first, VoxelShape ... others) {
        for (VoxelShape shape : others) {
            first = ShapeUtils.orUnoptimized(first, shape);
        }
        return first;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        return ShapeUtils.rotateShapeUnoptimized(from, to, shape).m_83296_();
    }

    public static boolean isY(Direction direction) {
        return direction.m_122434_() == Direction.Axis.Y;
    }

    public static VoxelShape rotateShapeUnoptimized(Direction from, Direction to, VoxelShape shape) {
        if (ShapeUtils.isY(from) || ShapeUtils.isY(to)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        List sourceBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (AABB box : sourceBoxes) {
            for (int i = 0; i < times; ++i) {
                box = new AABB(1.0 - box.f_82293_, box.f_82289_, box.f_82288_, 1.0 - box.f_82290_, box.f_82292_, box.f_82291_);
            }
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateShape(VoxelShape shape, Direction.Axis axis, Direction facing) {
        VoxelShape rotatedShape = shape;
        switch (axis) {
            case X: {
                rotatedShape = ShapeUtils.rotateYtoX(ShapeUtils.rotateXtoZ(shape));
                break;
            }
            case Z: {
                rotatedShape = ShapeUtils.rotateYtoX(ShapeUtils.rotateXtoZ(ShapeUtils.rotateXtoZ(ShapeUtils.rotateXtoZ(shape))));
                break;
            }
        }
        rotatedShape = ShapeUtils.rotateBasedOnFacing(rotatedShape, axis, facing);
        return rotatedShape;
    }

    public static VoxelShape rotateBasedOnFacing(VoxelShape shape, Direction.Axis axis, Direction facing) {
        if (axis == Direction.Axis.Y) {
            return shape;
        }
        switch (facing) {
            case NORTH: {
                return ShapeUtils.rotateXtoZ(ShapeUtils.rotateXtoZ(shape));
            }
            case EAST: {
                return ShapeUtils.rotateXtoZ(shape);
            }
            case WEST: {
                return ShapeUtils.rotateXtoZ(ShapeUtils.rotateXtoZ(ShapeUtils.rotateXtoZ(shape)));
            }
        }
        return shape;
    }

    public static VoxelShape rotateXtoZ(VoxelShape shape) {
        List soureBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        for (AABB box : soureBoxes) {
            box = new AABB(1.0 - box.f_82293_, box.f_82289_, box.f_82288_, 1.0 - box.f_82290_, box.f_82292_, box.f_82291_);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateYtoX(VoxelShape shape) {
        List sourceBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        for (AABB box : sourceBoxes) {
            AABB rotatedBox = new AABB(box.f_82288_, 1.0 - box.f_82293_, box.f_82289_, box.f_82291_, 1.0 - box.f_82290_, box.f_82292_);
            rotatedShape = Shapes.m_83110_((VoxelShape)rotatedShape, (VoxelShape)Shapes.m_83064_((AABB)rotatedBox));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateYtoZ(VoxelShape shape) {
        List sourceBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        for (AABB box : sourceBoxes) {
            AABB rotatedBox = new AABB(1.0 - box.f_82291_, box.f_82289_, box.f_82290_, 1.0 - box.f_82288_, box.f_82292_, box.f_82293_);
            rotatedShape = Shapes.m_83110_((VoxelShape)rotatedShape, (VoxelShape)Shapes.m_83064_((AABB)rotatedBox));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateXtoZ(VoxelShape shape, int times) {
        VoxelShape rotatedShape = shape;
        for (int i = 0; i < times; ++i) {
            rotatedShape = ShapeUtils.rotateXtoZ(rotatedShape);
        }
        return rotatedShape;
    }

    public static VoxelShape rotateXtoZFlippedY(VoxelShape shape) {
        List soureBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        for (AABB box : soureBoxes) {
            box = new AABB(1.0 - box.f_82293_, box.f_82292_, box.f_82288_, 1.0 - box.f_82290_, box.f_82289_, box.f_82291_);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape flipY(VoxelShape shape) {
        List soureBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        for (AABB box : soureBoxes) {
            box = new AABB(box.f_82288_, box.f_82292_, box.f_82290_, box.f_82291_, box.f_82289_, box.f_82293_);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape floorToCeiling(VoxelShape shape) {
        List soureBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        for (AABB box : soureBoxes) {
            box = new AABB(box.f_82293_, 1.0 - box.f_82292_, box.f_82288_, box.f_82290_, 1.0 - box.f_82289_, box.f_82291_);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateXtoEast(VoxelShape shape) {
        List soureBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        for (AABB box : soureBoxes) {
            box = new AABB(box.f_82292_, box.f_82291_, 1.0 - box.f_82293_, box.f_82289_, box.f_82288_, 1.0 - box.f_82290_);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateXtoWest(VoxelShape shape) {
        List soureBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        for (AABB box : soureBoxes) {
            box = new AABB(1.0 - box.f_82292_, box.f_82288_, box.f_82290_, 1.0 - box.f_82289_, box.f_82291_, box.f_82293_);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateXtoNorth(VoxelShape shape) {
        List soureBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        for (AABB box : soureBoxes) {
            box = new AABB(1.0 - box.f_82293_, box.f_82288_, 1.0 - box.f_82289_, 1.0 - box.f_82290_, box.f_82291_, 1.0 - box.f_82292_);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateXtoSouth(VoxelShape shape) {
        List soureBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        for (AABB box : soureBoxes) {
            box = new AABB(box.f_82293_, box.f_82291_, box.f_82292_, box.f_82290_, box.f_82288_, box.f_82289_);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }
}

