/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import org.jetbrains.annotations.Nullable;
import team.recrafted.blastfromthepast.block.BearTrapBlockEntity;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModDamageTypes;
import team.recrafted.blastfromthepast.init.ModSounds;

public class BearTrapBlock
extends BaseEntityBlock {
    public static final MapCodec<BearTrapBlock> CODEC = BearTrapBlock.simpleCodec(BearTrapBlock::new);

    public BearTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (level1, pos, state1, blockEntity) -> ((BearTrapBlockEntity)blockEntity).tick(level1, pos);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        BearTrapBlockEntity blockEntity = (BearTrapBlockEntity)level.getBlockEntity(pos);
        if (blockEntity.entity == null && entity instanceof LivingEntity) {
            LivingEntity livingEntity;
            blockEntity.entity = livingEntity = (LivingEntity)entity;
            blockEntity.timer = 0;
            livingEntity.hurt(level.damageSources().source(ModDamageTypes.BEAR_TRAP, (Entity)livingEntity), 6.0f);
            level.playSound(null, pos, (SoundEvent)ModSounds.BEAR_TRAP.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
            if (blockEntity.bait != null) {
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.addItem(blockEntity.bait.getItem());
                }
                blockEntity.bait.discard();
                blockEntity.bait = null;
            }
        }
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        return List.of(new ItemStack((ItemLike)ModBlocks.BEAR_TRAP.asItem(), 1));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BearTrapBlockEntity(blockPos, blockState);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        return BearTrapBlock.canSupportRigidBlock((BlockGetter)level, (BlockPos)blockpos) || BearTrapBlock.canSupportCenter((LevelReader)level, (BlockPos)blockpos, (Direction)Direction.UP);
    }

    protected int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return ((BearTrapBlockEntity)blockAccess.getBlockEntity(pos)).isTrapping() ? 15 : 0;
    }

    protected int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return side == Direction.UP ? this.getSignal(blockState, blockAccess, pos, side) : 0;
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }
}

