/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.IShearable;
import team.recrafted.blastfromthepast.init.ModBlocks;

public class PsychoBerrySprout
extends BushBlock
implements IShearable,
BonemealableBlock {
    public static final MapCodec<PsychoBerrySprout> CODEC = PsychoBerrySprout.simpleCodec(PsychoBerrySprout::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_1;

    public PsychoBerrySprout(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.empty();
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean canGrow;
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl = level.getRawBrightness(pos.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(10) == 0 ? 1 : 0) != 0) ? true : (canGrow = false);
        if (canGrow) {
            if (i < 1) {
                BlockState blockstate = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
                level.setBlock(pos, blockstate, 2);
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockstate));
            } else if (i == 1) {
                BlockState state1 = ((Block)ModBlocks.PSYCHO_BERRY_BUSH.get()).defaultBlockState();
                this.generateRandomBlocksAround((Level)level, pos, state1);
                level.setBlock(pos, state1, 2);
            }
        }
    }

    public void generateRandomBlocksAround(Level level, BlockPos pos, BlockState state) {
        RandomSource random = level.getRandom();
        for (int j = 0; j < 20; ++j) {
            BlockPos newPos;
            if (!random.nextBoolean()) continue;
            int xOffset = random.nextInt(3) - 1;
            int yOffset = random.nextInt(1);
            int zOffset = random.nextInt(3) - 1;
            if (xOffset == 0 && yOffset == 0 && zOffset == 0 || !level.getBlockState(newPos = pos.offset(xOffset, yOffset, zOffset)).canBeReplaced() || !this.canSurvive(null, (LevelReader)level, newPos)) continue;
            level.setBlock(newPos, state, 2);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int i = (Integer)state.getValue((Property)AGE);
        boolean flag = i == 1;
        return !flag && stack.is(Items.BONE_MEAL) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i == 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
        } else if (i == 1) {
            BlockState state1 = ((Block)ModBlocks.PSYCHO_BERRY_BUSH.get()).defaultBlockState();
            this.generateRandomBlocksAround((Level)level, pos, state1);
            level.setBlock(pos, state1, 2);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos.below());
        return blockState.isSolidRender((BlockGetter)level, pos) || blockState.is(ModBlocks.PSYCHO_BERRY_BUSH);
    }
}

