/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.Roaring;
import team.recrafted.blastfromthepast.entity.ai.controller.OverridableBodyRotationControl;
import team.recrafted.blastfromthepast.entity.ai.controller.OverridableMoveControl;
import team.recrafted.blastfromthepast.entity.ai.goal.CustomPanicGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.HitboxAdjustedBreedGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.HitboxAdjustedFollowParentGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.attacker.AnimatedMeleeAttackGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.charge.ChargeForwardAttackGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.pack.PackHurtByTargetGoal;
import team.recrafted.blastfromthepast.entity.ai.navigation.AzureNavigation;
import team.recrafted.blastfromthepast.entity.misc.AnimatedAttacker;
import team.recrafted.blastfromthepast.entity.misc.ChargeForward;
import team.recrafted.blastfromthepast.entity.misc.OverrideAnimatedAttacker;
import team.recrafted.blastfromthepast.entity.misc.StateValue;
import team.recrafted.blastfromthepast.entity.pack.EntityPack;
import team.recrafted.blastfromthepast.entity.pack.EntityPackAgeableMobData;
import team.recrafted.blastfromthepast.entity.pack.EntityPackHolder;
import team.recrafted.blastfromthepast.init.ModDataSerializers;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.init.ModTags;
import team.recrafted.blastfromthepast.mixin.AbstractChestedHorseAccessor;
import team.recrafted.blastfromthepast.network.FrostomperCollidePayload;
import team.recrafted.blastfromthepast.network.ScreenShakePayload;
import team.recrafted.blastfromthepast.util.EntityHelper;
import team.recrafted.blastfromthepast.util.HitboxHelper;

@ParametersAreNonnullByDefault
public class FrostomperEntity
extends AbstractChestedHorse
implements GeoEntity,
EntityPackHolder<FrostomperEntity>,
OverrideAnimatedAttacker<FrostomperEntity, FrostomperAttackType>,
ChargeForward,
Roaring {
    public static final EntityDimensions BABY_FROSTOMPER_DIMENSIONS = EntityDimensions.scalable((float)HitboxHelper.pixelsToBlocks(28.0f), (float)HitboxHelper.pixelsToBlocks(22.0f));
    private static final EntityDataAccessor<OptionalInt> DATA_ACTIVE_ATTACK_TYPE = SynchedEntityData.defineId(FrostomperEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    private static final EntityDataAccessor<IdleState> DATA_IDLE_STATE = SynchedEntityData.defineId(FrostomperEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModDataSerializers.FROSTOMPER_IDLE_STATE.get()));
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_FORWARD = SynchedEntityData.defineId(FrostomperEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final double PARENT_TARGETING_DISTANCE = 16.0;
    private static final int CHARGE_ATTACK_COOLDOWN = 900;
    private static final int FLAG_ROARING = 128;
    private static final UniformInt CHARGE_ATTACK_DURATION = UniformInt.of((int)Mth.floor((float)66.666664f), (int)Mth.floor((float)83.33333f));
    public static final int MAX_TRUMPET_TICKS_ADULT = Mth.floor((float)30.0f);
    public static final int MAX_TRUMPET_TICKS_BABY = Mth.floor((float)8.334f);
    protected static final TargetingConditions PARENT_TARGETING = TargetingConditions.forNonCombat().ignoreLineOfSight().selector(entity -> entity instanceof FrostomperEntity && ((FrostomperEntity)entity).isBred());
    protected final TargetingConditions parentTargeting;
    @org.jetbrains.annotations.Nullable
    private EntityPack<FrostomperEntity> pack;
    private final AnimatedAttacker.AttackTicker<FrostomperEntity, FrostomperAttackType> attackTicker = new AnimatedAttacker.AttackTicker(this);
    private int ticksUntilNextCharge;
    private int roarCounter;
    private int trumpetCounter;
    private int idleAnimationTimer = -1;
    private boolean lastCollide = false;
    public boolean serverHorizontalCollide = false;
    public boolean canAnimateLook = true;
    private boolean party;
    @Nullable
    private BlockPos jukebox;
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.frostomper.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation CRUSH = RawAnimation.begin().then("animation.frostomper.crush", Animation.LoopType.DEFAULT);
    public static final RawAnimation STOMP = RawAnimation.begin().then("animation.frostomper.stomp", Animation.LoopType.DEFAULT);
    public static final RawAnimation STOMP_FLIPPED = RawAnimation.begin().then("animation.frostomper.stomp_flipped", Animation.LoopType.DEFAULT);
    public static final RawAnimation FLING = RawAnimation.begin().then("animation.frostomper.fling", Animation.LoopType.DEFAULT);
    public static final RawAnimation CHARGE = RawAnimation.begin().then("animation.frostomper.charge", Animation.LoopType.DEFAULT);
    public static final RawAnimation TAILS = RawAnimation.begin().then("animation.frostomper.tails", Animation.LoopType.DEFAULT);
    public static final RawAnimation EARS = RawAnimation.begin().then("animation.frostomper.ears", Animation.LoopType.DEFAULT);
    public static final RawAnimation WALK = RawAnimation.begin().then("animation.frostomper.walk", Animation.LoopType.DEFAULT);
    public static final RawAnimation TRUMPET = RawAnimation.begin().then("animation.frostomper.trumpet", Animation.LoopType.DEFAULT);
    public static final RawAnimation DANCE = RawAnimation.begin().then("animation.frostomper.dance", Animation.LoopType.DEFAULT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final double MINIMUM_ATTACK_SIZE = HitboxHelper.calculateMinimumAttackHitboxWidth(((EntityType)ModEntities.FROSTOMPER.get()).getWidth());
    private static final Vec3 DEFAULT_ATTACK_SIZE = new Vec3(MINIMUM_ATTACK_SIZE + 1.0, MINIMUM_ATTACK_SIZE + 1.0, MINIMUM_ATTACK_SIZE + 1.0);

    public FrostomperEntity(EntityType<? extends FrostomperEntity> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new OverridableMoveControl<FrostomperEntity>(this);
        this.setPathfindingMalus(PathType.LEAVES, 0.0f);
        this.parentTargeting = PARENT_TARGETING.copy().selector(entity -> HitboxHelper.isCloseEnoughForTargeting((LivingEntity)this, entity, true, 16.0));
        ((AbstractChestedHorseAccessor)((Object)this)).setBabyDimensions(BABY_FROSTOMPER_DIMENSIONS);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AgeableMob.createMobAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.KNOCKBACK_RESISTANCE, 0.75).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.ATTACK_KNOCKBACK, 1.5).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, new CustomPanicGoal<FrostomperEntity>(this, FrostomperEntity::shouldPanic, 1.2, EntityHelper::getPanicInducingDamageTypes));
        this.goalSelector.addGoal(2, (Goal)new HitboxAdjustedBreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new HitboxAdjustedFollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, new ChargeForwardAttackGoal<FrostomperEntity>(this, CHARGE_ATTACK_DURATION, 1.2));
        this.goalSelector.addGoal(5, new AnimatedMeleeAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        if (this.canPerformRearing()) {
            this.goalSelector.addGoal(9, (Goal)new RandomStandGoal((AbstractHorse)this));
        }
        this.addBehaviourGoals();
        this.targetSelector.addGoal(0, new PackHurtByTargetGoal<FrostomperEntity>(this, Predicate.not(AgeableMob::isBaby), AgeableMob::isBaby, new Class[0]));
    }

    protected boolean shouldPanic() {
        return this.isBaby() || this.getTarget() == null;
    }

    protected void updateControlFlags() {
        boolean canControlMove = this.getControllingPassenger() == null;
        boolean canControlJump = !(this.getVehicle() instanceof Boat);
        this.goalSelector.setControlFlag(Goal.Flag.MOVE, canControlMove);
        this.goalSelector.setControlFlag(Goal.Flag.JUMP, canControlMove && canControlJump);
        this.goalSelector.setControlFlag(Goal.Flag.LOOK, canControlMove);
        this.goalSelector.setControlFlag(Goal.Flag.TARGET, canControlMove);
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, this::isTemptItem, false));
    }

    protected boolean isTemptItem(ItemStack stack) {
        return stack.is(this.isBaby() ? ModTags.Items.BABY_FROSTOMPER_TEMPT_ITEMS : ModTags.Items.FROSTOMPER_TEMPT_ITEMS);
    }

    protected void randomizeAttributes(RandomSource random) {
    }

    protected void followMommy() {
        FrostomperEntity mommy;
        if (this.isBred() && this.isBaby() && !this.isEating() && (mommy = (FrostomperEntity)this.level().getNearestEntity(FrostomperEntity.class, this.parentTargeting, (LivingEntity)this, this.getX(), this.getY(), this.getZ(), this.getBoundingBox().inflate(16.0))) != null && HitboxHelper.getDistSqrBetweenHitboxes((Entity)this, (Entity)mommy) > 4.0) {
            this.navigation.createPath((Entity)mommy, 0);
        }
    }

    protected void doPlayerRide(Player player) {
        if (this.isTamed()) {
            super.doPlayerRide(player);
            if (!this.level().isClientSide) {
                this.setRoaring(false);
                this.serverHorizontalCollide = false;
            }
        }
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        int i = this.calculateFallDamage(fallDistance, multiplier);
        if (i <= 0) {
            return false;
        }
        this.hurt(source, i);
        if (this.isVehicle()) {
            for (Entity entity : this.getIndirectPassengers()) {
                entity.hurt(source, (float)i);
            }
        }
        this.playBlockFallSound();
        return true;
    }

    protected PathNavigation createNavigation(Level level) {
        return new AzureNavigation((Mob)this, level);
    }

    public int getMaxHeadYRot() {
        return 45;
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(this.isBaby() ? ModTags.Items.BABY_FROSTOMPER_FOOD : ModTags.Items.FROSTOMPER_FOOD);
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob otherParent) {
        FrostomperEntity offspring = (FrostomperEntity)((EntityType)ModEntities.FROSTOMPER.get()).create((Level)serverLevel);
        if (offspring != null) {
            this.setOffspringAttributes(otherParent, (AbstractHorse)offspring);
        }
        return offspring;
    }

    protected void setOffspringAttributes(AgeableMob parent, AbstractHorse child) {
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @org.jetbrains.annotations.Nullable SpawnGroupData spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new FrostomperGroupData(BlastFromThePast.getUniversalEntityPacks(level.getLevel().getServer()).createFreshPack(), true);
        }
        if (spawnGroupData instanceof FrostomperGroupData) {
            FrostomperGroupData frostomperGroupData = (FrostomperGroupData)spawnGroupData;
            frostomperGroupData.addPackMember((Mob)this);
        }
        SpawnGroupData spawnData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        if (this.isBaby()) {
            this.setAge(-24000);
        }
        this.idleAnimationTimer = IdleState.NONE.animationTime();
        return spawnData;
    }

    public void setBaby(boolean baby) {
        this.setAge(baby ? -24000 : 0);
    }

    public int getMaxSpawnClusterSize() {
        return 6;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.FROSTOMPER_IDLE.get();
    }

    protected SoundEvent getAngrySound() {
        return (SoundEvent)ModSounds.FROSTOMPER_TRUMPET.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.FROSTOMPER_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getEatingSound() {
        return SoundEvents.GENERIC_EAT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSounds.FROSTOMPER_HURT.get();
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    protected void playJumpSound() {
    }

    protected void playGallopSound(SoundType soundType) {
    }

    protected void playStepSound(BlockPos pos, BlockState block) {
    }

    protected void playChestEquipsSound() {
        this.playSound(SoundEvents.DONKEY_CHEST, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    public SoundEvent getSaddleSoundEvent() {
        return SoundEvents.HORSE_SADDLE;
    }

    public void move(MoverType type, Vec3 pos) {
        super.move(type, pos);
        if (this.hasPassenger((Predicate)Predicates.alwaysTrue()) && this.lastCollide != this.horizontalCollision) {
            PacketDistributor.sendToServer((CustomPacketPayload)new FrostomperCollidePayload(this.getId(), this.horizontalCollision), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.lastCollide = this.horizontalCollision;
        }
    }

    protected boolean handleEating(Player player, ItemStack stack) {
        if (!this.isFood(stack)) {
            return false;
        }
        boolean fed = false;
        if (this.getHealth() < this.getMaxHealth()) {
            this.heal(2.0f);
            fed = true;
        }
        if (this.getAge() == 0 && this.canFallInLove()) {
            this.setInLove(player);
            fed = true;
        }
        if (this.isBaby()) {
            this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            if (!this.level().isClientSide) {
                this.ageUp(FrostomperEntity.getSpeedUpSecondsWhenFeeding((int)(-this.getAge())), true);
                fed = true;
            }
        }
        if (!(this.isTamed() || this.getTemper() >= this.getMaxTemper() || this.level().isClientSide || EventHooks.onAnimalTame((Animal)this, (Player)player))) {
            this.modifyTemper(10);
            if (this.getTemper() >= this.getMaxTemper() && this.canBeTamedBy(player) && !EventHooks.onAnimalTame((Animal)this, (Player)player)) {
                this.tameWithName(player);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            fed = true;
        }
        if (!fed) {
            return false;
        }
        if (!this.isSilent()) {
            SoundEvent eatingSound = this.getEatingSound();
            this.makeSound(eatingSound);
        }
        this.heal(4.0f);
        this.gameEvent((Holder)GameEvent.EAT);
        return true;
    }

    public void finalizeSpawnChildFromBreeding(ServerLevel level, Animal animal, @org.jetbrains.annotations.Nullable AgeableMob baby) {
        super.finalizeSpawnChildFromBreeding(level, animal, baby);
        if (baby instanceof FrostomperEntity) {
            FrostomperEntity babyFrostomper = (FrostomperEntity)baby;
            Optional.ofNullable(this.getLoveCause()).or(() -> Optional.ofNullable(animal.getLoveCause())).ifPresent(loveCause -> babyFrostomper.setBred(true));
        }
    }

    protected boolean canBeTamedBy(Player player) {
        return this.isBaby() || this.isBred() || player.isCreative();
    }

    protected boolean canPerformRearing() {
        return false;
    }

    public boolean canMate(Animal otherAnimal) {
        if (otherAnimal != this && otherAnimal instanceof FrostomperEntity) {
            FrostomperEntity frostomper = (FrostomperEntity)otherAnimal;
            return this.canParent() && frostomper.canParent();
        }
        return false;
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public EntityPack<FrostomperEntity> getPack() {
        return this.pack;
    }

    @Override
    public void setPack(@org.jetbrains.annotations.Nullable EntityPack<FrostomperEntity> pack) {
        this.pack = pack;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.readPackData(compound, (Mob)this, serverLevel);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.savePackData(compound);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ACTIVE_ATTACK_TYPE, (Object)OptionalInt.empty());
        builder.define(DATA_CHARGING_FORWARD, (Object)false);
        builder.define(DATA_IDLE_STATE, (Object)IdleState.NONE);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (DATA_ACTIVE_ATTACK_TYPE.equals(pKey)) {
            this.attackTicker.reset();
        }
        if (!this.firstTick && DATA_CHARGING_FORWARD.equals(pKey)) {
            this.ticksUntilNextCharge = this.ticksUntilNextCharge == 0 ? 900 : this.ticksUntilNextCharge;
        }
    }

    protected BodyRotationControl createBodyControl() {
        return new OverridableBodyRotationControl<FrostomperEntity>(this);
    }

    @Override
    public void setActiveAttackType(@org.jetbrains.annotations.Nullable FrostomperAttackType attackType) {
        this.entityData.set(DATA_ACTIVE_ATTACK_TYPE, (Object)(attackType == null ? OptionalInt.empty() : OptionalInt.of(attackType.ordinal())));
        if (attackType != null && !this.level().isClientSide) {
            if (this.isRoaring()) {
                this.setRoaring(false);
            }
            if (this.isStanding()) {
                this.setStanding(false);
            }
            if (this.isEating()) {
                this.setEating(false);
            }
        }
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public FrostomperAttackType getActiveAttackType() {
        OptionalInt ordinal = (OptionalInt)this.entityData.get(DATA_ACTIVE_ATTACK_TYPE);
        return ordinal.isEmpty() ? null : FrostomperAttackType.byOrdinal(ordinal.getAsInt());
    }

    public void tick() {
        super.tick();
        if (this.isAlive() && !this.isBaby()) {
            if (this.idleAnimationTimer <= -1) {
                IdleState newState = this.getEntityData().get(DATA_IDLE_STATE) == IdleState.NONE ? (this.random.nextBoolean() ? IdleState.EARS : IdleState.TAIL) : IdleState.NONE;
                this.getEntityData().set(DATA_IDLE_STATE, (Object)newState);
                this.idleAnimationTimer = newState.animationTime();
            } else {
                --this.idleAnimationTimer;
            }
        }
        this.attackTicker.tick();
        if (this.ticksUntilNextCharge > 0) {
            --this.ticksUntilNextCharge;
            if (this.ticksUntilNextCharge == 0) {
                this.level().playSound(null, this.blockPosition(), SoundEvents.CAMEL_DASH_READY, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
        if (!this.level().isClientSide && this.roarCounter > 0 && ++this.roarCounter > (this.isBaby() ? MAX_TRUMPET_TICKS_BABY : MAX_TRUMPET_TICKS_ADULT)) {
            this.roarCounter = 0;
            this.setRoaring(false);
        }
        if (!this.level().isClientSide) {
            if (this.random.nextInt(500) == 0 && this.canRoar() && this.trumpetCounter == 0) {
                this.roarIfPossible();
                this.trumpetCounter = 200 + this.level().random.nextInt(200);
            }
            if (this.trumpetCounter > 0) {
                --this.trumpetCounter;
            }
        }
    }

    public void setAggressive(boolean aggressive) {
        boolean wasAggressive = this.isAggressive();
        super.setAggressive(aggressive);
        if (!wasAggressive && aggressive && !this.level().isClientSide) {
            this.makeMad();
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        this.jukebox = null;
        this.party = false;
        return super.hurt(source, amount);
    }

    public void aiStep() {
        if (this.jukebox == null || !this.jukebox.closerToCenterThan((Position)this.position(), 15.0) || !this.level().getBlockState(this.jukebox).is(Blocks.JUKEBOX)) {
            this.party = false;
            this.jukebox = null;
        }
        super.aiStep();
        if (this.isAlive() && !this.level().isClientSide && (this.horizontalCollision || this.serverHorizontalCollide) && EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
            boolean destroyedBlock = false;
            AABB breakBox = this.getBoundingBox().inflate(0.2);
            for (BlockPos nearbyBlockPos : BlockPos.betweenClosed((int)Mth.floor((double)breakBox.minX), (int)Mth.floor((double)breakBox.minY), (int)Mth.floor((double)breakBox.minZ), (int)Mth.floor((double)breakBox.maxX), (int)Mth.floor((double)breakBox.maxY), (int)Mth.floor((double)breakBox.maxZ))) {
                BlockState nearbyBlockState = this.level().getBlockState(nearbyBlockPos);
                if (!nearbyBlockState.is(ModTags.Blocks.FROSTOMPER_CAN_BREAK)) continue;
                destroyedBlock = this.level().destroyBlock(nearbyBlockPos, true, (Entity)this) || destroyedBlock;
            }
        }
    }

    public void setRecordPlayingNearby(BlockPos pos, boolean isPartying) {
        this.jukebox = pos;
        this.party = isPartying;
    }

    public void makeMad() {
        if (!this.isRoaring()) {
            this.roarIfPossible();
        }
    }

    @Override
    public void roarIfPossible() {
        if (this.canRoar() && !this.level().isClientSide) {
            this.roarCounter = 1;
            this.setRoaring(true);
            this.makeSound(this.getAngrySound());
            for (Player player : this.level().getEntitiesOfClass(Player.class, new AABB(this.blockPosition()).inflate((double)(this.getAngrySound().getRange(this.getSoundVolume()) - 1.0f)))) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ScreenShakePayload(20.0f, 60), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    public boolean canRoar() {
        return this.getActiveAttackType() == null;
    }

    @Override
    public boolean isRoaring() {
        return this.getFlag(128);
    }

    @Override
    public void setRoaring(boolean roaring) {
        this.setFlag(128, roaring);
    }

    public void travel(Vec3 travelVector) {
        if (!this.canMove() && this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            travelVector = travelVector.multiply(0.0, 1.0, 0.0);
        }
        super.travel(travelVector);
    }

    public boolean canAttack(LivingEntity target) {
        return this.getOwner() != target && super.canAttack(target);
    }

    public PlayerTeam getTeam() {
        LivingEntity owner;
        if (this.isTamed() && (owner = this.getOwner()) != null) {
            return owner.getTeam();
        }
        return super.getTeam();
    }

    public boolean isAlliedTo(Entity other) {
        if (other == null) {
            return false;
        }
        if (this.isTamed()) {
            LivingEntity owner = this.getOwner();
            if (other == owner) {
                return true;
            }
            if (owner != null) {
                if (other instanceof OwnableEntity) {
                    OwnableEntity otherOwnable = (OwnableEntity)other;
                    return otherOwnable.getOwner() == owner;
                }
                return owner.isAlliedTo(other);
            }
        }
        if (super.isAlliedTo(other)) {
            return true;
        }
        if (this.isAlliedToDefault(other)) {
            OwnableEntity otherOwnable;
            if (other instanceof OwnableEntity && (otherOwnable = (OwnableEntity)other).getOwner() != null) {
                return false;
            }
            return this.getTeam() == null && other.getTeam() == null;
        }
        return false;
    }

    protected boolean isAlliedToDefault(Entity other) {
        return other.getType().equals(this.getType());
    }

    @Override
    public FrostomperAttackType selectAttackTypeForTarget(@org.jetbrains.annotations.Nullable LivingEntity target) {
        if (target != null) {
            boolean canCharge;
            boolean bl = canCharge = this.ticksUntilNextCharge <= 0;
            if (canCharge) {
                int randomInt = this.random.nextInt(10);
                if (randomInt < 7) {
                    return FrostomperAttackType.CHARGE;
                }
                if (randomInt < 9) {
                    return FrostomperAttackType.FLING;
                }
                return FrostomperAttackType.DOUBLE_STOMP;
            }
            int randomInt = this.random.nextInt(3);
            if (randomInt < 2) {
                return FrostomperAttackType.FLING;
            }
            return FrostomperAttackType.DOUBLE_STOMP;
        }
        return null;
    }

    protected Vec2 getRiddenRotation(LivingEntity entity) {
        boolean rotationBlocked = !this.canRotate();
        return rotationBlocked ? new Vec2(this.getXRot(), this.getYRot()) : super.getRiddenRotation(entity);
    }

    protected Vec3 getRiddenInput(Player player, Vec3 travelVector) {
        boolean movementBlocked = !this.canMove();
        return movementBlocked ? Vec3.ZERO : super.getRiddenInput(player, travelVector);
    }

    @Override
    public boolean isChargingForward() {
        return (Boolean)this.entityData.get(DATA_CHARGING_FORWARD);
    }

    @Override
    public void setIsChargingForward(boolean charging) {
        this.entityData.set(DATA_CHARGING_FORWARD, (Object)charging);
    }

    public boolean canSpawnSprintParticle() {
        if (this.isChargingForward()) {
            return true;
        }
        return super.canSpawnSprintParticle();
    }

    public boolean canJump() {
        return this.getActiveAttackType() == null && super.canJump();
    }

    public void handleStartJump(int jumpPower) {
        if (jumpPower >= 90) {
            this.setActiveAttackType(FrostomperAttackType.DOUBLE_STOMP);
        } else {
            this.setActiveAttackType(FrostomperAttackType.SINGLE_STOMP);
        }
    }

    public int getJumpCooldown() {
        return this.attackTicker.get();
    }

    protected boolean canParent() {
        return !this.isVehicle() && !this.isPassenger() && !this.isBaby() && this.getHealth() >= this.getMaxHealth() && this.isInLove();
    }

    @Override
    public boolean canAnimateLook() {
        if (this.isRoaring()) {
            return false;
        }
        return OverrideAnimatedAttacker.super.canAnimateLook() && this.canAnimateLook;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, state -> {
            FrostomperAttackType activeAttackType = this.getActiveAttackType();
            if (!this.isBaby()) {
                if (!this.canRotateHead()) {
                    this.setYBodyRot(this.getYRot());
                    this.yBodyRotO = this.getYRot();
                }
                if (activeAttackType == FrostomperAttackType.DOUBLE_STOMP) {
                    return state.setAndContinue(CRUSH);
                }
                if (activeAttackType == FrostomperAttackType.SINGLE_STOMP && !this.isLeftHanded()) {
                    return state.setAndContinue(STOMP);
                }
                if (activeAttackType == FrostomperAttackType.SINGLE_STOMP && this.isLeftHanded()) {
                    return state.setAndContinue(STOMP_FLIPPED);
                }
                if (activeAttackType == FrostomperAttackType.FLING) {
                    return state.setAndContinue(FLING);
                }
                if (activeAttackType == FrostomperAttackType.CHARGE) {
                    return state.setAndContinue(CHARGE);
                }
            }
            if (this.isRoaring()) {
                return state.setAndContinue(TRUMPET);
            }
            if (state.isMoving() && this.canAnimateWalk()) {
                return state.setAndContinue(WALK);
            }
            if (this.party && !this.isBaby()) {
                return state.setAndContinue(DANCE);
            }
            return state.setAndContinue(IDLE);
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "idle", 5, state -> {
            IdleState idleState = (IdleState)this.getEntityData().get(DATA_IDLE_STATE);
            if (idleState == IdleState.TAIL) {
                return state.setAndContinue(TAILS);
            }
            if (idleState == IdleState.EARS) {
                return state.setAndContinue(EARS);
            }
            return PlayState.STOP;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected static class FrostomperGroupData
    extends EntityPackAgeableMobData<FrostomperEntity> {
        public FrostomperGroupData(EntityPack<FrostomperEntity> entityPack, boolean shouldSpawnBaby) {
            super(entityPack, shouldSpawnBaby);
        }
    }

    public static enum IdleState implements StateValue
    {
        NONE(0, -1),
        EARS(1, 22),
        TAIL(2, 25);

        private final int id;
        private final int animationTime;

        private IdleState(int id, int animationTime) {
            this.id = id;
            this.animationTime = animationTime;
        }

        @Override
        public int id() {
            return this.id;
        }

        public int animationTime() {
            return this.animationTime != -1 ? this.animationTime : 300 + (int)(Math.random() * 300.0);
        }
    }

    public static enum FrostomperAttackType implements AnimatedAttacker.AttackType<FrostomperEntity, FrostomperAttackType>
    {
        FLING(Mth.floor((float)7.6f), Mth.floor((float)15.0f), DEFAULT_ATTACK_SIZE, 8.0f, 1.5f),
        SINGLE_STOMP(Mth.floor((float)12.6f), 20, DEFAULT_ATTACK_SIZE.scale(0.5), 5.0f, 0.75f),
        DOUBLE_STOMP(Mth.floor((float)12.6f), 20, DEFAULT_ATTACK_SIZE, 10.0f, 1.5f),
        CHARGE(0, 10, DEFAULT_ATTACK_SIZE, 12.0f, 1.5f);

        private final int attackPoint;
        private final int attackDuration;
        private final Vec3 attackSize;
        private final float attackDamage;
        private final float attackKnockback;

        private FrostomperAttackType(int attackPoint, int attackDuration, Vec3 attackSize, float attackDamage, float attackKnockback) {
            this.attackPoint = attackPoint;
            this.attackDuration = attackDuration;
            this.attackSize = attackSize;
            this.attackDamage = attackDamage;
            this.attackKnockback = attackKnockback;
        }

        @Override
        public int getAttackPoint() {
            return this.attackPoint;
        }

        @Override
        public int getAttackDuration() {
            return this.attackDuration;
        }

        @Override
        public Vec3 getAttackSize() {
            return this.attackSize;
        }

        @Override
        public float getAttackDamage() {
            return this.attackDamage;
        }

        @Override
        public float getAttackKnockback() {
            return this.attackKnockback;
        }

        @Override
        public boolean blocksMovementInput() {
            return this == DOUBLE_STOMP || this == SINGLE_STOMP;
        }

        @Override
        public boolean blocksWalkAnimation() {
            return this == DOUBLE_STOMP || this == SINGLE_STOMP || this == CHARGE;
        }

        @Override
        public boolean blocksRotationInput() {
            return this == DOUBLE_STOMP || this == SINGLE_STOMP;
        }

        @Override
        public boolean blocksBodyRotation() {
            return this == DOUBLE_STOMP || this == SINGLE_STOMP;
        }

        @Override
        public boolean blocksHeadRotation() {
            return this == DOUBLE_STOMP || this == FLING || this == CHARGE;
        }

        @Override
        public boolean hasAttackPointAt(int attackTicker) {
            if (this == CHARGE) {
                return true;
            }
            return this.getAttackPoint() == attackTicker;
        }

        @Override
        public void executeAttackPoint(FrostomperEntity attacker, int attackTicker) {
            Vec3 attackSize = this.getAttackSize().scale((double)attacker.getScale());
            AABB attackBounds = HitboxHelper.createHitboxRelativeToFront((LivingEntity)attacker, attackSize.x(), attackSize.y(), attackSize.z());
            if (this == CHARGE) {
                if (attackTicker == 0) {
                    if (!attacker.level().isClientSide) {
                        attacker.setIsChargingForward(true);
                    }
                    attacker.makeSound((SoundEvent)ModSounds.FROSTOMPER_CHARGE.get());
                }
                if (attacker.isChargingForward()) {
                    List<LivingEntity> hitTargets = EntityHelper.hitTargetsWithAOEAttack(attacker, attackBounds, this.getAttackDamage(), 0.0f, false);
                    for (LivingEntity hitTarget : hitTargets) {
                        EntityHelper.strongKnockback((LivingEntity)attacker, hitTarget, this.getAttackKnockback());
                    }
                }
            } else if (this == FLING) {
                List<LivingEntity> hitTargets = EntityHelper.hitTargetsWithAOEAttack(attacker, attackBounds, this.getAttackDamage(), 0.0f, false);
                for (LivingEntity hitTarget : hitTargets) {
                    EntityHelper.throwTarget((LivingEntity)attacker, hitTarget, this.getAttackKnockback());
                }
            } else if (this == SINGLE_STOMP) {
                attacker.makeSound((SoundEvent)ModSounds.FROSTOMPER_STOMP.get());
                Vec3 lateralOffset = Vec3.ZERO.add(attacker.isLeftHanded() ? 1.0 : -1.0, 0.0, 0.0).scale((double)attacker.getScale()).yRot(-attacker.getYHeadRot() * ((float)Math.PI / 180));
                attackBounds = attackBounds.move(lateralOffset);
                EntityHelper.hitTargetsWithAOEAttack(attacker, attackBounds, this.getAttackDamage(), this.getAttackKnockback(), true);
            } else if (this == DOUBLE_STOMP) {
                attacker.playSound((SoundEvent)ModSounds.FROSTOMPER_STOMP.get(), attacker.getSoundVolume() * 2.0f, attacker.getVoicePitch());
                List<LivingEntity> hitTargets = EntityHelper.hitTargetsWithAOEAttack(attacker, attackBounds, this.getAttackDamage(), this.getAttackKnockback(), true);
                for (LivingEntity hitTarget : hitTargets) {
                    if (!hitTarget.canFreeze()) continue;
                    hitTarget.setTicksFrozen(hitTarget.getTicksFrozen() + 600);
                }
            } else {
                EntityHelper.hitTargetsWithAOEAttack(attacker, attackBounds, this.getAttackDamage(), this.getAttackKnockback(), true);
            }
        }

        @Override
        public boolean isFinished(FrostomperEntity attacker, int attackTicker) {
            if (this == CHARGE) {
                return !attacker.isChargingForward();
            }
            return attackTicker >= this.getAttackDuration();
        }

        public static FrostomperAttackType byOrdinal(int pOrdinal) {
            if (pOrdinal < 0 || pOrdinal > FrostomperAttackType.values().length) {
                pOrdinal = 0;
            }
            return FrostomperAttackType.values()[pOrdinal];
        }
    }
}

