/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.misc.Constants;

public class SapEntity
extends HangingEntity
implements GeoEntity {
    public float rotationZ;
    public float rotationX;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SapEntity(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SapEntity(Level level, BlockPos pos, Direction facingDirection) {
        this((EntityType<? extends SapEntity>)((EntityType)ModEntities.SAP.get()), level, pos, facingDirection);
    }

    public SapEntity(EntityType<? extends SapEntity> entityType, Level level, BlockPos pos, Direction direction) {
        super(entityType, level, pos);
        this.setDirection(direction);
    }

    public boolean isPickable() {
        return false;
    }

    @NotNull
    protected AABB calculateBoundingBox(BlockPos pos, Direction direction) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos).relative(direction, -0.46875);
        Direction.Axis direction$axis = direction.getAxis();
        double d0 = direction$axis == Direction.Axis.X ? 0.0625 : 0.75;
        double d1 = direction$axis == Direction.Axis.Y ? 0.0625 : 0.75;
        double d2 = direction$axis == Direction.Axis.Z ? 0.0625 : 0.75;
        return AABB.ofSize((Vec3)vec3, (double)d0, (double)d1, (double)d2);
    }

    protected void setDirection(Direction facingDirection) {
        Validate.notNull((Object)facingDirection);
        this.direction = facingDirection;
        if (facingDirection.getAxis().isHorizontal()) {
            this.rotationX = 0.0f;
            this.rotationZ = this.direction.get2DDataValue() * 90;
        } else {
            this.rotationX = -90 * facingDirection.getAxisDirection().getStep();
            this.rotationZ = 0.0f;
        }
        this.recalculateBoundingBox();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("Facing", (byte)this.direction.get3DDataValue());
        compound.putBoolean("Invisible", this.isInvisible());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setDirection(Direction.from3DDataValue((int)compound.getByte("Facing")));
        this.setInvisible(compound.getBoolean("Invisible"));
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.setDirection(Direction.from3DDataValue((int)packet.getData()));
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, this.direction.get3DDataValue(), this.getPos());
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        BlockState state = this.level().getBlockState(this.getPos());
        if (state.hasProperty((Property)Constants.SAPPED) && this.level().getEntitiesOfClass(SapEntity.class, new AABB(this.getPos())).isEmpty()) {
            this.level().setBlockAndUpdate(this.getPos(), (BlockState)state.setValue((Property)Constants.SAPPED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean survives() {
        BlockState blockstate = this.level().getBlockState(this.pos.relative(this.direction.getOpposite()));
        return !blockstate.isSolid() && (!this.direction.getAxis().isHorizontal() || !DiodeBlock.isDiode((BlockState)blockstate)) ? false : this.level().getEntities((Entity)this, this.getBoundingBox(), HANGING_ENTITY).isEmpty();
    }

    public void playPlacementSound() {
    }

    public void dropItem(@Nullable Entity entity) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

