/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class MoveAwayFromBlockGoal
extends MoveToBlockGoal {
    private Block blockToAvoid;
    private Path path;

    public MoveAwayFromBlockGoal(PathfinderMob mob, Block blockToAvoid, double speedModifier, int searchRange) {
        super(mob, speedModifier, searchRange);
        this.blockToAvoid = blockToAvoid;
    }

    public boolean canUse() {
        if (!this.findNearestBlock()) {
            return false;
        }
        Vec3 vec3 = DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)12, (int)5, (Vec3)this.blockPos.getCenter());
        if (vec3 == null) {
            return false;
        }
        if (this.mob.distanceToSqr(vec3.x, vec3.y, vec3.z) < this.mob.distanceToSqr(this.blockPos.getCenter())) {
            return false;
        }
        this.path = this.mob.getNavigation().createPath(vec3.x, vec3.y, vec3.z, 0);
        return this.path != null;
    }

    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone();
    }

    protected void moveMobToBlock() {
        this.mob.getNavigation().moveTo(this.path, this.speedModifier);
    }

    protected boolean isValidTarget(LevelReader levelReader, BlockPos blockPos) {
        return levelReader.getBlockState(blockPos).is(this.blockToAvoid);
    }
}

