/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import team.recrafted.blastfromthepast.mixin.GoalAccessor;

public class PredicatedGoal<T extends Mob>
extends Goal {
    protected final Goal wrappedGoal;
    protected final T mob;
    protected final Predicate<T> predicate;
    protected final boolean checkWhileRunningAlso;

    public PredicatedGoal(Goal goal, T mob, Predicate<T> predicate, boolean checkWhileRunningAlso) {
        this.wrappedGoal = goal;
        this.mob = mob;
        this.predicate = predicate;
        this.checkWhileRunningAlso = checkWhileRunningAlso;
    }

    public PredicatedGoal(Goal goal, T mob, Predicate<T> predicate) {
        this(goal, mob, predicate, false);
    }

    public static <T extends Mob> PredicatedGoal<T> runIf(Goal goal, T mob, Predicate<T> predicate, boolean checkWhileRunningAlso) {
        return new PredicatedGoal<T>(goal, mob, predicate, checkWhileRunningAlso);
    }

    public boolean canUse() {
        return this.predicate.test(this.mob) && this.wrappedGoal.canUse();
    }

    public boolean canContinueToUse() {
        return (!this.checkWhileRunningAlso || this.predicate.test(this.mob)) && this.wrappedGoal.canContinueToUse();
    }

    public boolean isInterruptable() {
        return this.wrappedGoal.isInterruptable();
    }

    public void start() {
        this.wrappedGoal.start();
    }

    public void stop() {
        this.wrappedGoal.stop();
    }

    public boolean requiresUpdateEveryTick() {
        return this.wrappedGoal.requiresUpdateEveryTick();
    }

    public void tick() {
        this.wrappedGoal.tick();
    }

    public void setFlags(EnumSet<Goal.Flag> pFlagSet) {
        this.wrappedGoal.setFlags(pFlagSet);
    }

    public EnumSet<Goal.Flag> getFlags() {
        return this.wrappedGoal.getFlags();
    }

    protected int adjustedTickDelay(int pAdjustment) {
        return ((GoalAccessor)this.wrappedGoal).blastfromthepast$callAdjustedTickDelay(pAdjustment);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + String.format("[%s]", this.wrappedGoal.toString());
    }

    public boolean equals(@Nullable Object pOther) {
        if (this == pOther) {
            return true;
        }
        return pOther != null && ((Object)((Object)this)).getClass() == pOther.getClass() && this.wrappedGoal.equals(((PredicatedGoal)((Object)pOther)).wrappedGoal);
    }

    public int hashCode() {
        return this.wrappedGoal.hashCode();
    }
}

