/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.EventHooks;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.misc.ComplexAnimal;
import team.recrafted.blastfromthepast.mixin.ServerPlayerAccessor;
import team.recrafted.blastfromthepast.util.DebugFlags;
import team.recrafted.blastfromthepast.util.EntityHelper;
import team.recrafted.blastfromthepast.util.HitboxHelper;

public class RaidFoodContainerGoal<T extends PathfinderMob>
extends MoveToBlockGoal {
    private static final int SATURATION_TICKS = 40;
    private static final int CHEST_CLOSE_DELAY = 40;
    private final T foodRaider;
    private boolean wantsToRaid;
    private boolean canRaid;
    private int openCounter = 0;

    public RaidFoodContainerGoal(T mob, double speedModifier, int searchRange) {
        this(mob, speedModifier, searchRange, 1);
    }

    public RaidFoodContainerGoal(T mob, double speedModifier, int searchRange, int verticalSearchRange) {
        super(mob, speedModifier, searchRange, verticalSearchRange);
        this.foodRaider = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.nextStartTick <= 0) {
            if (!EventHooks.canEntityGrief((Level)this.foodRaider.level(), this.foodRaider)) {
                return false;
            }
            this.canRaid = false;
            this.wantsToRaid = ((ComplexAnimal)this.foodRaider).wantsMoreFood();
            if (this.wantsToRaid && DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
                BlastFromThePast.LOGGER.info("{} is ready to look for a food container to raid!", this.foodRaider);
            }
        }
        return super.canUse();
    }

    protected int nextStartTick(PathfinderMob creature) {
        return DebugFlags.DEBUG_RAID_FOOD_CONTAINER ? 40 : super.nextStartTick(creature);
    }

    public void start() {
        super.start();
        this.openCounter = 0;
    }

    public boolean canContinueToUse() {
        if (this.canRaid && this.openCounter > 0) {
            return true;
        }
        return this.canRaid && super.canContinueToUse();
    }

    public double acceptedDistance() {
        return HitboxHelper.getHitboxAdjustedDistance(this.foodRaider, 1.5);
    }

    public void tick() {
        super.tick();
        boolean close = false;
        if (this.openCounter > 0) {
            --this.openCounter;
            if (this.openCounter <= 0) {
                close = true;
            }
        }
        this.foodRaider.getLookControl().setLookAt((double)this.blockPos.getX() + 0.5, (double)(this.blockPos.getY() + 1), (double)this.blockPos.getZ() + 0.5, 10.0f, (float)this.foodRaider.getMaxHeadXRot());
        if (this.isReachedTarget()) {
            boolean raiding = false;
            Level level = this.foodRaider.level();
            BlockPos above = this.blockPos.above();
            BlockEntity blockEntity = level.getBlockEntity(above);
            if (this.canRaid && blockEntity instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity bcbe = (BaseContainerBlockEntity)blockEntity;
                raiding = true;
                if (close) {
                    this.tryTakeFood(bcbe);
                    RaidFoodContainerGoal.closeMenu(this.getFakePlayer((ServerLevel)level));
                } else if (this.openCounter <= 0) {
                    if (DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
                        BlastFromThePast.LOGGER.info("{} is raiding a food container at {}", this.foodRaider, (Object)above);
                    }
                    RaidFoodContainerGoal.openMenu(this.getFakePlayer((ServerLevel)level), (MenuProvider)bcbe);
                    this.openCounter = 40;
                }
            }
            if (!raiding || close) {
                if (DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
                    BlastFromThePast.LOGGER.info("{} is no longer raiding a food container at {}", this.foodRaider, (Object)above);
                }
                this.canRaid = false;
            }
        }
    }

    private void tryTakeFood(BaseContainerBlockEntity bcbe) {
        for (int slot = 0; slot < bcbe.getContainerSize(); ++slot) {
            ItemStack itemStack;
            ItemStack itemInSlot = bcbe.getItem(slot);
            if (!((ComplexAnimal)this.foodRaider).isWantedFood(itemInSlot) || (itemStack = bcbe.removeItem(slot, 1)).isEmpty()) continue;
            ((ComplexAnimal)this.foodRaider).takeFood(itemStack);
            ((ComplexAnimal)this.foodRaider).gotFood(40);
            BlastFromThePast.LOGGER.info("{} finished raiding a food container {}", this.foodRaider, (Object)bcbe);
            break;
        }
    }

    private static void closeMenu(FakePlayer fakePlayer) {
        BlastFromThePast.LOGGER.info("Closing menu {} for {}", (Object)fakePlayer.containerMenu, (Object)fakePlayer);
        fakePlayer.closeContainer();
    }

    private static void openMenu(FakePlayer player, MenuProvider menuProvider) {
        if (menuProvider != null) {
            if (player.containerMenu != player.inventoryMenu) {
                if (menuProvider.shouldTriggerClientSideContainerClosingOnOpen()) {
                    player.closeContainer();
                } else {
                    player.doCloseContainer();
                }
            }
            ((ServerPlayerAccessor)player).blastfromthepast$callNextContainerCounter();
            AbstractContainerMenu menu = menuProvider.createMenu(((ServerPlayerAccessor)player).blastfromthepast$getContainerCounter(), player.getInventory(), (Player)player);
            if (DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
                BlastFromThePast.LOGGER.info("Opening menu {} for {}", (Object)menu, (Object)player);
            }
            if (menu != null) {
                try {
                    ((ServerPlayerAccessor)player).blastfromthepast$initMenu(menu);
                    player.containerMenu = menu;
                }
                catch (Exception e) {
                    BlastFromThePast.LOGGER.debug("Check RaidFoodContainerGoal class line 164.", (Throwable)e);
                }
            }
        }
    }

    protected FakePlayer getFakePlayer(ServerLevel level) {
        return EntityHelper.getFakePlayer(level);
    }

    protected boolean findNearestBlock() {
        boolean foundNearestBlock = super.findNearestBlock();
        if (foundNearestBlock && DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
            BlastFromThePast.LOGGER.info("{} found a food container to raid!", this.foodRaider);
        }
        return foundNearestBlock;
    }

    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        BlockPos above = pos.above();
        BlockEntity blockEntity = level.getBlockEntity(above);
        if (blockEntity instanceof BaseContainerBlockEntity && this.wantsToRaid && !this.canRaid) {
            this.canRaid = true;
            if (DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
                BlastFromThePast.LOGGER.info("{} can raid a food container!", this.foodRaider);
            }
            return true;
        }
        return false;
    }

    public void stop() {
        super.stop();
        if (this.openCounter > 0) {
            this.openCounter = 0;
            if (DebugFlags.DEBUG_RAID_FOOD_CONTAINER) {
                BlastFromThePast.LOGGER.info("Forcing open food container to be closed for {}", this.foodRaider);
            }
            RaidFoodContainerGoal.closeMenu(this.getFakePlayer((ServerLevel)this.foodRaider.level()));
        }
    }
}

