/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.burrel;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import team.recrafted.blastfromthepast.entity.BurrelEntity;

public class BurrelClimbTreeGoal
extends Goal {
    private final BurrelEntity burrel;
    private float desiredYrot;

    public BurrelClimbTreeGoal(BurrelEntity burrel) {
        this.burrel = burrel;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (this.burrel.isBesideClimbableBlock()) {
            if (this.burrel.targetTree != null && !this.burrel.wantsToBeOnGround()) {
                return true;
            }
            this.burrel.setBesideClimbableBlock(false);
        }
        return false;
    }

    public void start() {
        BlockPos blockPos = this.burrel.blockPosition();
        if (blockPos.east().equals((Object)this.burrel.targetTree)) {
            this.desiredYrot = -90.0f;
        } else if (blockPos.west().equals((Object)this.burrel.targetTree)) {
            this.desiredYrot = 90.0f;
        } else if (blockPos.north().equals((Object)this.burrel.targetTree)) {
            this.desiredYrot = 0.0f;
        } else if (blockPos.south().equals((Object)this.burrel.targetTree)) {
            this.desiredYrot = 180.0f;
        } else {
            this.stop();
            return;
        }
        this.burrel.setYRot(this.desiredYrot);
    }

    public boolean canContinueToUse() {
        return this.burrel.isBesideClimbableBlock() && this.burrel.targetTree != null && !this.burrel.wantsToBeOnGround();
    }

    public void tick() {
        if (this.burrel.targetTree == null) {
            this.stop();
            return;
        }
        this.burrel.getNavigation().stop();
        this.burrel.setYRot(this.desiredYrot);
        this.burrel.setPos((double)this.burrel.getBlockX() + 0.5, this.burrel.getY() + 0.4, (double)this.burrel.getBlockZ() + 0.5);
        BlockPos pos = this.burrel.targetTree.mutable().setY((int)this.burrel.getY()).immutable();
        BlockState blockState = this.burrel.level().getBlockState(pos);
        if (!blockState.is(BlockTags.LOGS) && !blockState.is(BlockTags.LEAVES)) {
            this.burrel.setPos(pos.getCenter().subtract(0.0, 0.5, 0.0));
            this.stop();
        }
    }

    public void stop() {
        this.burrel.setBesideClimbableBlock(false);
        this.burrel.targetTree = null;
    }
}

