/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.complex_animal;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import team.recrafted.blastfromthepast.entity.misc.ComplexAnimal;

public class MoveToOrSitWithItemGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final Predicate<ItemEntity> wantedItems;
    private int cooldown;
    private final double speedModifier;

    public MoveToOrSitWithItemGoal(T mob, Predicate<ItemEntity> wantedItems, double speedModifier) {
        this.mob = mob;
        this.wantedItems = wantedItems;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.cooldown <= ((Mob)this.mob).tickCount && !this.mob.isBaby() && !this.mob.isInWater() && ((ComplexAnimal)this.mob).canPerformAction()) {
            if (this.hasItemInMouth()) {
                return true;
            }
            List items = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(6.0, 6.0, 6.0), this::isWantedItem);
            return !items.isEmpty();
        }
        return false;
    }

    protected boolean isWantedItem(ItemEntity ie) {
        return this.wantedItems.test(ie);
    }

    public void start() {
        if (this.hasItemInMouth()) {
            ((ComplexAnimal)this.mob).tryToSit();
        } else {
            List items = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(8.0, 8.0, 8.0), this::isWantedItem);
            if (!items.isEmpty()) {
                this.mob.getNavigation().moveTo((Entity)items.getFirst(), this.speedModifier);
            }
        }
        this.cooldown = 0;
    }

    private boolean hasItemInMouth() {
        return !((ComplexAnimal)this.mob).getItemInMouth().isEmpty();
    }

    public boolean canContinueToUse() {
        return !this.mob.isInWater() && (this.mob.getNavigation().isInProgress() || this.hasItemInMouth());
    }

    public void tick() {
        if (!((ComplexAnimal)this.mob).isSitting() && this.hasItemInMouth()) {
            ((ComplexAnimal)this.mob).tryToSit();
        }
    }

    public void stop() {
        ItemStack itemBySlot = ((ComplexAnimal)this.mob).getItemInMouth();
        if (!itemBySlot.isEmpty()) {
            this.mob.spawnAtLocation(itemBySlot);
            ((ComplexAnimal)this.mob).putItemInMouth(ItemStack.EMPTY, false);
            int seconds = this.mob.getRandom().nextInt(150) + 10;
            this.cooldown = ((Mob)this.mob).tickCount + seconds * 20;
        }
        ((ComplexAnimal)this.mob).setSitting(false);
    }
}

