/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.navigation;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.Vec3;
import team.recrafted.blastfromthepast.entity.ai.navigation.BFTPPathFinder;
import team.recrafted.blastfromthepast.entity.ai.navigation.BFTPWalkNodeProcessor;

public class BFTPGroundPathNavigation
extends GroundPathNavigation {
    private BFTPWalkNodeProcessor customNodeEvaluator;
    static final float EPSILON = 1.0E-8f;

    public BFTPGroundPathNavigation(Mob mob, Level world) {
        super(mob, world);
    }

    protected PathFinder createPathFinder(int maxVisitedNodes) {
        this.customNodeEvaluator = new BFTPWalkNodeProcessor();
        this.nodeEvaluator = this.customNodeEvaluator;
        this.nodeEvaluator.setCanPassDoors(true);
        return new BFTPPathFinder(this.nodeEvaluator, maxVisitedNodes);
    }

    protected void followThePath() {
        Path path = Objects.requireNonNull(this.path);
        Vec3 entityPos = this.getTempMobPos();
        int pathLength = path.getNodeCount();
        for (int i = path.getNextNodeIndex(); i < path.getNodeCount(); ++i) {
            if ((double)path.getNode((int)i).y == Math.floor(entityPos.y)) continue;
            pathLength = i;
            break;
        }
        Vec3 base = entityPos.add((double)(-this.mob.getBbWidth() * 0.5f), 0.0, (double)(-this.mob.getBbWidth() * 0.5f));
        Vec3 max = base.add((double)this.mob.getBbWidth(), (double)this.mob.getBbHeight(), (double)this.mob.getBbWidth());
        if (this.tryShortcut(path, new Vec3(this.mob.getX(), this.mob.getY(), this.mob.getZ()), pathLength, base, max) && (this.isAt(path, 0.5f) || this.atElevationChange(path) && this.isAt(path, this.mob.getBbWidth() * 0.5f))) {
            path.setNextNodeIndex(path.getNextNodeIndex() + 1);
        }
        this.doStuckDetection(entityPos);
    }

    private boolean isAt(Path path, float threshold) {
        Vec3 pathPos = path.getNextEntityPos((Entity)this.mob);
        return Mth.abs((float)((float)(this.mob.getX() - pathPos.x))) < threshold && Mth.abs((float)((float)(this.mob.getZ() - pathPos.z))) < threshold && Math.abs(this.mob.getY() - pathPos.y) < 1.0;
    }

    private boolean atElevationChange(Path path) {
        int curr = path.getNextNodeIndex();
        int end = Math.min(path.getNodeCount(), curr + Mth.ceil((float)(this.mob.getBbWidth() * 0.5f)) + 1);
        int currY = path.getNode((int)curr).y;
        for (int i = curr + 1; i < end; ++i) {
            if (path.getNode((int)i).y == currY) continue;
            return true;
        }
        return false;
    }

    private boolean tryShortcut(Path path, Vec3 entityPos, int pathLength, Vec3 base, Vec3 max) {
        int i = pathLength;
        while (--i > path.getNextNodeIndex()) {
            Vec3 vec = path.getEntityPosAtNode((Entity)this.mob, i).subtract(entityPos);
            if (!this.sweep(vec, base, max)) continue;
            path.setNextNodeIndex(i);
            return false;
        }
        return true;
    }

    private boolean sweep(Vec3 vec, Vec3 base, Vec3 max) {
        float t = 0.0f;
        float max_t = (float)vec.length();
        if (max_t < 1.0E-8f) {
            return true;
        }
        float[] tr = new float[3];
        int[] ldi = new int[3];
        int[] tri = new int[3];
        int[] step = new int[3];
        float[] tDelta = new float[3];
        float[] tNext = new float[3];
        float[] normed = new float[3];
        for (int i = 0; i < 3; ++i) {
            float value = BFTPGroundPathNavigation.element(vec, i);
            boolean dir = value >= 0.0f;
            step[i] = dir ? 1 : -1;
            float lead = BFTPGroundPathNavigation.element(dir ? max : base, i);
            tr[i] = BFTPGroundPathNavigation.element(dir ? base : max, i);
            ldi[i] = BFTPGroundPathNavigation.leadEdgeToInt(lead, step[i]);
            tri[i] = BFTPGroundPathNavigation.trailEdgeToInt(tr[i], step[i]);
            normed[i] = value / max_t;
            tDelta[i] = Mth.abs((float)(max_t / value));
            float dist = dir ? (float)(ldi[i] + 1) - lead : lead - (float)ldi[i];
            tNext[i] = tDelta[i] < Float.POSITIVE_INFINITY ? tDelta[i] * dist : Float.POSITIVE_INFINITY;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        do {
            int axis = tNext[0] < tNext[1] ? (tNext[0] < tNext[2] ? 0 : 2) : (tNext[1] < tNext[2] ? 1 : 2);
            float dt = tNext[axis] - t;
            t = tNext[axis];
            int n = axis;
            ldi[n] = ldi[n] + step[axis];
            int n2 = axis;
            tNext[n2] = tNext[n2] + tDelta[axis];
            for (int i = 0; i < 3; ++i) {
                int n3 = i;
                tr[n3] = tr[n3] + dt * normed[i];
                tri[i] = BFTPGroundPathNavigation.trailEdgeToInt(tr[i], step[i]);
            }
            int stepx = step[0];
            int x0 = axis == 0 ? ldi[0] : tri[0];
            int x1 = ldi[0] + stepx;
            int stepy = step[1];
            int y0 = axis == 1 ? ldi[1] : tri[1];
            int y1 = ldi[1] + stepy;
            int stepz = step[2];
            int z0 = axis == 2 ? ldi[2] : tri[2];
            int z1 = ldi[2] + stepz;
            for (int x = x0; x != x1; x += stepx) {
                for (int z = z0; z != z1; z += stepz) {
                    for (int y = y0; y != y1; y += stepy) {
                        BlockState block = this.level.getBlockState((BlockPos)pos.set(x, y, z));
                        if (block.isPathfindable(PathComputationType.LAND)) continue;
                        return false;
                    }
                    PathType below = this.customNodeEvaluator.getBlockPathTypeWithCustomEntitySize(new PathfindingContext((CollisionGetter)this.level, this.mob), x, y0 - 1, z, this.mob, 1, 1, 1);
                    if (below == PathType.WATER || below == PathType.LAVA || below == PathType.OPEN) {
                        return false;
                    }
                    PathType in = this.customNodeEvaluator.getBlockPathTypeWithCustomEntitySize(new PathfindingContext((CollisionGetter)this.level, this.mob), x, y0, z, this.mob, 1, y1 - y0, 1);
                    float priority = this.mob.getPathfindingMalus(in);
                    if (priority < 0.0f || priority >= 8.0f) {
                        return false;
                    }
                    if (in != PathType.DAMAGE_FIRE && in != PathType.DANGER_FIRE && in != PathType.DAMAGE_OTHER) continue;
                    return false;
                }
            }
        } while (t <= max_t);
        return true;
    }

    static int leadEdgeToInt(float coord, int step) {
        return Mth.floor((float)(coord - (float)step * 1.0E-8f));
    }

    static int trailEdgeToInt(float coord, int step) {
        return Mth.floor((float)(coord + (float)step * 1.0E-8f));
    }

    static float element(Vec3 v, int i) {
        return switch (i) {
            case 0 -> (float)v.x;
            case 1 -> (float)v.y;
            case 2 -> (float)v.z;
            default -> 0.0f;
        };
    }
}

