/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.misc;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import team.recrafted.blastfromthepast.entity.misc.StateValue;

public enum TransitioningState implements StateValue
{
    INACTIVE(0, false),
    INACTIVE_TO_ACTIVE(1, true),
    ACTIVE(2, false),
    ACTIVE_TO_INACTIVE(3, true);

    private final int id;
    private final boolean transitional;

    private TransitioningState(int id, boolean transitional) {
        this.id = id;
        this.transitional = transitional;
    }

    @Override
    public int id() {
        return this.id;
    }

    public boolean isTransitional() {
        return this.transitional;
    }

    public static TransitioningState byOrdinal(int pOrdinal) {
        if (pOrdinal < 0 || pOrdinal > TransitioningState.values().length) {
            pOrdinal = 0;
        }
        return TransitioningState.values()[pOrdinal];
    }

    public static void transition(boolean sleeping, Supplier<TransitioningState> stateGetter, Consumer<TransitioningState> stateSetter) {
        TransitioningState transition = TransitioningState.getTransition(stateGetter.get(), sleeping);
        if (transition != null) {
            stateSetter.accept(transition);
        }
    }

    @Nullable
    public static TransitioningState getTransition(TransitioningState previous, boolean active) {
        switch (previous.ordinal()) {
            case 0: {
                if (!active) break;
                return INACTIVE_TO_ACTIVE;
            }
            case 1: {
                if (active) break;
                return INACTIVE;
            }
            case 2: {
                if (active) break;
                return ACTIVE_TO_INACTIVE;
            }
            case 3: {
                if (!active) break;
                return ACTIVE;
            }
        }
        return null;
    }

    public static class TransitionTicker {
        private final Supplier<TransitioningState> stateGetter;
        private final Consumer<TransitioningState> stateSetter;
        private final int activateDuration;
        private final int deactivateDuration;
        private int countdown;

        public TransitionTicker(Supplier<TransitioningState> stateGetter, Consumer<TransitioningState> stateSetter, int activateDuration, int deactivateDuration) {
            this.stateGetter = stateGetter;
            this.stateSetter = stateSetter;
            this.activateDuration = activateDuration;
            this.deactivateDuration = deactivateDuration;
        }

        public void triggerStateChange() {
            switch (this.stateGetter.get().ordinal()) {
                case 1: {
                    this.countdown = this.activateDuration;
                    break;
                }
                case 3: {
                    this.countdown = this.deactivateDuration;
                    break;
                }
                default: {
                    this.countdown = 0;
                }
            }
        }

        public void tick(boolean canUpdateState) {
            if (this.countdown > 0 && --this.countdown <= 0 && canUpdateState) {
                switch (this.stateGetter.get().ordinal()) {
                    case 1: {
                        this.stateSetter.accept(ACTIVE);
                        break;
                    }
                    case 3: {
                        this.stateSetter.accept(INACTIVE);
                    }
                }
            }
        }
    }
}

