/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class PitFeature
extends Feature<Configuration> {
    private static final int OFFSET_Y = 6;
    private static final int SIZE_X = 16;
    private static final int SIZE_Y = 12;
    private static final int SIZE_Z = 16;
    private static final BlockState AIR = Blocks.CAVE_AIR.defaultBlockState();

    public PitFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        int y;
        int x;
        BlockPos origin = context.origin();
        WorldGenLevel worldGenLevel = context.level();
        RandomSource random = context.random();
        Configuration config = (Configuration)context.config();
        if (origin.getY() <= worldGenLevel.getMinBuildHeight() + 6) {
            return false;
        }
        origin = origin.below(6);
        boolean[] lakeShape = new boolean[3072];
        int numberOfBlobs = random.nextInt(6) + 6;
        for (int blobIndex = 0; blobIndex < numberOfBlobs; ++blobIndex) {
            double blobWidth = random.nextDouble() * 6.0 + 3.0;
            double blobHeight = random.nextDouble() * 6.0 + 4.0;
            double blobDepth = random.nextDouble() * 6.0 + 3.0;
            double blobCenterX = random.nextDouble() * (16.0 - blobWidth - 2.0) + 1.0 + blobWidth / 2.0;
            double blobCenterY = random.nextDouble() * (8.0 - blobHeight - 4.0) + 2.0 + blobHeight / 2.0;
            double blobCenterZ = random.nextDouble() * (16.0 - blobDepth - 2.0) + 1.0 + blobDepth / 2.0;
            for (int x2 = 1; x2 < 15; ++x2) {
                for (int z = 1; z < 15; ++z) {
                    for (int y2 = 1; y2 < 11; ++y2) {
                        double dx = ((double)x2 - blobCenterX) / (blobWidth / 2.0);
                        double dy = ((double)y2 - blobCenterY) / (blobHeight / 2.0);
                        double dz = ((double)z - blobCenterZ) / (blobDepth / 2.0);
                        double distance = dx * dx + dy * dy + dz * dz;
                        if (!(distance < 1.0)) continue;
                        lakeShape[(x2 * 16 + z) * 12 + y2] = true;
                    }
                }
            }
        }
        BlockState blockState = config.block().getState(random, origin);
        BlockState cover = config.cover().orElse(config.block()).getState(random, origin);
        for (x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (y = 0; y < 12; ++y) {
                    boolean isEdge;
                    boolean bl = isEdge = !lakeShape[(x * 16 + z) * 12 + y] && (x < 15 && lakeShape[((x + 1) * 16 + z) * 12 + y] || x > 0 && lakeShape[((x - 1) * 16 + z) * 12 + y] || z < 15 && lakeShape[(x * 16 + z + 1) * 12 + y] || z > 0 && lakeShape[(x * 16 + (z - 1)) * 12 + y] || y < 11 && lakeShape[(x * 16 + z) * 12 + y + 1] || y > 0 && lakeShape[(x * 16 + z) * 12 + (y - 1)]);
                    if (!isEdge) continue;
                    BlockState currentState = worldGenLevel.getBlockState(origin.offset(x, y, z));
                    if (y >= 6 && currentState.liquid()) {
                        return false;
                    }
                    if (y >= 6 || currentState.isSolid() || worldGenLevel.getBlockState(origin.offset(x, y, z)) == blockState) continue;
                    return false;
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (y = 0; y < 12; ++y) {
                    BlockPos blockPos;
                    if (!lakeShape[(x * 16 + z) * 12 + y] || !this.canReplaceBlock(worldGenLevel.getBlockState(blockPos = origin.offset(x, y, z)))) continue;
                    if (y == 5) {
                        worldGenLevel.setBlock(blockPos, cover, 2);
                        continue;
                    }
                    if (y >= 6) {
                        worldGenLevel.setBlock(blockPos, AIR, 2);
                        worldGenLevel.scheduleTick(blockPos, AIR.getBlock(), 0);
                        this.markAboveForPostProcessing(worldGenLevel, blockPos);
                        continue;
                    }
                    worldGenLevel.setBlock(blockPos, blockState, 2);
                }
            }
        }
        BlockState barrierState = config.barrier().getState(random, origin);
        if (!barrierState.isAir()) {
            for (int x3 = 0; x3 < 16; ++x3) {
                for (int z = 0; z < 16; ++z) {
                    for (int y3 = 0; y3 < 12; ++y3) {
                        BlockState currentState;
                        boolean isEdge;
                        boolean bl = isEdge = !lakeShape[(x3 * 16 + z) * 12 + y3] && (x3 < 15 && lakeShape[((x3 + 1) * 16 + z) * 12 + y3] || x3 > 0 && lakeShape[((x3 - 1) * 16 + z) * 12 + y3] || z < 15 && lakeShape[(x3 * 16 + z + 1) * 12 + y3] || z > 0 && lakeShape[(x3 * 16 + (z - 1)) * 12 + y3] || y3 < 7 && lakeShape[(x3 * 16 + z) * 12 + y3 + 1] || y3 > 0 && lakeShape[(x3 * 16 + z) * 12 + (y3 - 1)]);
                        if (!isEdge || y3 >= 6 && random.nextInt(2) == 0 || !(currentState = worldGenLevel.getBlockState(origin.offset(x3, y3, z))).isSolid() || currentState.is(BlockTags.LAVA_POOL_STONE_CANNOT_REPLACE)) continue;
                        BlockPos blockPos = origin.offset(x3, y3, z);
                        worldGenLevel.setBlock(blockPos, barrierState, 2);
                        this.markAboveForPostProcessing(worldGenLevel, blockPos);
                    }
                }
            }
        }
        return true;
    }

    private boolean canReplaceBlock(BlockState state) {
        return !state.is(BlockTags.FEATURES_CANNOT_REPLACE);
    }

    public record Configuration(BlockStateProvider block, Optional<BlockStateProvider> cover, BlockStateProvider barrier) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("block").forGetter(Configuration::block), (App)BlockStateProvider.CODEC.optionalFieldOf("cover").forGetter(Configuration::cover), (App)BlockStateProvider.CODEC.fieldOf("barrier").forGetter(Configuration::barrier)).apply((Applicative)instance, Configuration::new));
    }
}

