/*
 * Decompiled with CFR 0.152.
 */
package itzazeem.axteam.commands;

import itzazeem.axteam.AxTeam;
import itzazeem.axteam.managers.TeamChatManager;
import itzazeem.axteam.managers.TeamManager;
import itzazeem.axteam.models.Team;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeamCommand
implements CommandExecutor {
    private final TeamManager teamManager;
    private final TeamChatManager chatManager;

    public TeamCommand(AxTeam plugin) {
        this.teamManager = plugin.getTeamManager();
        this.chatManager = plugin.getTeamChatManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use team commands.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelp(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "create": {
                this.handleCreate(player, args);
                break;
            }
            case "invite": {
                this.handleInvite(player, args);
                break;
            }
            case "join": {
                this.handleJoin(player, args);
                break;
            }
            case "echest": 
            case "enderchest": {
                this.handleEnderChest(player);
                break;
            }
            case "info": {
                this.handleInfo(player);
                break;
            }
            case "disable": {
                this.handleDisable(player);
                break;
            }
            case "chat": {
                this.handleChat(player, args);
                break;
            }
            default: {
                this.sendHelp(player);
            }
        }
        return true;
    }

    private void sendHelp(Player player) {
        player.sendMessage(String.valueOf(ChatColor.GOLD) + "AxTeam Commands:");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team create <name> - Create a new team");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team invite <player> - Invite player (owner only)");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team join <name> - Join team (must be invited)");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team echest - Open team ender chest");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team info - Show team members");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team disable - Delete your team");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/team chat <msg> or toggle - Team-only chat");
    }

    private void handleCreate(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team create <name>");
            return;
        }
        String name = args[1];
        boolean success = this.teamManager.createTeam(player, name);
        player.sendMessage(success ? String.valueOf(ChatColor.GREEN) + "Team '" + name + "' created!" : String.valueOf(ChatColor.RED) + "You already own a team or name is taken.");
    }

    private void handleInvite(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team invite <player>");
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return;
        }
        boolean success = this.teamManager.invitePlayer(player, target);
        player.sendMessage(success ? String.valueOf(ChatColor.GREEN) + "Invited " + target.getName() + " to your team." : String.valueOf(ChatColor.RED) + "You must be the team owner.");
    }

    private void handleJoin(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /team join <teamname>");
            return;
        }
        String name = args[1];
        boolean success = this.teamManager.joinTeam(player, name);
        player.sendMessage(success ? String.valueOf(ChatColor.GREEN) + "Joined team '" + name + "'!" : String.valueOf(ChatColor.RED) + "No invite found or team doesn't exist.");
    }

    private void handleEnderChest(Player player) {
        Team team = this.teamManager.getTeamOf(player);
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        player.openInventory(team.getEnderChest());
    }

    private void handleInfo(Player player) {
        Team team = this.teamManager.getTeamOf(player);
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        player.sendMessage(String.valueOf(ChatColor.AQUA) + "Team: " + team.getName());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Owner: " + Bukkit.getOfflinePlayer((UUID)team.getOwner()).getName());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Members:");
        for (UUID uuid : team.getMembers()) {
            player.sendMessage(" - " + Bukkit.getOfflinePlayer((UUID)uuid).getName());
        }
    }

    private void handleDisable(Player player) {
        boolean success = this.teamManager.deleteTeam(player);
        player.sendMessage(success ? String.valueOf(ChatColor.RED) + "Your team has been deleted." : String.valueOf(ChatColor.RED) + "You are not the team owner.");
    }

    private void handleChat(Player player, String[] args) {
        Team team = this.teamManager.getTeamOf(player);
        if (team == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a team.");
            return;
        }
        if (args.length == 1) {
            this.chatManager.toggleChat(player.getUniqueId());
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Team chat " + (this.chatManager.isChatToggled(player.getUniqueId()) ? "enabled." : "disabled."));
            return;
        }
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        String formatted = String.valueOf(ChatColor.AQUA) + "[" + team.getName() + "] " + String.valueOf(ChatColor.RESET) + player.getName() + ": " + message;
        for (Player member : team.getOnlineMembers()) {
            member.sendMessage(formatted);
        }
    }
}

