/*
 * Decompiled with CFR 0.152.
 */
package itzazeem.axteam.listeners;

import itzazeem.axteam.AxTeam;
import itzazeem.axteam.managers.TeamChatManager;
import itzazeem.axteam.managers.TeamManager;
import itzazeem.axteam.models.Team;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatListener
implements Listener {
    private final TeamManager teamManager;
    private final TeamChatManager chatManager;

    public ChatListener(AxTeam plugin) {
        this.teamManager = plugin.getTeamManager();
        this.chatManager = plugin.getTeamChatManager();
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!this.chatManager.isChatToggled(player.getUniqueId())) {
            return;
        }
        Team team = this.teamManager.getTeamOf(player);
        if (team == null) {
            return;
        }
        event.setCancelled(true);
        String formatted = String.valueOf(ChatColor.AQUA) + "[" + team.getName() + "] " + String.valueOf(ChatColor.RESET) + player.getName() + ": " + event.getMessage();
        for (Player member : team.getOnlineMembers()) {
            member.sendMessage(formatted);
        }
    }
}

