/*
 * Decompiled with CFR 0.152.
 */
package itzazeem.axteam.managers;

import itzazeem.axteam.models.Team;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class TeamManager {
    private final Map<String, Team> teamsByName = new HashMap<String, Team>();
    private final Map<UUID, String> playerTeams = new HashMap<UUID, String>();
    private final Map<UUID, String> pendingInvites = new HashMap<UUID, String>();

    public boolean createTeam(Player owner, String name) {
        if (this.playerTeams.containsKey(owner.getUniqueId()) || this.teamsByName.containsKey(name.toLowerCase())) {
            return false;
        }
        Team team = new Team(name, owner.getUniqueId());
        this.teamsByName.put(name.toLowerCase(), team);
        this.playerTeams.put(owner.getUniqueId(), name.toLowerCase());
        return true;
    }

    public boolean invitePlayer(Player owner, Player target) {
        Team team = this.getTeamOf(owner);
        if (team == null || !team.getOwner().equals(owner.getUniqueId())) {
            return false;
        }
        this.pendingInvites.put(target.getUniqueId(), team.getName().toLowerCase());
        return true;
    }

    public boolean joinTeam(Player player, String teamName) {
        String invite = this.pendingInvites.get(player.getUniqueId());
        if (invite == null || !invite.equalsIgnoreCase(teamName)) {
            return false;
        }
        Team team = this.teamsByName.get(teamName.toLowerCase());
        if (team == null) {
            return false;
        }
        team.addMember(player.getUniqueId());
        this.playerTeams.put(player.getUniqueId(), teamName.toLowerCase());
        this.pendingInvites.remove(player.getUniqueId());
        return true;
    }

    public Team getTeamOf(Player player) {
        String teamName = this.playerTeams.get(player.getUniqueId());
        return teamName == null ? null : this.teamsByName.get(teamName);
    }

    public boolean deleteTeam(Player owner) {
        Team team = this.getTeamOf(owner);
        if (team == null || !team.getOwner().equals(owner.getUniqueId())) {
            return false;
        }
        for (UUID member : team.getMembers()) {
            this.playerTeams.remove(member);
        }
        this.teamsByName.remove(team.getName().toLowerCase());
        return true;
    }
}

