/*
 * Decompiled with CFR 0.152.
 */
package itzazeem.axteam.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class Team {
    private final String name;
    private final UUID owner;
    private final Set<UUID> members = new HashSet<UUID>();
    private final Inventory enderChest;

    public Team(String name, UUID owner) {
        this.name = name;
        this.owner = owner;
        this.members.add(owner);
        this.enderChest = Bukkit.createInventory(null, (int)27, (String)"Team EnderChest");
    }

    public String getName() {
        return this.name;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Set<UUID> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    public Inventory getEnderChest() {
        return this.enderChest;
    }

    public void addMember(UUID uuid) {
        this.members.add(uuid);
    }

    public void removeMember(UUID uuid) {
        this.members.remove(uuid);
    }

    public boolean isMember(UUID uuid) {
        return this.members.contains(uuid);
    }

    public List<Player> getOnlineMembers() {
        ArrayList<Player> online = new ArrayList<Player>();
        for (UUID uuid : this.members) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null || !p.isOnline()) continue;
            online.add(p);
        }
        return online;
    }
}

