/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.registry_dump.dump;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.possible_triangle.registry_dump.dump.IDump;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class FileDump
implements IDump {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final DynamicCommandExceptionType FAILED_WRITE = new DynamicCommandExceptionType(it -> Component.m_237113_((String)"Failed to write to {}").m_130946_(it.toString()));
    private static final DynamicCommandExceptionType FAILED_CREATE = new DynamicCommandExceptionType(it -> Component.m_237113_((String)"Failed to create {}").m_130946_(it.toString()));
    private final Path outputDirectory;

    public FileDump(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public <T> void dump(ResourceKey<? extends Registry<T>> key, Stream<? extends Holder<T>> entries) throws CommandSyntaxException {
        Path registryDirectory = this.outputDirectory.resolve(key.m_135782_().m_135815_());
        Map<String, Collection<ResourceLocation>> byNamespace = this.gatherIds(entries);
        for (Map.Entry<String, Collection<ResourceLocation>> entry : byNamespace.entrySet()) {
            Collection<ResourceLocation> ids = entry.getValue();
            Path file = registryDirectory.resolve(entry.getKey() + ".json");
            JsonArray json = new JsonArray(ids.size());
            ids.forEach(it -> json.add(it.toString()));
            this.write(file, (JsonElement)json);
        }
    }

    private Map<String, Collection<ResourceLocation>> gatherIds(Stream<? extends Holder<?>> entries) {
        HashMap<String, Collection<ResourceLocation>> byNamespace = new HashMap<String, Collection<ResourceLocation>>();
        Stream<ResourceLocation> ids = entries.map(Holder::m_203543_).map(Optional::orElseThrow).map(ResourceKey::m_135782_);
        ids.forEach(it -> {
            Collection list = byNamespace.computeIfAbsent(it.m_135827_(), $ -> new HashSet());
            list.add(it);
        });
        return byNamespace;
    }

    private void write(Path path, JsonElement json) throws CommandSyntaxException {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw FAILED_CREATE.create((Object)path);
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            throw FAILED_WRITE.create((Object)path);
        }
    }
}

