/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.registry_dump.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.possible_triangle.registry_dump.CommonClass;
import com.possible_triangle.registry_dump.dump.IDump;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;

public class DumpCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dump").requires(it -> it.hasPermission(3))).then(((LiteralArgumentBuilder)Commands.literal((String)"registry").executes(ctx -> DumpCommand.dumpRegistries((CommandContext<CommandSourceStack>)ctx, $ -> true))).then(Commands.argument((String)"type", (ArgumentType)ResourceKeyArgument.key((ResourceKey)BuiltInRegistries.REGISTRY.key())).executes(ctx -> DumpCommand.dumpRegistries((CommandContext<CommandSourceStack>)ctx, DumpCommand.createArgumentPredicate((CommandContext<CommandSourceStack>)ctx))))));
    }

    private static Predicate<ResourceKey<? extends Registry<?>>> createArgumentPredicate(CommandContext<CommandSourceStack> context) {
        ResourceKey key = (ResourceKey)context.getArgument("type", ResourceKey.class);
        return key::equals;
    }

    private static int dumpRegistries(CommandContext<CommandSourceStack> context, Predicate<ResourceKey<? extends Registry<?>>> predicate) throws CommandSyntaxException {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        List<RegistryAccess.RegistryEntry> registries = server.registryAccess().registries().filter(it -> predicate.test(it.key())).toList();
        IDump emitter = CommonClass.getDump(server);
        for (RegistryAccess.RegistryEntry registry : registries) {
            emitter.dump(registry);
        }
        return registries.size();
    }
}

