/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.registry_dump.dump;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.possible_triangle.registry_dump.dump.IDump;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class FileDump
implements IDump {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final DynamicCommandExceptionType FAILED_WRITE = new DynamicCommandExceptionType(it -> class_2561.method_43470((String)"Failed to write to {}").method_27693(it.toString()));
    private static final DynamicCommandExceptionType FAILED_CREATE = new DynamicCommandExceptionType(it -> class_2561.method_43470((String)"Failed to create {}").method_27693(it.toString()));
    private final Path outputDirectory;

    public FileDump(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public <T> void dump(class_5321<? extends class_2378<T>> key, Stream<? extends class_6880<T>> entries) throws CommandSyntaxException {
        Path registryDirectory = this.outputDirectory.resolve(key.method_29177().method_12832());
        Map<String, Collection<class_2960>> byNamespace = this.gatherIds(entries);
        for (Map.Entry<String, Collection<class_2960>> entry : byNamespace.entrySet()) {
            Collection<class_2960> ids = entry.getValue();
            Path file = registryDirectory.resolve(entry.getKey() + ".json");
            JsonArray json = new JsonArray(ids.size());
            ids.stream().map(class_2960::toString).sorted().forEach(arg_0 -> ((JsonArray)json).add(arg_0));
            this.write(file, (JsonElement)json);
        }
    }

    private Map<String, Collection<class_2960>> gatherIds(Stream<? extends class_6880<?>> entries) {
        HashMap<String, Collection<class_2960>> byNamespace = new HashMap<String, Collection<class_2960>>();
        Stream<class_2960> ids = entries.map(class_6880::method_40230).map(Optional::orElseThrow).map(class_5321::method_29177);
        ids.forEach(it -> {
            Collection list = byNamespace.computeIfAbsent(it.method_12836(), $ -> new HashSet());
            list.add(it);
        });
        return byNamespace;
    }

    private void write(Path path, JsonElement json) throws CommandSyntaxException {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw FAILED_CREATE.create((Object)path);
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            throw FAILED_WRITE.create((Object)path);
        }
    }
}

