/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;

public class BasaltHowlerAttackGoal
extends class_1352 {
    private final class_1314 basaltHowler;
    private final double speed;
    private final float attackDistanceSq;
    private final int cooldownTicks;
    private final int chargeTime;
    private final int trembleDuration;
    private final float tremorRadius;
    private final float howlRadius;
    private final float attackDamage;
    private int attackCooldown = 0;
    private int chargeTicksLeft = 0;
    private boolean isCharging = false;
    private int trembleTicksLeft = 0;
    private AttackPhase currentPhase = AttackPhase.APPROACH;

    public BasaltHowlerAttackGoal(class_1314 entity, double speed, float attackDistance, int cooldownTicks) {
        this.basaltHowler = entity;
        this.speed = speed;
        this.attackDistanceSq = attackDistance * attackDistance;
        this.cooldownTicks = cooldownTicks;
        this.chargeTime = 30;
        this.trembleDuration = 20;
        this.tremorRadius = 3.5f;
        this.howlRadius = 6.0f;
        this.attackDamage = 9.0f;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 target = this.basaltHowler.method_5968();
        return target != null && target.method_5805() && this.attackCooldown <= 0;
    }

    public boolean method_6266() {
        class_1309 target = this.basaltHowler.method_5968();
        return target != null && target.method_5805() || this.isCharging || this.trembleTicksLeft > 0;
    }

    public void method_6269() {
        this.currentPhase = AttackPhase.APPROACH;
        this.attackCooldown = 0;
    }

    public void method_6270() {
        this.attackCooldown = this.cooldownTicks;
        this.currentPhase = AttackPhase.APPROACH;
        this.isCharging = false;
        this.chargeTicksLeft = 0;
        this.trembleTicksLeft = 0;
    }

    public void method_6268() {
        class_1309 target = this.basaltHowler.method_5968();
        if (target == null) {
            return;
        }
        switch (this.currentPhase.ordinal()) {
            case 0: {
                this.handleApproachPhase(target);
                break;
            }
            case 1: {
                this.handleChargingPhase(target);
                break;
            }
            case 2: {
                this.performHowlAttack(target);
                break;
            }
            case 3: {
                this.handleTremorPhase();
                break;
            }
            case 4: {
                --this.attackCooldown;
                if (this.attackCooldown > 0) break;
                this.currentPhase = AttackPhase.APPROACH;
            }
        }
    }

    private void handleApproachPhase(class_1309 target) {
        double distanceSq = this.basaltHowler.method_5858((class_1297)target);
        this.basaltHowler.method_5942().method_6335((class_1297)target, this.speed);
        this.basaltHowler.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        if (distanceSq <= (double)this.attackDistanceSq) {
            boolean useHowlAttack = this.basaltHowler.method_59922().method_43057() < 0.3f;
            this.currentPhase = AttackPhase.CHARGING;
            this.isCharging = true;
            this.chargeTicksLeft = this.chargeTime;
            this.basaltHowler.method_5942().method_6340();
            this.basaltHowler.method_37908().method_43128(null, this.basaltHowler.method_23317(), this.basaltHowler.method_23318(), this.basaltHowler.method_23321(), useHowlAttack ? class_3417.field_38831 : class_3417.field_21867, class_3419.field_15251, 1.0f, useHowlAttack ? 1.5f : 0.8f);
        }
    }

    private void handleChargingPhase(class_1309 target) {
        class_1937 class_19372;
        if (this.chargeTicksLeft % 5 == 0 && (class_19372 = this.basaltHowler.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (int i = 0; i < 3; ++i) {
                double offsetX = this.basaltHowler.method_59922().method_43059() * 0.2;
                double offsetY = this.basaltHowler.method_59922().method_43059() * 0.2;
                double offsetZ = this.basaltHowler.method_59922().method_43059() * 0.2;
                serverWorld.method_14199((class_2394)class_2398.field_11239, this.basaltHowler.method_23317() + offsetX, this.basaltHowler.method_23318() + 0.5 + offsetY, this.basaltHowler.method_23321() + offsetZ, 1, 0.0, 0.05, 0.0, 0.0);
                serverWorld.method_14199((class_2394)class_2398.field_22247, this.basaltHowler.method_23317() + offsetX, this.basaltHowler.method_23318() + 0.5 + offsetY, this.basaltHowler.method_23321() + offsetZ, 2, 0.0, 0.2, 0.0, 0.02);
            }
        }
        --this.chargeTicksLeft;
        if (this.chargeTicksLeft <= 0) {
            boolean useHowlAttack;
            this.isCharging = false;
            boolean bl = useHowlAttack = this.basaltHowler.method_59922().method_43057() < 0.3f;
            if (useHowlAttack) {
                this.currentPhase = AttackPhase.HOWL;
            } else {
                this.currentPhase = AttackPhase.TREMOR;
                this.trembleTicksLeft = this.trembleDuration;
            }
        }
    }

    private void handleTremorPhase() {
        --this.trembleTicksLeft;
        class_1937 class_19372 = this.basaltHowler.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (int i = 0; i < 4; ++i) {
                double offsetX = (double)this.basaltHowler.method_59922().method_43057() * 2.0 - 1.0;
                double offsetZ = (double)this.basaltHowler.method_59922().method_43057() * 2.0 - 1.0;
                serverWorld.method_14199((class_2394)class_2398.field_17430, this.basaltHowler.method_23317() + offsetX, this.basaltHowler.method_23318(), this.basaltHowler.method_23321() + offsetZ, 1, 0.0, 0.2, 0.0, 0.02);
            }
        }
        if (this.trembleTicksLeft <= 0) {
            this.performTremorAttack();
            this.currentPhase = AttackPhase.COOLDOWN;
            this.attackCooldown = this.cooldownTicks;
        }
    }

    private void performTremorAttack() {
        this.basaltHowler.method_37908().method_60511(null, this.basaltHowler.method_23317(), this.basaltHowler.method_23318(), this.basaltHowler.method_23321(), (class_6880)class_3417.field_15152, class_3419.field_15251, 1.0f, 0.5f);
        class_1937 class_19372 = this.basaltHowler.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (int i = 0; i < 80; ++i) {
                double angle = (double)i * (Math.PI * 2) / 80.0;
                double distance = (double)this.tremorRadius * (0.3 + 0.7 * (double)this.basaltHowler.method_59922().method_43057());
                double offsetX = Math.cos(angle) * distance;
                double offsetZ = Math.sin(angle) * distance;
                serverWorld.method_14199((class_2394)class_2398.field_11237, this.basaltHowler.method_23317() + offsetX, this.basaltHowler.method_23318() + 0.1, this.basaltHowler.method_23321() + offsetZ, 1, 0.0, 0.05, 0.0, 0.0);
                if (i % 4 != 0) continue;
                serverWorld.method_14199((class_2394)class_2398.field_23956, this.basaltHowler.method_23317() + offsetX, this.basaltHowler.method_23318() + 0.3, this.basaltHowler.method_23321() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        class_238 attackBox = new class_238(this.basaltHowler.method_23317() - (double)this.tremorRadius, this.basaltHowler.method_23318(), this.basaltHowler.method_23321() - (double)this.tremorRadius, this.basaltHowler.method_23317() + (double)this.tremorRadius, this.basaltHowler.method_23318() + 2.0, this.basaltHowler.method_23321() + (double)this.tremorRadius);
        List affectedEntities = this.basaltHowler.method_37908().method_8390(class_1309.class, attackBox, entity -> entity != this.basaltHowler && !entity.method_7325());
        for (class_1309 entity2 : affectedEntities) {
            float damage = this.attackDamage;
            double distSq = entity2.method_5858((class_1297)this.basaltHowler);
            float distanceFactor = (float)(1.0 - Math.sqrt(distSq) / ((double)this.tremorRadius + 0.5));
            damage = (float)((double)damage * Math.max(0.5, (double)distanceFactor));
            entity2.method_5643(this.basaltHowler.method_37908().method_48963().method_48812((class_1309)this.basaltHowler), damage);
            class_243 knockbackVec = entity2.method_19538().method_1020(this.basaltHowler.method_19538()).method_1029();
            double knockbackStrength = 0.7 * (1.0 - Math.sqrt(distSq) / (double)this.tremorRadius);
            entity2.method_5762(knockbackVec.field_1352 * knockbackStrength, 0.2 * knockbackStrength, knockbackVec.field_1350 * knockbackStrength);
            entity2.field_6037 = true;
        }
    }

    private void performHowlAttack(class_1309 target) {
        this.basaltHowler.method_37908().method_43128(null, this.basaltHowler.method_23317(), this.basaltHowler.method_23318(), this.basaltHowler.method_23321(), class_3417.field_38830, class_3419.field_15251, 1.5f, 0.8f);
        class_1937 class_19372 = this.basaltHowler.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (int i = 0; i < 60; ++i) {
                double angle = (double)i * (Math.PI * 2) / 60.0;
                double distance = (double)this.howlRadius * (0.3 + 0.7 * (double)this.basaltHowler.method_59922().method_43057());
                double offsetX = Math.cos(angle) * distance;
                double offsetZ = Math.sin(angle) * distance;
                serverWorld.method_14199((class_2394)class_2398.field_22246, this.basaltHowler.method_23317() + offsetX, this.basaltHowler.method_23318() + 0.5, this.basaltHowler.method_23321() + offsetZ, 1, 0.0, 0.05, 0.0, 0.01);
                if (i % 6 != 0) continue;
                serverWorld.method_14199((class_2394)class_2398.field_38004, this.basaltHowler.method_23317() + offsetX * 0.8, this.basaltHowler.method_23318() + 0.7, this.basaltHowler.method_23321() + offsetZ * 0.8, 1, 0.0, 0.02, 0.0, 0.01);
            }
        }
        class_238 attackBox = new class_238(this.basaltHowler.method_23317() - (double)this.howlRadius, this.basaltHowler.method_23318(), this.basaltHowler.method_23321() - (double)this.howlRadius, this.basaltHowler.method_23317() + (double)this.howlRadius, this.basaltHowler.method_23318() + 3.0, this.basaltHowler.method_23321() + (double)this.howlRadius);
        List affectedEntities = this.basaltHowler.method_37908().method_8390(class_1309.class, attackBox, entity -> entity != this.basaltHowler && !entity.method_7325());
        for (class_1309 entity2 : affectedEntities) {
            float damage = this.attackDamage * 0.7f;
            double distSq = entity2.method_5858((class_1297)this.basaltHowler);
            float distanceFactor = (float)(1.0 - Math.sqrt(distSq) / (double)this.howlRadius);
            damage = (float)((double)damage * Math.max(0.5, (double)distanceFactor));
            entity2.method_5643(this.basaltHowler.method_37908().method_48963().method_48821((class_1297)this.basaltHowler), damage);
            int baseDuration = 100;
            int scaledDuration = (int)((double)baseDuration * Math.max(0.5, (double)distanceFactor));
            entity2.method_6092(new class_1293(class_1294.field_5909, scaledDuration, 1));
            entity2.method_6092(new class_1293(class_1294.field_5911, scaledDuration, 0));
        }
        this.currentPhase = AttackPhase.COOLDOWN;
        this.attackCooldown = this.cooldownTicks;
    }

    private static enum AttackPhase {
        APPROACH,
        CHARGING,
        HOWL,
        TREMOR,
        COOLDOWN;

    }
}

