/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.entity.custom;

import cassetu.mystbornhorizons.network.BossMusicPacket;
import cassetu.mystbornhorizons.network.ModPackets;
import cassetu.mystbornhorizons.sound.ModSounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3959;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7094;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_9254;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class HavenicaEntity
extends class_1588 {
    private class_3213 bossBar;
    private Set<class_3222> playersHearingMusic = new HashSet<class_3222>();
    private boolean cutsceneActive = false;
    private int cutsceneTick = 0;
    private Set<class_3222> cutscenePlayers = new HashSet<class_3222>();
    private Map<class_3222, class_1934> originalGameModes = new HashMap<class_3222, class_1934>();
    private Map<class_3222, class_243> originalPositions = new HashMap<class_3222, class_243>();
    private int shockwaveCooldown = 0;
    private static final int SHOCKWAVE_COOLDOWN = 500;
    private boolean shockwaveActive = false;
    private int shockwaveTimer = 0;
    private List<Double> waveDistances = new ArrayList<Double>();
    private List<Integer> waveDelays = new ArrayList<Integer>();
    private static final double WAVE_SPEED = 1.4;
    private static final double MAX_WAVE_DISTANCE = 15.0;
    private int toxicLaserCooldown = 0;
    private int rootNetworkCooldown = 0;
    private int boggedSummonCooldown = 0;
    private boolean isGardensWrathActive = false;
    private static final int LASER_COOLDOWN = 95;
    private static final int ROOT_COOLDOWN = 260;
    private static final int BOGGED_SUMMON_COOLDOWN = 570;
    private class_243[] lockedLaserTargets = new class_243[3];
    private int teleportCooldown = 0;
    private static final int TELEPORT_COOLDOWN = 240;
    private int teleportDelayTicks = 0;
    private static final int TELEPORT_DELAY = 40;
    private boolean toxicLaserCharging = false;
    private int toxicLaserChargeTicks = 0;
    private class_1657 toxicLaserTarget = null;
    private static final int LASER_CHARGE_TIME = 60;
    private int healingTick = 0;
    private static final int HEALING_INTERVAL = 20;
    private static final float HEALING_AMOUNT = 25.0f;
    private boolean rootNetworkActive = false;
    private int rootNetworkTimer = 0;
    private static final int ROOT_PILLAR_PHASE = 60;
    private static final int ROOT_LINE_PHASE = 220;
    private List<class_243> rootPillars = new ArrayList<class_243>();
    public final class_7094 idleAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;

    public HavenicaEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5880(true);
        if (!world.method_8608()) {
            this.bossBar = new class_3213(this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795);
            this.method_6033(this.method_6063());
        }
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        if (this.bossBar != null) {
            this.bossBar.method_14088(player);
        }
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        if (this.bossBar != null) {
            this.bossBar.method_14089(player);
        }
        if (this.playersHearingMusic.contains(player)) {
            ModPackets.sendToPlayer(new BossMusicPacket(false, null), player);
            this.playersHearingMusic.remove(player);
        }
    }

    public void method_36209() {
        super.method_36209();
        if (this.bossBar != null) {
            this.bossBar.method_14094();
        }
        if (!this.method_37908().method_8608()) {
            for (class_3222 player : this.playersHearingMusic) {
                ModPackets.sendToPlayer(new BossMusicPacket(false, null), player);
            }
            this.playersHearingMusic.clear();
        }
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (!this.method_37908().method_8608()) {
            for (class_3222 player : this.playersHearingMusic) {
                ModPackets.sendToPlayer(new BossMusicPacket(false, null), player);
            }
            this.playersHearingMusic.clear();
        }
        super.method_5650(reason);
    }

    protected void method_5959() {
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.initCustomGoals();
    }

    protected void initCustomGoals() {
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 1220.0).method_26868(class_5134.field_23719, 0.0).method_26868(class_5134.field_23723, 20.0).method_26868(class_5134.field_23721, 2.5).method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23718, 100.0).method_26868(class_5134.field_23724, 11.0);
    }

    public void method_6005(double strength, double x, double z) {
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private void handleCutscene() {
        double z;
        double x;
        double z2;
        double x2;
        if (!this.cutsceneActive) {
            return;
        }
        ++this.cutsceneTick;
        if (this.method_37908().method_8608()) {
            return;
        }
        class_3218 serverWorld = (class_3218)this.method_37908();
        if (serverWorld == null) {
            System.out.println("ERROR: ServerWorld is null!");
            return;
        }
        if (this.cutsceneTick == 1) {
            this.initializeCutscene(serverWorld);
        }
        this.updateCutsceneCameras();
        if (this.cutsceneTick % 20 == 0) {
            System.out.println("DEBUG: Cutscene tick " + this.cutsceneTick + "/100");
        }
        if (this.cutsceneTick == 15) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14865, this.method_5634(), 2.0f, 0.6f);
        }
        if (this.cutsceneTick == 35) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_38075, this.method_5634(), 1.5f, 0.5f);
        }
        if (this.cutsceneTick == 55) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14803, this.method_5634(), 2.5f, 0.4f);
        }
        if (this.cutsceneTick <= 50 && this.cutsceneTick > 0) {
            for (int spiral = 0; spiral < 5; ++spiral) {
                double spiralHeight = (double)this.cutsceneTick / 50.0 * 6.0;
                double angle = (double)this.cutsceneTick * 0.4 + (double)spiral * Math.PI * 2.0 / 5.0;
                double radius = Math.max(0.8, 3.0 - spiralHeight / 6.0 * 0.8);
                double x3 = this.method_23317() + Math.cos(angle) * radius;
                double z3 = this.method_23321() + Math.sin(angle) * radius;
                if (!this.isValidParticlePosition(x3, this.method_23318() + spiralHeight, z3)) continue;
                serverWorld.method_14199((class_2394)class_2398.field_11249, x3, this.method_23318() + spiralHeight, z3, 3, 0.2, 0.2, 0.2, 0.0);
                serverWorld.method_14199((class_2394)class_2398.field_38002, x3, this.method_23318() + spiralHeight, z3, 2, 0.15, 0.15, 0.15, 0.08);
                serverWorld.method_14199((class_2394)class_2398.field_11251, x3, this.method_23318() + spiralHeight, z3, 4, 0.3, 0.3, 0.3, 0.1);
            }
            double expansion = Math.min((double)this.cutsceneTick / 50.0 * 12.0, 15.0);
            for (double angle = 0.0; angle < Math.PI * 2; angle += 0.15707963267948966) {
                double x4 = this.method_23317() + Math.cos(angle) * expansion;
                double z4 = this.method_23321() + Math.sin(angle) * expansion;
                if (!this.isValidParticlePosition(x4, this.method_23318() + 0.1, z4)) continue;
                serverWorld.method_14199((class_2394)class_2398.field_43380, x4, this.method_23318() + 0.1, z4, 5, 0.4, 0.1, 0.4, 0.15);
                if (this.cutsceneTick <= 25) continue;
                serverWorld.method_14199((class_2394)class_2398.field_11239, x4, this.method_23318() + 0.2, z4, 2, 0.2, 0.1, 0.2, 0.05);
            }
            if (this.cutsceneTick % 3 == 0) {
                for (double r = 1.0; r <= 6.0; r += 0.4) {
                    for (double angle = 0.0; angle < Math.PI * 2; angle += 0.2617993877991494) {
                        double x5 = this.method_23317() + Math.cos(angle) * r;
                        double z5 = this.method_23321() + Math.sin(angle) * r;
                        if (!this.isValidParticlePosition(x5, this.method_23318() + 0.8, z5)) continue;
                        serverWorld.method_14199((class_2394)class_2398.field_22247, x5, this.method_23318() + 0.8, z5, 2, 0.15, 0.15, 0.15, 0.02);
                        serverWorld.method_14199((class_2394)class_2398.field_29644, x5, this.method_23318() + 1.2, z5, 1, 0.1, 0.1, 0.1, 0.0);
                    }
                }
            }
            if (this.cutsceneTick % 10 == 0) {
                for (int i = 0; i < 8; ++i) {
                    double height = 2.0 + this.field_5974.method_43058() * 4.0;
                    double lightningX = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 8.0;
                    double lightningZ = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 8.0;
                    if (!this.isValidParticlePosition(lightningX, this.method_23318() + height, lightningZ)) continue;
                    for (double y = 0.0; y <= height; y += 0.2) {
                        serverWorld.method_14199((class_2394)class_2398.field_29644, lightningX, this.method_23318() + y, lightningZ, 1, 0.05, 0.05, 0.05, 0.0);
                    }
                }
            }
        }
        if (this.cutsceneTick == 50) {
            serverWorld.method_14199((class_2394)class_2398.field_11221, this.method_23317(), this.method_23318() + 3.0, this.method_23321(), 3, 0.5, 0.5, 0.5, 0.0);
            int maxRings = 8;
            for (int ring = 0; ring < maxRings; ++ring) {
                double radius = (double)(ring + 1) * 2.5;
                int particlesPerRing = Math.min(20, (int)(radius * 3.0));
                for (int p = 0; p < particlesPerRing; ++p) {
                    double angle = (double)p / (double)particlesPerRing * Math.PI * 2.0;
                    x2 = this.method_23317() + Math.cos(angle) * radius;
                    z2 = this.method_23321() + Math.sin(angle) * radius;
                    if (!this.isValidParticlePosition(x2, this.method_23318() + 1.0, z2)) continue;
                    serverWorld.method_14199((class_2394)class_2398.field_22246, x2, this.method_23318() + 1.0, z2, 8, 0.5, 0.8, 0.5, 0.2);
                    serverWorld.method_14199((class_2394)class_2398.field_11237, x2, this.method_23318() + 3.0, z2, 5, 0.8, 0.8, 0.8, 0.15);
                    serverWorld.method_14199((class_2394)class_2398.field_28478, x2, this.method_23318() + 1.5, z2, 4, 0.3, 0.3, 0.3, 0.1);
                }
            }
            for (double height = 0.0; height <= 10.0; height += 0.5) {
                double ringRadius = 1.0 + Math.sin(height * 0.3) * 2.0;
                int ringParticles = 16;
                for (int i = 0; i < ringParticles; ++i) {
                    double angle = (double)i / (double)ringParticles * Math.PI * 2.0;
                    x = this.method_23317() + Math.cos(angle) * ringRadius;
                    z = this.method_23321() + Math.sin(angle) * ringRadius;
                    if (!this.isValidParticlePosition(x, this.method_23318() + height, z)) continue;
                    serverWorld.method_14199((class_2394)class_2398.field_11215, x, this.method_23318() + height, z, 2, 0.1, 0.1, 0.1, 0.05);
                }
            }
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14803, this.method_5634(), 3.0f, 0.3f);
        }
        if (this.cutsceneTick > 50 && this.cutsceneTick <= 100) {
            double progress = Math.min((double)(this.cutsceneTick - 50) / 50.0, 1.0);
            double maxRadius = progress * 15.0;
            for (int rootLine = 0; rootLine < 12; ++rootLine) {
                double angle = (double)rootLine * 0.5235987755982988;
                for (double dist = 0.0; dist <= maxRadius; dist += 0.6) {
                    if (!(Math.abs(dist - maxRadius) < 0.8)) continue;
                    x = this.method_23317() + Math.cos(angle) * dist;
                    z = this.method_23321() + Math.sin(angle) * dist;
                    if (!this.isValidParticlePosition(x, this.method_23318() + 0.1, z)) continue;
                    serverWorld.method_14199((class_2394)class_2398.field_11219, x, this.method_23318() + 0.1, z, 12, 0.8, 0.2, 0.8, 0.2);
                    serverWorld.method_14199((class_2394)class_2398.field_28803, x, this.method_23318() + 1.5, z, 6, 0.5, 0.5, 0.5, 0.1);
                    for (int branch = 0; branch < 4; ++branch) {
                        double branchAngle = angle + (double)(branch - 2) * 0.25;
                        double branchX = x + Math.cos(branchAngle) * 0.8;
                        double branchZ = z + Math.sin(branchAngle) * 0.8;
                        if (!this.isValidParticlePosition(branchX, this.method_23318() + 0.1, branchZ)) continue;
                        serverWorld.method_14199((class_2394)class_2398.field_17741, branchX, this.method_23318() + 0.1, branchZ, 4, 0.3, 0.1, 0.3, 0.08);
                        serverWorld.method_14199((class_2394)class_2398.field_11211, branchX, this.method_23318() + 0.8, branchZ, 2, 0.2, 0.2, 0.2, 0.05);
                    }
                    serverWorld.method_14199((class_2394)class_2398.field_43380, x, this.method_23318() + 0.8, z, 8, 0.4, 0.4, 0.4, 0.3);
                }
            }
            int maxSpores = 20;
            for (int i = 0; i < maxSpores; ++i) {
                double sporeX = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 30.0;
                double sporeZ = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 30.0;
                double sporeY = this.method_23318() + this.field_5974.method_43058() * 12.0;
                if (!this.isValidParticlePosition(sporeX, sporeY, sporeZ)) continue;
                serverWorld.method_14199((class_2394)class_2398.field_28803, sporeX, sporeY, sporeZ, 2, 0.2, 0.2, 0.2, 0.04);
                serverWorld.method_14199((class_2394)class_2398.field_47493, sporeX, sporeY, sporeZ, 1, 0.1, 0.1, 0.1, 0.02);
            }
            if (this.cutsceneTick % 8 == 0) {
                for (int wave = 0; wave < 3; ++wave) {
                    double waveRadius = 4.0 + (double)wave * 3.0;
                    for (double waveAngle = 0.0; waveAngle < Math.PI * 2; waveAngle += 0.19634954084936207) {
                        double waveX = this.method_23317() + Math.cos(waveAngle) * waveRadius;
                        double waveZ = this.method_23321() + Math.sin(waveAngle) * waveRadius;
                        if (!this.isValidParticlePosition(waveX, this.method_23318() + 0.3, waveZ)) continue;
                        serverWorld.method_14199((class_2394)class_2398.field_28479, waveX, this.method_23318() + 0.3, waveZ, 3, 0.2, 0.1, 0.2, 0.0);
                    }
                }
            }
        }
        if (this.cutsceneTick == 100) {
            for (double y = 1.0; y <= 8.0; y += 0.2) {
                double radius = Math.max(0.8, 2.0 + Math.sin(y * 0.5) * 1.0);
                int particleCount = Math.min(48, (int)(radius * 12.0));
                for (int i = 0; i < particleCount; ++i) {
                    double angle = (double)i / (double)particleCount * Math.PI * 2.0;
                    x2 = this.method_23317() + Math.cos(angle) * radius;
                    z2 = this.method_23321() + Math.sin(angle) * radius;
                    if (!this.isValidParticlePosition(x2, this.method_23318() + y, z2)) continue;
                    serverWorld.method_14199((class_2394)class_2398.field_11207, x2, this.method_23318() + y, z2, 2, 0.08, 0.08, 0.08, 0.0);
                    if (!(y > 5.0)) continue;
                    serverWorld.method_14199((class_2394)class_2398.field_11215, x2, this.method_23318() + y, z2, 4, 0.15, 0.15, 0.15, 0.04);
                    serverWorld.method_14199((class_2394)class_2398.field_11220, x2, this.method_23318() + y, z2, 2, 0.1, 0.1, 0.1, 0.02);
                }
            }
            for (double pillarY = 0.0; pillarY <= 12.0; pillarY += 0.3) {
                serverWorld.method_14199((class_2394)class_2398.field_22246, this.method_23317(), this.method_23318() + pillarY, this.method_23321(), 4, 0.3, 0.1, 0.3, 0.05);
                if (!(pillarY > 8.0)) continue;
                serverWorld.method_14199((class_2394)class_2398.field_11216, this.method_23317(), this.method_23318() + pillarY, this.method_23321(), 2, 0.2, 0.1, 0.2, 0.02);
            }
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15119, this.method_5634(), 2.5f, 0.6f);
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14671, this.method_5634(), 1.5f, 0.7f);
            this.endCutscene();
        }
    }

    private boolean isValidParticlePosition(double x, double y, double z) {
        if (!(Double.isFinite(x) && Double.isFinite(y) && Double.isFinite(z))) {
            return false;
        }
        double maxDistance = 100.0;
        double entityX = this.method_23317();
        double entityY = this.method_23318();
        double entityZ = this.method_23321();
        double distance = Math.sqrt(Math.pow(x - entityX, 2.0) + Math.pow(y - entityY, 2.0) + Math.pow(z - entityZ, 2.0));
        return distance <= maxDistance && y >= -64.0 && y <= 320.0;
    }

    private void initializeCutscene(class_3218 serverWorld) {
        try {
            class_238 cutsceneArea = this.method_5829().method_1014(30.0);
            List nearbyPlayers = serverWorld.method_18467(class_1657.class, cutsceneArea).stream().filter(player -> player instanceof class_3222).map(player -> (class_3222)player).filter(Objects::nonNull).collect(Collectors.toList());
            for (class_3222 player2 : nearbyPlayers) {
                try {
                    this.cutscenePlayers.add(player2);
                    this.originalGameModes.put(player2, player2.field_13974.method_14257());
                    this.originalPositions.put(player2, player2.method_19538());
                    player2.method_7336(class_1934.field_9219);
                    double angle = Math.atan2(player2.method_23321() - this.method_23321(), player2.method_23317() - this.method_23317());
                    double distance = 8.0;
                    double cameraX = this.method_23317() + Math.cos(angle) * distance;
                    double cameraY = Math.max(this.method_23318() + 4.0, -60.0);
                    double cameraZ = this.method_23321() + Math.sin(angle) * distance;
                    if (Double.isFinite(cameraX) && Double.isFinite(cameraY) && Double.isFinite(cameraZ)) {
                        player2.method_14251(player2.method_51469(), cameraX, cameraY, cameraZ, player2.method_36454(), player2.method_36455());
                        class_243 lookTarget = new class_243(this.method_23317(), this.method_23318() + 2.0, this.method_23321());
                        if (Double.isFinite(lookTarget.field_1352) && Double.isFinite(lookTarget.field_1351) && Double.isFinite(lookTarget.field_1350)) {
                            player2.method_5702(class_2183.class_2184.field_9851, lookTarget);
                        }
                    }
                    player2.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7l\u26a0 \u00a74\u00a7lHAVENICA'S POWER GROWS \u00a7c\u00a7l\u26a0"), false);
                    player2.method_7353((class_2561)class_2561.method_43470((String)"\u00a76\u00a7lWitness the awakening of the Garden's Wrath!"), false);
                }
                catch (Exception e) {
                    System.out.println("ERROR: Failed to initialize cutscene for player " + player2.method_5477().getString() + ": " + e.getMessage());
                    this.cutscenePlayers.remove(player2);
                    this.originalGameModes.remove(player2);
                    this.originalPositions.remove(player2);
                }
            }
            System.out.println("DEBUG: Cutscene initialized for " + this.cutscenePlayers.size() + " players");
        }
        catch (Exception e) {
            System.out.println("ERROR: Failed to initialize cutscene: " + e.getMessage());
            this.cleanupCutscene();
        }
    }

    private void updateCutsceneCameras() {
        if (this.cutscenePlayers.isEmpty()) {
            return;
        }
        HashSet<class_3222> playersToUpdate = new HashSet<class_3222>(this.cutscenePlayers);
        for (class_3222 player : playersToUpdate) {
            if (player == null || !player.method_5805()) {
                this.cutscenePlayers.remove(player);
                this.originalGameModes.remove(player);
                this.originalPositions.remove(player);
                continue;
            }
            try {
                class_243 lookTarget;
                double cameraZ;
                double cameraX;
                class_243 originalPos = this.originalPositions.get(player);
                if (originalPos == null) continue;
                if (this.cutsceneTick <= 50) {
                    double baseAngle = Math.atan2(originalPos.field_1350 - this.method_23321(), originalPos.field_1352 - this.method_23317());
                    double angle = (double)this.cutsceneTick * 0.025 + baseAngle;
                    double distance = Math.max(6.0, 7.0 + Math.sin((double)this.cutsceneTick * 0.08) * 1.5);
                    double height = Math.max(this.method_23318() + 3.5 + Math.sin((double)this.cutsceneTick * 0.06) * 1.5, -60.0);
                    cameraX = this.method_23317() + Math.cos(angle) * distance;
                    if (!this.isValidPosition(cameraX, height, cameraZ = this.method_23321() + Math.sin(angle) * distance)) continue;
                    player.method_14251(player.method_51469(), cameraX, height, cameraZ, player.method_36454(), player.method_36455());
                    lookTarget = new class_243(this.method_23317(), this.method_23318() + 2.5, this.method_23321());
                    if (!this.isValidPosition(lookTarget.field_1352, lookTarget.field_1351, lookTarget.field_1350)) continue;
                    player.method_5702(class_2183.class_2184.field_9851, lookTarget);
                    continue;
                }
                if (this.cutsceneTick == 50) {
                    double cameraZ2;
                    double cameraY;
                    double angle = Math.atan2(originalPos.field_1350 - this.method_23321(), originalPos.field_1352 - this.method_23317());
                    double distance = 12.0;
                    double cameraX2 = this.method_23317() + Math.cos(angle) * distance;
                    if (!this.isValidPosition(cameraX2, cameraY = Math.max(this.method_23318() + 8.0, -60.0), cameraZ2 = this.method_23321() + Math.sin(angle) * distance)) continue;
                    player.method_14251(player.method_51469(), cameraX2, cameraY, cameraZ2, player.method_36454(), player.method_36455());
                    class_243 lookTarget2 = new class_243(this.method_23317(), this.method_23318() + 3.0, this.method_23321());
                    if (!this.isValidPosition(lookTarget2.field_1352, lookTarget2.field_1351, lookTarget2.field_1350)) continue;
                    player.method_5702(class_2183.class_2184.field_9851, lookTarget2);
                    continue;
                }
                if (this.cutsceneTick <= 50) continue;
                double progress = Math.min((double)(this.cutsceneTick - 50) / 50.0, 1.0);
                double height = Math.max(this.method_23318() + 6.0 + progress * 6.0, -60.0);
                double angle = Math.atan2(originalPos.field_1350 - this.method_23321(), originalPos.field_1352 - this.method_23317()) + progress * 0.3;
                double distance = Math.max(6.0, 8.0 + progress * 4.0);
                cameraX = this.method_23317() + Math.cos(angle) * distance;
                if (!this.isValidPosition(cameraX, height, cameraZ = this.method_23321() + Math.sin(angle) * distance)) continue;
                player.method_14251(player.method_51469(), cameraX, height, cameraZ, player.method_36454(), player.method_36455());
                lookTarget = new class_243(this.method_23317(), this.method_23318() + 1.0, this.method_23321());
                if (!this.isValidPosition(lookTarget.field_1352, lookTarget.field_1351, lookTarget.field_1350)) continue;
                player.method_5702(class_2183.class_2184.field_9851, lookTarget);
            }
            catch (Exception e) {
                System.out.println("ERROR: Failed to update camera for player " + player.method_5477().getString() + ": " + e.getMessage());
                this.cutscenePlayers.remove(player);
                this.originalGameModes.remove(player);
                this.originalPositions.remove(player);
            }
        }
    }

    private boolean isValidPosition(double x, double y, double z) {
        return Double.isFinite(x) && Double.isFinite(y) && Double.isFinite(z) && y >= -64.0 && y <= 320.0;
    }

    private void endCutscene() {
        HashSet<class_3222> playersToRestore = new HashSet<class_3222>(this.cutscenePlayers);
        for (class_3222 player : playersToRestore) {
            if (player == null || !player.method_5805()) continue;
            try {
                class_243 originalPos;
                class_1934 originalMode = this.originalGameModes.get(player);
                if (originalMode != null) {
                    player.method_7336(originalMode);
                }
                if ((originalPos = this.originalPositions.get(player)) != null && this.isValidPosition(originalPos.field_1352, originalPos.field_1351, originalPos.field_1350)) {
                    player.method_14251(player.method_51469(), originalPos.field_1352, originalPos.field_1351, originalPos.field_1350, player.method_36454(), player.method_36455());
                } else {
                    System.out.println("WARNING: Original position for " + player.method_5477().getString() + " is invalid, using fallback");
                    class_243 fallbackPos = new class_243(this.method_23317() + 10.0, this.method_23318() + 2.0, this.method_23321());
                    player.method_14251(player.method_51469(), fallbackPos.field_1352, fallbackPos.field_1351, fallbackPos.field_1350, player.method_36454(), player.method_36455());
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a72\u00a7l\u300e \u00a7a\u00a7lGARDEN'S WRATH AWAKENED \u00a72\u00a7l\u300f"), true);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76The ancient forest spirit has been enraged!"), false);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7lPrepare for battle!"), false);
            }
            catch (Exception e) {
                System.out.println("ERROR: Failed to restore player " + player.method_5477().getString() + ": " + e.getMessage());
                try {
                    class_1934 originalMode = this.originalGameModes.get(player);
                    if (originalMode == null) continue;
                    player.method_7336(originalMode);
                }
                catch (Exception e2) {
                    System.out.println("ERROR: Failed to restore game mode for " + player.method_5477().getString());
                }
            }
        }
        this.cutscenePlayers.clear();
        this.originalGameModes.clear();
        this.originalPositions.clear();
        this.cutsceneActive = false;
        this.cutsceneTick = 0;
        System.out.println("DEBUG: Cutscene completed and players restored to original positions!");
    }

    private class_243 findSafeTeleportPosition(class_3222 player) {
        double[] distances;
        for (double distance : distances = new double[]{10.0, 12.0, 15.0, 8.0}) {
            for (int angle = 0; angle < 16; ++angle) {
                double y;
                int yOffset;
                double radians = (double)angle / 16.0 * Math.PI * 2.0;
                double x = this.method_23317() + Math.cos(radians) * distance;
                double z = this.method_23321() + Math.sin(radians) * distance;
                for (yOffset = 0; yOffset <= 5; ++yOffset) {
                    y = this.method_23318() + (double)yOffset;
                    if (!this.isSafeTeleportLocation(x, y, z)) continue;
                    return new class_243(x, y, z);
                }
                for (yOffset = -1; yOffset >= -3; --yOffset) {
                    y = this.method_23318() + (double)yOffset;
                    if (!this.isSafeTeleportLocation(x, y, z)) continue;
                    return new class_243(x, y, z);
                }
            }
        }
        return null;
    }

    private boolean isSafeTeleportLocation(double x, double y, double z) {
        if (!this.isValidPosition(x, y, z)) {
            return false;
        }
        class_2338 pos = new class_2338((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
        if (!this.method_37908().method_8320(pos).method_26215() || !this.method_37908().method_8320(pos.method_10084()).method_26215()) {
            return false;
        }
        boolean hasFloorBelow = false;
        for (int i = 1; i <= 3; ++i) {
            class_2338 belowPos = pos.method_10087(i);
            if (this.method_37908().method_8320(belowPos).method_26215()) continue;
            hasFloorBelow = true;
            break;
        }
        if (!hasFloorBelow) {
            return false;
        }
        double distanceToBoss = Math.sqrt(Math.pow(x - this.method_23317(), 2.0) + Math.pow(z - this.method_23321(), 2.0));
        return distanceToBoss >= 1.0;
    }

    private void cleanupCutscene() {
        if (!this.cutscenePlayers.isEmpty()) {
            HashSet<class_3222> playersToCleanup = new HashSet<class_3222>(this.cutscenePlayers);
            for (class_3222 player : playersToCleanup) {
                if (player == null || !player.method_5805()) continue;
                try {
                    class_243 originalPos;
                    class_1934 originalMode = this.originalGameModes.get(player);
                    if (originalMode != null) {
                        player.method_7336(originalMode);
                    }
                    if ((originalPos = this.originalPositions.get(player)) == null || !this.isValidPosition(originalPos.field_1352, originalPos.field_1351, originalPos.field_1350)) continue;
                    player.method_14251(player.method_51469(), originalPos.field_1352, originalPos.field_1351, originalPos.field_1350, player.method_36454(), player.method_36455());
                }
                catch (Exception e) {
                    System.out.println("ERROR: Failed to cleanup player " + player.method_5477().getString() + ": " + e.getMessage());
                }
            }
            this.cutscenePlayers.clear();
            this.originalGameModes.clear();
            this.originalPositions.clear();
        }
        this.cutsceneActive = false;
        this.cutsceneTick = 0;
    }

    private void handleBossMusicForPlayers() {
        HashSet<class_3222> currentNearbyPlayers = new HashSet<class_3222>();
        for (class_3222 player : ((class_3218)this.method_37908()).method_18456()) {
            if (!(this.method_5858((class_1297)player) <= 2025.0)) continue;
            currentNearbyPlayers.add(player);
        }
        for (class_3222 player : currentNearbyPlayers) {
            if (this.playersHearingMusic.contains(player)) continue;
            ModPackets.sendToPlayer(new BossMusicPacket(true, ModSounds.HAVENICA_BOSS_MUSIC), player);
            this.playersHearingMusic.add(player);
        }
        for (class_3222 player : new HashSet<class_3222>(this.playersHearingMusic)) {
            if (currentNearbyPlayers.contains(player)) continue;
            ModPackets.sendToPlayer(new BossMusicPacket(false, null), player);
            this.playersHearingMusic.remove(player);
        }
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        if (!this.method_37908().method_8608()) {
            for (class_3222 player : this.playersHearingMusic) {
                ModPackets.sendToPlayer(new BossMusicPacket(false, null), player);
            }
            this.playersHearingMusic.clear();
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.bossBar != null) {
            this.bossBar.method_5408(this.method_6032() / this.method_6063());
        }
        if (this.cutsceneActive) {
            this.handleCutscene();
        }
        if (!this.method_37908().method_8608()) {
            class_1657 nearestPlayer;
            int healingInterval;
            if (!this.method_29504()) {
                this.handleBossMusicForPlayers();
            }
            if (this.method_5809() && !this.method_6059(class_1294.field_5912)) {
                this.method_6092(new class_1293(class_1294.field_5912, 600, 0));
            }
            if (this.toxicLaserCooldown > 0) {
                --this.toxicLaserCooldown;
            }
            if (this.rootNetworkCooldown > 0) {
                --this.rootNetworkCooldown;
            }
            if (this.boggedSummonCooldown > 0) {
                --this.boggedSummonCooldown;
            }
            if (this.teleportCooldown > 0) {
                --this.teleportCooldown;
            }
            if (this.shockwaveCooldown > 0) {
                --this.shockwaveCooldown;
            }
            if (this.shockwaveActive) {
                this.tickShockwaveBlast();
            }
            if (this.rootNetworkActive) {
                ++this.rootNetworkTimer;
                if (this.rootNetworkTimer <= 60) {
                    this.spawnRootPillarParticles();
                } else if (this.rootNetworkTimer <= 220) {
                    this.spawnRootLineParticles();
                    this.damagePlayersInLines();
                } else {
                    this.rootNetworkActive = false;
                    this.rootNetworkTimer = 0;
                    this.rootPillars.clear();
                    this.rootNetworkCooldown = 260;
                }
            }
            if (this.toxicLaserCharging) {
                ++this.toxicLaserChargeTicks;
                if (this.hasValidLaserTargets()) {
                    this.createTripleLaserChargingEffect();
                    if (this.toxicLaserChargeTicks >= 60) {
                        this.fireTripleToxicLaser();
                        this.toxicLaserCharging = false;
                        this.toxicLaserChargeTicks = 0;
                        this.toxicLaserTarget = null;
                        this.clearLaserTargets();
                    }
                } else {
                    this.toxicLaserCharging = false;
                    this.toxicLaserChargeTicks = 0;
                    this.toxicLaserTarget = null;
                    this.clearLaserTargets();
                }
            }
            if (this.teleportDelayTicks > 0) {
                --this.teleportDelayTicks;
                if (this.teleportDelayTicks == 0 && this.teleportCooldown <= 0) {
                    this.tryTeleportToHavenCore();
                }
            }
            ++this.healingTick;
            int n = healingInterval = this.method_6059(class_1294.field_5912) ? 160 : 20;
            if (this.healingTick >= healingInterval) {
                if (this.method_6032() < this.method_6063()) {
                    int havenCoreCount = this.countNearbyHavenCores(50.0);
                    float dynamicHealingAmount = Math.max(5.0f, (float)havenCoreCount * 5.0f);
                    this.method_6025(dynamicHealingAmount);
                    int particleCount = Math.min(3 + havenCoreCount * 2, 15);
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11201, this.method_23317(), this.method_23318() + 1.5, this.method_23321(), particleCount, 0.3, 0.3, 0.3, 0.1);
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11211, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), Math.min(5 + havenCoreCount, 12), 0.5, 0.5, 0.5, 0.05);
                    if (havenCoreCount >= 3) {
                        ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11207, this.method_23317(), this.method_23318() + 2.0, this.method_23321(), havenCoreCount, 0.8, 0.8, 0.8, 0.1);
                        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15119, this.method_5634(), 0.5f, 1.5f);
                    }
                    System.out.println("DEBUG: Healed " + dynamicHealingAmount + " HP with " + havenCoreCount + " Haven Cores nearby");
                }
                this.healingTick = 0;
            }
            if (!this.isGardensWrathActive && this.method_6032() <= this.method_6063() * 0.5f) {
                System.out.println("DEBUG: Health threshold reached (" + this.method_6032() + "/" + this.method_6063() + "), activating Gardens Wrath");
                this.activateGardensWrath();
            }
            if ((nearestPlayer = this.method_37908().method_18460((class_1297)this, 20.0)) != null) {
                if (this.toxicLaserCooldown <= 0 && !this.toxicLaserCharging) {
                    this.useToxicLaser(nearestPlayer);
                }
                if (this.rootNetworkCooldown <= 0 && !this.rootNetworkActive) {
                    this.useRootNetwork(nearestPlayer);
                }
                if (!this.isGardensWrathActive && this.shockwaveCooldown <= 0) {
                    this.useShockwaveBlast();
                }
                if (this.isGardensWrathActive && this.boggedSummonCooldown <= 0) {
                    this.summonBoggedMinions();
                }
            }
        }
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
        }
    }

    private int countNearbyHavenCores(double radius) {
        if (this.method_37908().method_8608()) {
            return 0;
        }
        int coreCount = 0;
        class_238 searchArea = new class_238(this.method_23317() - radius, this.method_23318() - radius, this.method_23321() - radius, this.method_23317() + radius, this.method_23318() + radius, this.method_23321() + radius);
        List nearbyEntities = this.method_37908().method_8335((class_1297)this, searchArea);
        for (class_1297 entity : nearbyEntities) {
            double actualDistance;
            if (!entity.getClass().getSimpleName().contains("HavenCore") && !entity.method_5864().toString().contains("haven_core") && !entity.method_5477().getString().toLowerCase().contains("haven core") || !((actualDistance = Math.sqrt(Math.pow(entity.method_23317() - this.method_23317(), 2.0) + Math.pow(entity.method_23318() - this.method_23318(), 2.0) + Math.pow(entity.method_23321() - this.method_23321(), 2.0))) <= radius)) continue;
            ++coreCount;
        }
        return coreCount;
    }

    private void summonBoggedMinions() {
        for (int i = 0; i < 2; ++i) {
            double angle = (double)i * 1.5707963267948966;
            double distance = 3.0;
            double x = this.method_23317() + Math.cos(angle) * distance;
            double z = this.method_23321() + Math.sin(angle) * distance;
            class_9254 bogged = (class_9254)class_1299.field_49148.method_5883(this.method_37908());
            if (bogged == null) continue;
            bogged.method_5808(x, this.method_23318(), z, 0.0f, 0.0f);
            class_1799 chestplate = new class_1799((class_1935)class_1802.field_8523);
            try {
                class_6880 emeraldMaterial = this.method_37908().method_30349().method_30530(class_7924.field_42083).method_55841(class_2960.method_60655((String)"minecraft", (String)"emerald")).orElse(null);
                class_6880 eyePattern = this.method_37908().method_30349().method_30530(class_7924.field_42082).method_55841(class_2960.method_60655((String)"minecraft", (String)"eye")).orElse(null);
                if (emeraldMaterial != null && eyePattern != null) {
                    class_8053 trim = new class_8053(emeraldMaterial, eyePattern);
                    chestplate.method_57379(class_9334.field_49607, (Object)trim);
                }
            }
            catch (Exception emeraldMaterial) {
                // empty catch block
            }
            bogged.method_5673(class_1304.field_6174, chestplate);
            class_1799 helmet = new class_1799((class_1935)class_1802.field_8805);
            try {
                class_6880 emeraldMaterial = this.method_37908().method_30349().method_30530(class_7924.field_42083).method_55841(class_2960.method_60655((String)"minecraft", (String)"emerald")).orElse(null);
                class_6880 ribPattern = this.method_37908().method_30349().method_30530(class_7924.field_42082).method_55841(class_2960.method_60655((String)"minecraft", (String)"rib")).orElse(null);
                if (emeraldMaterial != null && ribPattern != null) {
                    class_8053 helmetTrim = new class_8053(emeraldMaterial, ribPattern);
                    helmet.method_57379(class_9334.field_49607, (Object)helmetTrim);
                }
            }
            catch (Exception emeraldMaterial) {
                // empty catch block
            }
            bogged.method_5673(class_1304.field_6169, helmet);
            class_1799 bow = new class_1799((class_1935)class_1802.field_8102);
            bogged.method_5673(class_1304.field_6173, bow);
            this.method_37908().method_8649((class_1297)bogged);
            ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_50247, x, this.method_23318() + 1.0, z, 25, 0.5, 1.0, 0.5, 0.1);
        }
        class_238 messageRange = this.method_5829().method_1014(20.0);
        this.method_37908().method_18467(class_1657.class, messageRange).forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)"\u00a72\u00a7l\u2698 \u00a7a\u00a7lHavenica \u00a7r\u00a72summons \u00a76\u00a7lBogged Guardians\u00a7r\u00a72! \u00a72\u2698"), true));
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_49142, this.method_5634(), 1.0f, 0.8f);
        this.boggedSummonCooldown = 570;
    }

    private void useToxicLaser(class_1657 target) {
        if (!this.hasLineOfSight(target)) {
            return;
        }
        this.toxicLaserCharging = true;
        this.toxicLaserChargeTicks = 0;
        this.toxicLaserTarget = target;
        class_243 playerPos = new class_243(target.method_23317(), target.method_23318() + 1.0, target.method_23321());
        class_243 directionToPlayer = playerPos.method_1023(this.method_23317(), this.method_23318() + 1.5, this.method_23321()).method_1029();
        class_243 extendedTarget = playerPos.method_1019(directionToPlayer.method_1021(12.0));
        class_243 perpendicular = new class_243(-directionToPlayer.field_1350, 0.0, directionToPlayer.field_1352).method_1029();
        this.lockedLaserTargets[0] = extendedTarget;
        this.lockedLaserTargets[1] = extendedTarget.method_1019(perpendicular.method_1021(1.2));
        this.lockedLaserTargets[2] = extendedTarget.method_1020(perpendicular.method_1021(1.2));
        class_238 messageRange = this.method_5829().method_1014(20.0);
        this.method_37908().method_18467(class_1657.class, messageRange).forEach(player -> player.method_7353((class_2561)class_2561.method_43471((String)"entity.mystbornhorizons.havenica.toxic_laser_charging"), true));
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14891, this.method_5634(), 1.0f, 0.5f);
    }

    private boolean hasLineOfSight(class_1657 target) {
        class_243 start = new class_243(this.method_23317(), this.method_23318() + 1.5, this.method_23321());
        class_243 end = new class_243(target.method_23317(), target.method_23318() + 1.0, target.method_23321());
        return this.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    private boolean hasValidLaserTargets() {
        return this.lockedLaserTargets[0] != null && this.lockedLaserTargets[1] != null && this.lockedLaserTargets[2] != null;
    }

    private void clearLaserTargets() {
        this.lockedLaserTargets[0] = null;
        this.lockedLaserTargets[1] = null;
        this.lockedLaserTargets[2] = null;
    }

    private void createTripleLaserChargingEffect() {
        if (!this.hasValidLaserTargets() || this.method_37908().method_8608()) {
            return;
        }
        class_243 start = new class_243(this.method_23317(), this.method_23318() + 1.5, this.method_23321());
        double intensity = (double)this.toxicLaserChargeTicks / 60.0;
        int particleCount = (int)(3.0 + intensity * 7.0);
        for (int laserIndex = 0; laserIndex < 3; ++laserIndex) {
            class_243 end = this.lockedLaserTargets[laserIndex];
            class_243 direction = end.method_1020(start);
            double distance = direction.method_1033();
            direction = direction.method_1029();
            for (double d = 0.0; d < distance; d += 0.4) {
                class_243 particlePos = start.method_1019(direction.method_1021(d));
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_17741, particlePos.field_1352, particlePos.field_1351 + 0.1, particlePos.field_1350, 2, 0.1, 0.1, 0.1, 0.0);
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_29644, particlePos.field_1352, particlePos.field_1351 + 0.5, particlePos.field_1350, 1, 0.05, 0.05, 0.05, 0.0);
            }
            for (double angle = 0.0; angle < Math.PI * 2; angle += 0.39269908169872414) {
                double radius = 2.0 - intensity * 0.5;
                double x = end.field_1352 + Math.cos(angle) * radius;
                double z = end.field_1350 + Math.sin(angle) * radius;
                ((class_3218)this.method_37908()).method_14199((class_2394)(intensity > 0.7 ? class_2398.field_11240 : class_2398.field_11251), x, end.field_1351 + 0.1, z, 1, 0.1, 0.1, 0.1, 0.0);
            }
        }
        if (this.toxicLaserChargeTicks % 10 == 0) {
            float pitch = 0.5f + (float)intensity * 1.0f;
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_21912, this.method_5634(), 0.3f, pitch);
        }
    }

    private void fireTripleToxicLaser() {
        if (!this.hasValidLaserTargets() || this.method_37908().method_8608()) {
            return;
        }
        class_243 start = new class_243(this.method_23317(), this.method_23318() + 1.5, this.method_23321());
        for (int laserIndex = 0; laserIndex < 3; ++laserIndex) {
            class_243 end = this.lockedLaserTargets[laserIndex];
            class_243 direction = end.method_1020(start);
            double distance = direction.method_1033();
            direction = direction.method_1029();
            for (double d = 0.0; d < distance; d += 0.2) {
                class_243 particlePos = start.method_1019(direction.method_1021(d));
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11236, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 3, 0.2, 0.2, 0.2, 0.1);
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_28478, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 5, 0.3, 0.3, 0.3, 0.1);
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_17741, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 3, 0.2, 0.2, 0.2, 0.05);
                class_238 damageBox = new class_238(particlePos.field_1352 - 0.75, particlePos.field_1351 - 0.5, particlePos.field_1350 - 0.75, particlePos.field_1352 + 0.75, particlePos.field_1351 + 1.5, particlePos.field_1350 + 0.75);
                List playersInRange = this.method_37908().method_18467(class_1657.class, damageBox);
                for (class_1657 player2 : playersInRange) {
                    if (player2.method_6059(class_1294.field_5899) && player2.method_6112(class_1294.field_5899).method_5584() >= 40) continue;
                    player2.method_6092(new class_1293(class_1294.field_5899, 160, 1));
                    player2.method_6092(new class_1293(class_1294.field_5916, 160, 2));
                    player2.method_5643(this.method_48923().method_48831(), 8.0f);
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11209, player2.method_23317(), player2.method_23318() + 1.0, player2.method_23321(), 8, 0.5, 0.5, 0.5, 0.1);
                    for (double angle = 0.0; angle < Math.PI * 2; angle += 0.5235987755982988) {
                        double radius = 1.5;
                        double x = player2.method_23317() + Math.cos(angle) * radius;
                        double z = player2.method_23321() + Math.sin(angle) * radius;
                        ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11240, x, player2.method_23318() + 1.0, z, 2, 0.1, 0.2, 0.1, 0.05);
                    }
                }
            }
        }
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14865, this.method_5634(), 1.0f, 1.5f);
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14803, this.method_5634(), 1.0f, 1.5f);
        class_238 messageRange = this.method_5829().method_1014(20.0);
        this.method_37908().method_18467(class_1657.class, messageRange).forEach(player -> player.method_7353((class_2561)class_2561.method_43471((String)"entity.mystbornhorizons.havenica.toxic_laser_fire"), true));
        this.toxicLaserCooldown = 95;
        this.clearLaserTargets();
        if (this.field_5974.method_43057() < 0.3f && this.teleportCooldown <= 0) {
            this.teleportDelayTicks = 40;
            class_238 teleportMessageRange = this.method_5829().method_1014(20.0);
            this.method_37908().method_18467(class_1657.class, teleportMessageRange).forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)"Havenica prepares to teleport..."), true));
        }
    }

    private void damagePlayersInLines() {
        if (this.method_37908().method_8608()) {
            return;
        }
        for (int i = 0; i < this.rootPillars.size(); ++i) {
            class_243 start = this.rootPillars.get(i);
            class_243 end = this.rootPillars.get((i + 1) % this.rootPillars.size());
            class_243 direction = end.method_1020(start);
            double distance = direction.method_1033();
            direction = direction.method_1029();
            for (double d = 0.0; d < distance; d += 0.5) {
                class_243 checkPos = start.method_1019(direction.method_1021(d));
                class_238 damageBox = new class_238(checkPos.field_1352 - 1.0, checkPos.field_1351 - 0.5, checkPos.field_1350 - 1.0, checkPos.field_1352 + 1.0, checkPos.field_1351 + 2.5, checkPos.field_1350 + 1.0);
                this.method_37908().method_18467(class_1657.class, damageBox).forEach(player -> {
                    if (!player.method_6059(class_1294.field_5909) || player.method_6112(class_1294.field_5909).method_5584() < 20) {
                        player.method_6092(new class_1293(class_1294.field_5909, 60, 2));
                        player.method_6092(new class_1293(class_1294.field_5920, 80, 1));
                        player.method_5643(this.method_48923().method_48831(), 6.0f);
                        player.method_31548().field_7548.forEach(itemStack -> {
                            if (!itemStack.method_7960() && itemStack.method_7963()) {
                                int currentDamage = itemStack.method_7919();
                                int maxDamage = itemStack.method_7936();
                                int newDamage = Math.min(maxDamage - 1, currentDamage + 15);
                                itemStack.method_7974(newDamage);
                            }
                        });
                        if (!player.method_6047().method_7960() && player.method_6047().method_7963()) {
                            player.method_6047().method_7974(player.method_6047().method_7919() + 5);
                        }
                        for (int p = 0; p < 8; ++p) {
                            double angle = (double)p / 8.0 * Math.PI * 2.0;
                            double radius = 1.2;
                            double x = player.method_23317() + Math.cos(angle) * radius;
                            double z = player.method_23321() + Math.sin(angle) * radius;
                            ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11205, x, player.method_23318() + 1.0, z, 2, 0.1, 0.1, 0.1, 0.05);
                        }
                    }
                });
            }
        }
    }

    private void useShockwaveBlast() {
        this.shockwaveActive = true;
        this.shockwaveTimer = 0;
        this.waveDistances.clear();
        this.waveDelays.clear();
        this.waveDistances.add(0.0);
        this.waveDistances.add(0.0);
        this.waveDistances.add(0.0);
        this.waveDelays.add(0);
        this.waveDelays.add(20);
        this.waveDelays.add(40);
        class_238 messageRange = this.method_5829().method_1014(20.0);
        this.method_37908().method_18467(class_1657.class, messageRange).forEach(player -> player.method_7353((class_2561)class_2561.method_43471((String)"entity.mystbornhorizons.havenica.shockwave_blast"), true));
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_38830, this.method_5634(), 1.0f, 0.8f);
        this.shockwaveCooldown = 500;
    }

    private void tickShockwaveBlast() {
        if (!this.shockwaveActive || this.method_37908().method_8608()) {
            return;
        }
        ++this.shockwaveTimer;
        for (int i = 0; i < this.waveDistances.size(); ++i) {
            double currentDistance;
            if (this.shockwaveTimer < this.waveDelays.get(i) || !((currentDistance = this.waveDistances.get(i).doubleValue()) < 15.0)) continue;
            this.createShockwaveRing(currentDistance);
            this.damagePlayersInWave(currentDistance);
            this.waveDistances.set(i, currentDistance + 1.4);
        }
        boolean allWavesFinished = true;
        for (double distance : this.waveDistances) {
            if (!(distance < 15.0)) continue;
            allWavesFinished = false;
            break;
        }
        if (allWavesFinished) {
            this.shockwaveActive = false;
            this.shockwaveTimer = 0;
            this.waveDistances.clear();
            this.waveDelays.clear();
        }
    }

    private void createShockwaveRing(double radius) {
        if (radius <= 0.0) {
            return;
        }
        double circumference = Math.PI * 2 * radius;
        int particleCount = Math.max(8, (int)(circumference / 0.5));
        for (int i = 0; i < particleCount; ++i) {
            double angle = (double)i / (double)particleCount * Math.PI * 2.0;
            double x = this.method_23317() + Math.cos(angle) * radius;
            double z = this.method_23321() + Math.sin(angle) * radius;
            ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11241, x, this.method_23318() + 0.1, z, 3, 0.1, 0.1, 0.1, 0.0);
            ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11205, x, this.method_23318() + 0.3, z, 1, 0.05, 0.05, 0.05, 0.0);
        }
        if (radius % 3.0 < 1.4) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15026, this.method_5634(), 0.6f, 0.9f);
        }
    }

    private void damagePlayersInWave(double waveRadius) {
        double waveThickness = 0.8;
        class_238 searchBox = new class_238(this.method_23317() - waveRadius - waveThickness, this.method_23318() - 0.5, this.method_23321() - waveRadius - waveThickness, this.method_23317() + waveRadius + waveThickness, this.method_23318() + 1.5, this.method_23321() + waveRadius + waveThickness);
        this.method_37908().method_18467(class_1657.class, searchBox).forEach(player -> {
            double distanceToPlayer = Math.sqrt(Math.pow(player.method_23317() - this.method_23317(), 2.0) + Math.pow(player.method_23321() - this.method_23321(), 2.0));
            if (Math.abs(distanceToPlayer - waveRadius) <= waveThickness && player.method_23318() <= this.method_23318() + 1.2) {
                player.method_6092(new class_1293(class_1294.field_5909, 60, 1));
                player.method_5643(this.method_48923().method_48831(), 6.0f);
                class_243 knockbackDir = new class_243(player.method_23317() - this.method_23317(), 0.3, player.method_23321() - this.method_23321()).method_1029().method_1021(1.2);
                player.method_18799(player.method_18798().method_1019(knockbackDir));
                for (int p = 0; p < 8; ++p) {
                    double angle = (double)p / 8.0 * Math.PI * 2.0;
                    double particleRadius = 1.0;
                    double x = player.method_23317() + Math.cos(angle) * particleRadius;
                    double z = player.method_23321() + Math.sin(angle) * particleRadius;
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11209, x, player.method_23318() + 1.0, z, 1, 0.1, 0.1, 0.1, 0.05);
                }
            }
        });
    }

    private void activateGardensWrath() {
        if (this.method_37908().method_8608()) {
            return;
        }
        System.out.println("DEBUG: Gardens Wrath activated!");
        class_238 freezeArea = this.method_5829().method_1014(25.0);
        this.method_37908().method_18467(class_1657.class, freezeArea).forEach(player -> {
            player.method_6092(new class_1293(class_1294.field_5909, 60, 4, true, false));
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7l\u26a0 \u00a74\u00a7lHAVENICA'S RAGE AWAKENS \u00a7c\u00a7l\u26a0"), true);
        });
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14671, this.method_5634(), 2.0f, 0.5f);
        this.cutsceneActive = true;
        this.cutsceneTick = 0;
        System.out.println("DEBUG: Cutscene started! cutsceneActive=" + this.cutsceneActive);
        this.isGardensWrathActive = true;
    }

    public boolean method_6049(class_1293 effect) {
        return !effect.method_5579().equals((Object)class_1294.field_5899) && super.method_6049(effect);
    }

    private void tryTeleportToHavenCore() {
        if (this.method_37908().method_8608()) {
            return;
        }
        ArrayList<class_243> validHavenCorePositions = new ArrayList<class_243>();
        class_238 searchArea = new class_238(this.method_23317() - 30.0, this.method_23318() - 15.0, this.method_23321() - 30.0, this.method_23317() + 30.0, this.method_23318() + 15.0, this.method_23321() + 30.0);
        List nearbyEntities = this.method_37908().method_8335((class_1297)this, searchArea);
        for (class_1297 entity : nearbyEntities) {
            if (!entity.getClass().getSimpleName().contains("HavenCore") && !entity.method_5864().toString().contains("haven_core")) continue;
            class_243 corePos = entity.method_19538();
            double x = corePos.field_1352;
            double z = corePos.field_1350;
            double y = corePos.field_1351 + 0.5;
            validHavenCorePositions.add(new class_243(x, y, z));
        }
        if (!validHavenCorePositions.isEmpty()) {
            class_243 teleportPos = (class_243)validHavenCorePositions.get(this.field_5974.method_43048(validHavenCorePositions.size()));
            ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11214, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 20, 0.5, 1.0, 0.5, 0.1);
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14879, this.method_5634(), 1.0f, 1.0f);
            this.method_5808(teleportPos.field_1352, teleportPos.field_1351, teleportPos.field_1350, this.method_36454(), this.method_36455());
            ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11214, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 20, 0.5, 1.0, 0.5, 0.1);
            ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11207, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 15, 1.0, 1.0, 1.0, 0.2);
            class_238 messageRange = this.method_5829().method_1014(20.0);
            this.method_37908().method_18467(class_1657.class, messageRange).forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)"\u00a75\u00a7lHavenica teleports to a nearby Haven Core!"), true));
            this.teleportCooldown = 240;
        } else {
            class_238 messageRange = this.method_5829().method_1014(20.0);
            this.method_37908().method_18467(class_1657.class, messageRange).forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76Havenica searches for a Haven Core to teleport to..."), true));
        }
    }

    private void useRootNetwork(class_1657 target) {
        this.rootNetworkActive = true;
        this.rootNetworkTimer = 0;
        this.rootPillars.clear();
        double centerX = target.method_23317();
        double centerZ = target.method_23321();
        this.rootPillars.add(new class_243(centerX, target.method_23318(), centerZ));
        int pillarCount = this.isGardensWrathActive ? 8 : 6;
        for (int i = 0; i < pillarCount; ++i) {
            double angle = (double)i / (double)pillarCount * Math.PI * 2.0;
            double radius = 8.0 + this.field_5974.method_43058() * 4.0;
            double x = centerX + Math.cos(angle) * radius;
            double z = centerZ + Math.sin(angle) * radius;
            this.rootPillars.add(new class_243(x, target.method_23318(), z));
        }
        class_238 messageRange = this.method_5829().method_1014(20.0);
        this.method_37908().method_18467(class_1657.class, messageRange).forEach(player -> player.method_7353((class_2561)class_2561.method_43471((String)"entity.mystbornhorizons.havenica.root_network"), true));
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_28601, this.method_5634(), 1.0f, 0.7f);
    }

    private void spawnRootPillarParticles() {
        if (this.method_37908().method_8608()) {
            return;
        }
        for (class_243 pillar : this.rootPillars) {
            for (double y = 0.0; y < 5.0; y += 0.3) {
                double radius = 0.8;
                int particlesPerRing = 8;
                for (int p = 0; p < particlesPerRing; ++p) {
                    double angle = (double)p / (double)particlesPerRing * Math.PI * 2.0;
                    double x = pillar.field_1352 + Math.cos(angle) * radius;
                    double z = pillar.field_1350 + Math.sin(angle) * radius;
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_50246, x, pillar.field_1351 + y, z, 1, 0.1, 0.1, 0.1, 0.0);
                    if (!(y > 3.0)) continue;
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11207, x, pillar.field_1351 + y, z, 1, 0.05, 0.05, 0.05, 0.0);
                }
            }
        }
        if (this.rootNetworkTimer == 50) {
            this.method_37908().method_8396(null, this.method_24515(), class_3417.field_28604, this.method_5634(), 1.0f, 1.0f);
        }
    }

    private void spawnRootLineParticles() {
        if (this.method_37908().method_8608()) {
            return;
        }
        for (int i = 0; i < this.rootPillars.size(); ++i) {
            class_243 start = this.rootPillars.get(i);
            class_243 end = this.rootPillars.get((i + 1) % this.rootPillars.size());
            class_243 direction = end.method_1020(start);
            double distance = direction.method_1033();
            direction = direction.method_1029();
            for (double d = 0.0; d < distance; d += 0.3) {
                class_243 particlePos = start.method_1019(direction.method_1021(d));
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11205, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 2, 0.1, 0.1, 0.1, 0.0);
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_29645, particlePos.field_1352, particlePos.field_1351 + 0.5, particlePos.field_1350, 1, 0.05, 0.05, 0.05, 0.0);
            }
        }
    }

    @Nullable
    protected class_3414 method_5994() {
        return null;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_33433;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_14739;
    }
}

