/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.item.custom;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3449;
import net.minecraft.class_3468;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;

public class ForestHeartItem
extends class_1792 {
    public ForestHeartItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.mystbornhorizons.forest_heart.tooltip1").method_27692(class_124.field_1060));
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.mystbornhorizons.forest_heart.tooltip2").method_27692(class_124.field_1077));
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.mystbornhorizons.forest_heart.tooltip3").method_27692(class_124.field_1061));
        super.method_7851(stack, context, tooltip, type);
    }

    public boolean method_7886(class_1799 stack) {
        return true;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (!world.field_9236) {
            class_3218 serverWorld = (class_3218)world;
            class_2338 mossArenaPos = this.findNearestMossArena(serverWorld, user.method_24515());
            if (mossArenaPos != null) {
                this.createParticleTrail(serverWorld, user.method_19538(), mossArenaPos);
                world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_15119, class_3419.field_15248, 1.0f, 1.2f + world.method_8409().method_43057() * 0.4f);
                user.method_7259(class_3468.field_15372.method_14956((Object)this));
                class_243 direction = class_243.method_24954((class_2382)mossArenaPos).method_1020(user.method_19538()).method_1029();
                String directionText = this.getDirectionText(direction);
                int distance = (int)Math.sqrt(user.method_24515().method_10262((class_2382)mossArenaPos));
                user.method_7353((class_2561)class_2561.method_43469((String)"item.mystbornhorizons.forest_heart.direction", (Object[])new Object[]{directionText, distance}).method_27692(class_124.field_1060), true);
                return class_1271.method_22427((Object)itemStack);
            }
            user.method_7353((class_2561)class_2561.method_43471((String)"item.mystbornhorizons.forest_heart.no_structure").method_27692(class_124.field_1061), true);
            return class_1271.method_22431((Object)itemStack);
        }
        return class_1271.method_22427((Object)itemStack);
    }

    private class_2338 findNearestMossArena(class_3218 world, class_2338 playerPos) {
        System.out.println("[ForestHeart] Starting structure search from position: " + String.valueOf(playerPos));
        class_2960 mossId = class_2960.method_60655((String)"minecraft", (String)"moss_arena");
        System.out.println("[ForestHeart] Looking for structure: " + String.valueOf(mossId));
        try {
            class_2378 structureRegistry = world.method_30349().method_30530(class_7924.field_41246);
            System.out.println("[ForestHeart] Structure registry size: " + structureRegistry.method_10204());
            Optional structureEntry = structureRegistry.method_55841(mossId);
            if (structureEntry.isPresent()) {
                System.out.println("[ForestHeart] Found structure entry in registry");
                Optional entryList = structureRegistry.method_40266(class_6862.method_40092((class_5321)class_7924.field_41246, (class_2960)mossId));
                if (entryList.isEmpty()) {
                    System.out.println("[ForestHeart] No entry list found, trying individual entry...");
                    class_6885.class_6886 singleEntryList = class_6885.method_40246((class_6880[])new class_6880[]{(class_6880)structureEntry.get()});
                    Pair result = world.method_14178().method_12129().method_12103(world, (class_6885)singleEntryList, playerPos, 100, false);
                    if (result != null) {
                        class_2338 structurePos = (class_2338)result.getFirst();
                        double distance = Math.sqrt(playerPos.method_10262((class_2382)structurePos));
                        System.out.println("[ForestHeart] \u2713 Found via single entry method: " + String.valueOf(structurePos) + " (distance: " + (int)distance + " blocks)");
                        return structurePos;
                    }
                } else {
                    System.out.println("[ForestHeart] Using entry list...");
                    Pair result = world.method_14178().method_12129().method_12103(world, (class_6885)entryList.get(), playerPos, 100, false);
                    if (result != null) {
                        class_2338 structurePos = (class_2338)result.getFirst();
                        double distance = Math.sqrt(playerPos.method_10262((class_2382)structurePos));
                        System.out.println("[ForestHeart] \u2713 Found via entry list: " + String.valueOf(structurePos) + " (distance: " + (int)distance + " blocks)");
                        return structurePos;
                    }
                }
            } else {
                System.out.println("[ForestHeart] Structure entry not found in registry!");
            }
        }
        catch (Exception e) {
            System.out.println("[ForestHeart] Error in ChunkGenerator approach: " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("[ForestHeart] Trying structure sets approach...");
        try {
            class_2378 structureSetRegistry = world.method_30349().method_30530(class_7924.field_41248);
            System.out.println("[ForestHeart] Available structure sets:");
            for (Map.Entry entry : structureSetRegistry.method_29722()) {
                String setName = ((class_5321)entry.getKey()).method_29177().toString();
                System.out.println("  - " + (String)setName);
                if (!setName.contains("moss") && !setName.contains("arena")) continue;
                System.out.println("[ForestHeart] Found potential structure set: " + (String)setName);
            }
        }
        catch (Exception e) {
            System.out.println("[ForestHeart] Error checking structure sets: " + e.getMessage());
        }
        System.out.println("[ForestHeart] Trying command-style locate...");
        try {
            class_2378 registry = world.method_30349().method_30530(class_7924.field_41246);
            Optional holder = registry.method_55841(mossId);
            if (holder.isPresent()) {
                System.out.println("[ForestHeart] Structure holder found, attempting locate...");
                int[] radii = new int[]{50, 100, 200, 500};
                for (Object radius : (String)radii) {
                    System.out.println("[ForestHeart] Searching with radius: " + (int)radius + " chunks");
                    Pair pair = world.method_14178().method_12129().method_12103(world, (class_6885)class_6885.method_40246((class_6880[])new class_6880[]{(class_6880)holder.get()}), playerPos, (int)radius, false);
                    if (pair == null) continue;
                    class_2338 foundPos = (class_2338)pair.getFirst();
                    double distance = Math.sqrt(playerPos.method_10262((class_2382)foundPos));
                    System.out.println("[ForestHeart] \u2713 Found with command-style locate: " + String.valueOf(foundPos) + " (distance: " + (int)distance + " blocks)");
                    return foundPos;
                }
            }
        }
        catch (Exception e) {
            System.out.println("[ForestHeart] Error in command-style locate: " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("[ForestHeart] Falling back to manual chunk scanning...");
        try {
            int chunkRadius = 100;
            int checked = 0;
            for (int x = -chunkRadius; x <= chunkRadius; x += 2) {
                for (int z = -chunkRadius; z <= chunkRadius; z += 2) {
                    if (++checked % 1000 == 0) {
                        System.out.println("[ForestHeart] Checked " + checked + " chunks...");
                    }
                    int chunkX = (playerPos.method_10263() >> 4) + x;
                    int chunkZ = (playerPos.method_10260() >> 4) + z;
                    class_2818 chunk = world.method_8497(chunkX, chunkZ);
                    Map structureStarts = chunk.method_12016();
                    for (Map.Entry entry : structureStarts.entrySet()) {
                        class_3195 structureKey = (class_3195)entry.getKey();
                        class_3449 start = (class_3449)entry.getValue();
                        class_2378 structureRegistry = world.method_30349().method_30530(class_7924.field_41246);
                        class_2960 structureId = structureRegistry.method_10221((Object)structureKey);
                        if (structureId == null || !structureId.toString().equals("minecraft:moss_arena") || !start.method_16657()) continue;
                        class_2338 structurePos = new class_2338(chunkX * 16 + 8, 64, chunkZ * 16 + 8);
                        System.out.println("[ForestHeart] \u2713 Found via manual scanning: " + String.valueOf(structurePos));
                        return structurePos;
                    }
                }
            }
            System.out.println("[ForestHeart] Manual scan completed, checked " + checked + " chunks");
        }
        catch (Exception e) {
            System.out.println("[ForestHeart] Error in manual scanning: " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("[ForestHeart] All methods exhausted. Structure may be further than 100 chunks away.");
        return null;
    }

    private void createParticleTrail(class_3218 world, class_243 playerPos, class_2338 targetPos) {
        int i;
        class_243 target = class_243.method_24954((class_2382)targetPos);
        class_243 direction = target.method_1020(playerPos).method_1029();
        double maxDistance = Math.min(30.0, playerPos.method_1022(target) * 0.3);
        int particleCount = 20;
        for (i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)(particleCount - 1);
            double distance = progress * maxDistance;
            class_243 particlePos = playerPos.method_1019(direction.method_1021(distance));
            particlePos = particlePos.method_1031(0.0, 1.0 + progress * 2.0, 0.0);
            double randomX = (world.method_8409().method_43058() - 0.5) * 0.3;
            double randomY = (world.method_8409().method_43058() - 0.5) * 0.3;
            double randomZ = (world.method_8409().method_43058() - 0.5) * 0.3;
            particlePos = particlePos.method_1031(randomX, randomY, randomZ);
            if (i % 2 == 0) {
                world.method_14199((class_2394)class_2398.field_11211, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 3, 0.1, 0.1, 0.1, 0.02);
                continue;
            }
            world.method_14199((class_2394)class_2398.field_17741, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 2, 0.1, 0.1, 0.1, 0.0);
        }
        for (i = 0; i < 15; ++i) {
            double angle = Math.PI * 2 * (double)i / 15.0;
            double radius = 2.0;
            double x = playerPos.field_1352 + Math.cos(angle) * radius;
            double z = playerPos.field_1350 + Math.sin(angle) * radius;
            double y = playerPos.field_1351 + 1.5;
            world.method_14199((class_2394)class_2398.field_11211, x, y, z, 2, 0.0, 0.3, 0.0, 0.1);
        }
        for (i = 0; i < 8; ++i) {
            double randomX = playerPos.field_1352 + (world.method_8409().method_43058() - 0.5) * 4.0;
            double randomZ = playerPos.field_1350 + (world.method_8409().method_43058() - 0.5) * 4.0;
            world.method_14199((class_2394)class_2398.field_28803, randomX, playerPos.field_1351 + 2.0, randomZ, 1, 0.0, 0.1, 0.0, 0.05);
        }
    }

    private String getDirectionText(class_243 direction) {
        double z = direction.field_1350;
        double x = direction.field_1352;
        double angle = Math.atan2(z, x) * 180.0 / Math.PI;
        if (angle < 0.0) {
            angle += 360.0;
        }
        if (angle >= 337.5 || angle < 22.5) {
            return "East";
        }
        if (angle >= 22.5 && angle < 67.5) {
            return "Southeast";
        }
        if (angle >= 67.5 && angle < 112.5) {
            return "South";
        }
        if (angle >= 112.5 && angle < 157.5) {
            return "Southwest";
        }
        if (angle >= 157.5 && angle < 202.5) {
            return "West";
        }
        if (angle >= 202.5 && angle < 247.5) {
            return "Northwest";
        }
        if (angle >= 247.5 && angle < 292.5) {
            return "North";
        }
        return "Northeast";
    }
}

