/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class CutsceneManager {
    private static final Map<String, CutsceneData> activeCutscenes = new HashMap<String, CutsceneData>();

    public static void initialize() {
        ServerTickEvents.END_SERVER_TICK.register(CutsceneManager::onServerTick);
        System.out.println("DEBUG: CutsceneManager initialized");
    }

    public static void startCutscene(class_3218 world, class_2338 pos, CutsceneTickHandler handler) {
        String key = CutsceneManager.generateKey(world, pos);
        activeCutscenes.put(key, new CutsceneData(world, pos, handler, 0));
        System.out.println("DEBUG: Started cutscene with key: " + key);
    }

    public static void stopCutscene(class_3218 world, class_2338 pos) {
        String key = CutsceneManager.generateKey(world, pos);
        boolean removed = activeCutscenes.remove(key) != null;
        System.out.println("DEBUG: Stopped cutscene with key: " + key + ", existed: " + removed);
    }

    public static boolean isCutsceneActive(class_3218 world, class_2338 pos) {
        String key = CutsceneManager.generateKey(world, pos);
        boolean active = activeCutscenes.containsKey(key);
        System.out.println("DEBUG: Checking cutscene active for key: " + key + ", result: " + active);
        return active;
    }

    private static String generateKey(class_3218 world, class_2338 pos) {
        return world.method_27983().method_29177().toString() + "_" + pos.method_23854();
    }

    private static void onServerTick(MinecraftServer server) {
        if (activeCutscenes.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, CutsceneData>> iterator = activeCutscenes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CutsceneData> entry = iterator.next();
            CutsceneData data = entry.getValue();
            if (data.world.method_8503() != server) {
                System.out.println("DEBUG: Removing cutscene due to server mismatch: " + entry.getKey());
                iterator.remove();
                continue;
            }
            ++data.tick;
            try {
                boolean shouldContinue = data.handler.tick(data.world, data.pos, data.tick);
                if (shouldContinue) continue;
                System.out.println("DEBUG: Cutscene completed naturally: " + entry.getKey());
                iterator.remove();
            }
            catch (Exception e) {
                System.out.println("ERROR: Exception in cutscene tick for " + entry.getKey() + ": " + e.getMessage());
                e.printStackTrace();
                iterator.remove();
            }
        }
    }

    public static void debugPrintActiveCutscenes() {
        System.out.println("DEBUG: Active cutscenes (" + activeCutscenes.size() + "):");
        for (Map.Entry<String, CutsceneData> entry : activeCutscenes.entrySet()) {
            CutsceneData data = entry.getValue();
            System.out.println("  " + entry.getKey() + " - Tick: " + data.tick);
        }
    }

    private static class CutsceneData {
        final class_3218 world;
        final class_2338 pos;
        final CutsceneTickHandler handler;
        int tick;

        CutsceneData(class_3218 world, class_2338 pos, CutsceneTickHandler handler, int tick) {
            this.world = world;
            this.pos = pos;
            this.handler = handler;
            this.tick = tick;
        }
    }

    @FunctionalInterface
    public static interface CutsceneTickHandler {
        public boolean tick(class_3218 var1, class_2338 var2, int var3);
    }
}

