/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.block.custom;

import cassetu.mystbornhorizons.entity.ModEntities;
import cassetu.mystbornhorizons.entity.custom.HavenCoreEntity;
import cassetu.mystbornhorizons.entity.custom.HavenicaEntity;
import cassetu.mystbornhorizons.item.ModItems;
import cassetu.mystbornhorizons.util.CutsceneManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class AncientGroveAltarBlock
extends class_2248 {
    public AncientGroveAltarBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236) {
            class_3218 serverWorld = (class_3218)world;
            class_1799 heldItem = player.method_6047();
            if (!heldItem.method_31574(ModItems.FOREST_HEART)) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c This altar requires a \u00a72Forest Heart\u00a7c to activate..."), false);
                return class_1269.field_5814;
            }
            class_238 searchBox = new class_238(pos).method_1014(50.0);
            if (!serverWorld.method_8390(HavenicaEntity.class, searchBox, e -> true).isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cHavenica's presence is already felt in this area..."), false);
                return class_1269.field_5814;
            }
            if (CutsceneManager.isCutsceneActive(serverWorld, pos)) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76The ritual is already in progress..."), false);
                return class_1269.field_5814;
            }
            if (!player.method_31549().field_7477) {
                heldItem.method_7934(1);
            }
            this.startSpawningCutscene(serverWorld, pos);
        }
        return class_1269.field_5812;
    }

    private void startSpawningCutscene(class_3218 world, class_2338 pos) {
        System.out.println("DEBUG: Starting spawning cutscene at " + String.valueOf(pos));
        HashSet<class_3222> cutscenePlayers = new HashSet<class_3222>();
        HashMap<class_3222, class_1934> originalGameModes = new HashMap<class_3222, class_1934>();
        HashMap<class_3222, class_243> originalPositions = new HashMap<class_3222, class_243>();
        HashMap<class_3222, class_243> cutscenePositions = new HashMap<class_3222, class_243>();
        HashMap<class_3222, Boolean> originalFlying = new HashMap<class_3222, Boolean>();
        HashMap<class_3222, Float> originalYaw = new HashMap<class_3222, Float>();
        HashMap<class_3222, Float> originalPitch = new HashMap<class_3222, Float>();
        class_238 cutsceneArea = new class_238(pos).method_1014(25.0);
        List nearbyPlayers = world.method_18467(class_1657.class, cutsceneArea).stream().filter(player -> player instanceof class_3222).map(player -> (class_3222)player).filter(Objects::nonNull).collect(Collectors.toList());
        for (class_3222 player2 : nearbyPlayers) {
            try {
                cutscenePlayers.add(player2);
                originalGameModes.put(player2, player2.field_13974.method_14257());
                originalPositions.put(player2, player2.method_19538());
                originalFlying.put(player2, player2.method_31549().field_7479);
                originalYaw.put(player2, Float.valueOf(player2.method_36454()));
                originalPitch.put(player2, Float.valueOf(player2.method_36455()));
                player2.method_7336(class_1934.field_9219);
                double cameraX = (double)pos.method_10263() + 0.5;
                double cameraY = (double)pos.method_10264() + 8.0;
                double cameraZ = (double)pos.method_10260() + 12.0;
                class_243 cutscenePos = new class_243(cameraX, cameraY, cameraZ);
                cutscenePositions.put(player2, cutscenePos);
                class_243 lookTarget = new class_243((double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 2), (double)pos.method_10260() + 0.5);
                class_243 lookDirection = lookTarget.method_1020(cutscenePos).method_1029();
                float targetYaw = (float)Math.toDegrees(Math.atan2(-lookDirection.field_1352, lookDirection.field_1350));
                float targetPitch = (float)Math.toDegrees(Math.asin(-lookDirection.field_1351));
                player2.method_14251(world, cameraX, cameraY, cameraZ, targetYaw, targetPitch);
                player2.method_31549().field_7479 = false;
                player2.method_31549().field_7478 = false;
                player2.method_7355();
                player2.method_7353((class_2561)class_2561.method_43470((String)"\u00a72\u00a7l\u26a1 \u00a7a\u00a7lTHE FOREST AWAKENS \u00a72\u00a7l\u26a1").method_27692(class_124.field_1060), false);
                player2.method_7353((class_2561)class_2561.method_43470((String)"\u00a76Witness the birth of an ancient guardian...").method_27692(class_124.field_1065), false);
            }
            catch (Exception e) {
                System.out.println("ERROR: Failed to setup cutscene for player " + player2.method_5477().getString());
                e.printStackTrace();
            }
        }
        CutsceneManager.startCutscene(world, pos, (serverWorld, altarPos, tick) -> this.tickSpawningCutscene(serverWorld, altarPos, tick, cutscenePlayers, originalGameModes, originalPositions, cutscenePositions, originalFlying, originalYaw, originalPitch));
    }

    private boolean tickSpawningCutscene(class_3218 serverWorld, class_2338 altarPos, int cutsceneTick, Set<class_3222> cutscenePlayers, Map<class_3222, class_1934> originalGameModes, Map<class_3222, class_243> originalPositions, Map<class_3222, class_243> cutscenePositions, Map<class_3222, Boolean> originalFlying, Map<class_3222, Float> originalYaw, Map<class_3222, Float> originalPitch) {
        for (class_3222 player : cutscenePlayers) {
            if (player == null || !player.method_5805()) continue;
            if (player.field_13974.method_14257() != class_1934.field_9219) {
                player.method_7336(class_1934.field_9219);
            }
            if (!player.method_31549().field_7479) continue;
            player.method_31549().field_7479 = false;
            player.method_31549().field_7478 = false;
            player.method_7355();
        }
        if (cutsceneTick >= 1) {
            double totalDuration = 120.0;
            double progress = Math.min((double)cutsceneTick / totalDuration, 1.0);
            double smoothProgress = progress * progress * (3.0 - 2.0 * progress);
            double orbitAngle = smoothProgress * Math.PI * 1.5;
            for (class_3222 player : cutscenePlayers) {
                if (player == null || !player.method_5805()) continue;
                double baseRadius = 12.0;
                double radiusVariation = Math.sin(progress * Math.PI * 2.0) * 1.5;
                double radius = baseRadius + radiusVariation;
                double baseHeight = 8.0;
                double heightVariation = Math.sin(progress * Math.PI * 1.2) * 0.8;
                double height = baseHeight + heightVariation;
                double newX = (double)altarPos.method_10263() + 0.5 + Math.cos(orbitAngle) * radius;
                double newY = (double)altarPos.method_10264() + height;
                double newZ = (double)altarPos.method_10260() + 0.5 + Math.sin(orbitAngle) * radius;
                class_243 lookTarget = new class_243((double)altarPos.method_10263() + 0.5, (double)altarPos.method_10264() + 2.5, (double)altarPos.method_10260() + 0.5);
                class_243 newCameraPos = new class_243(newX, newY, newZ);
                class_243 lookDirection = lookTarget.method_1020(newCameraPos).method_1029();
                float targetYaw = (float)Math.toDegrees(Math.atan2(-lookDirection.field_1352, lookDirection.field_1350));
                float targetPitch = (float)Math.toDegrees(Math.asin(-lookDirection.field_1351));
                player.method_14251(serverWorld, newX, newY, newZ, targetYaw, targetPitch);
                if (cutsceneTick % 10 != 0) continue;
                player.method_31549().field_7479 = false;
                player.method_31549().field_7478 = false;
                player.method_7355();
            }
        }
        class_243 altarCenter = new class_243((double)altarPos.method_10263() + 0.5, (double)(altarPos.method_10264() + 1), (double)altarPos.method_10260() + 0.5);
        if (cutsceneTick <= 40) {
            double maxRadius = (double)cutsceneTick / 40.0 * 15.0;
            for (double r = 0.0; r <= maxRadius; r += 0.8) {
                int particlesInRing = Math.max(8, (int)(r * 4.0));
                for (int i = 0; i < particlesInRing; ++i) {
                    double angle = (double)i / (double)particlesInRing * Math.PI * 2.0;
                    double x = altarCenter.field_1352 + Math.cos(angle) * r;
                    double z = altarCenter.field_1350 + Math.sin(angle) * r;
                    serverWorld.method_14199((class_2394)class_2398.field_11219, x, (double)altarPos.method_10264() + 0.1, z, 2, 0.2, 0.1, 0.2, 0.05);
                    if (!(r > 8.0)) continue;
                    serverWorld.method_14199((class_2394)class_2398.field_17741, x, (double)altarPos.method_10264() + 0.5, z, 1, 0.1, 0.1, 0.1, 0.02);
                }
            }
            if (cutsceneTick == 10) {
                serverWorld.method_8396(null, altarPos, class_3417.field_28601, class_3419.field_15245, 1.5f, 0.8f);
            }
            if (cutsceneTick == 25) {
                serverWorld.method_8396(null, altarPos, class_3417.field_14671, class_3419.field_15251, 1.2f, 0.6f);
            }
        } else if (cutsceneTick <= 80) {
            if (cutsceneTick == 45) {
                this.spawnHavenOrbs(serverWorld, altarPos);
            }
            if (cutsceneTick > 50) {
                this.createOrbToAltarBeams(serverWorld, altarPos);
            }
            double pillarHeight = Math.min((double)(cutsceneTick - 40) / 40.0 * 10.0, 10.0);
            for (double y = 0.0; y <= pillarHeight; y += 0.2) {
                serverWorld.method_14199((class_2394)class_2398.field_22246, altarCenter.field_1352, altarCenter.field_1351 + y, altarCenter.field_1350, 3, 0.2, 0.1, 0.2, 0.02);
                if (!(y > 6.0)) continue;
                serverWorld.method_14199((class_2394)class_2398.field_11215, altarCenter.field_1352, altarCenter.field_1351 + y, altarCenter.field_1350, 2, 0.3, 0.1, 0.3, 0.08);
            }
        } else if (cutsceneTick <= 119) {
            double intensity = (double)(cutsceneTick - 80) / 40.0;
            for (int spiral = 0; spiral < 6; ++spiral) {
                double spiralHeight = intensity * 8.0;
                double angle = (double)cutsceneTick * 0.6 + (double)spiral * Math.PI / 3.0;
                double radius = 2.0 + Math.sin(intensity * Math.PI) * 1.5;
                x = altarCenter.field_1352 + Math.cos(angle) * radius;
                z = altarCenter.field_1350 + Math.sin(angle) * radius;
                serverWorld.method_14199((class_2394)class_2398.field_11249, x, altarCenter.field_1351 + spiralHeight, z, 3, 0.1, 0.1, 0.1, 0.0);
                serverWorld.method_14199((class_2394)class_2398.field_38002, x, altarCenter.field_1351 + spiralHeight, z, 2, 0.15, 0.15, 0.15, 0.05);
            }
            if (cutsceneTick == 90) {
                serverWorld.method_8396(null, altarPos, class_3417.field_38075, class_3419.field_15251, 2.0f, 0.5f);
            }
            if (cutsceneTick == 110) {
                serverWorld.method_8396(null, altarPos, class_3417.field_14865, class_3419.field_15252, 2.5f, 0.7f);
            }
        } else if (cutsceneTick >= 120 && cutsceneTick <= 125) {
            if (cutsceneTick == 120) {
                System.out.println("DEBUG: Starting boss spawn sequence at tick 120");
                serverWorld.method_14199((class_2394)class_2398.field_11221, altarCenter.field_1352, altarCenter.field_1351 + 4.0, altarCenter.field_1350, 5, 1.0, 1.0, 1.0, 0.0);
                System.out.println("DEBUG: ModEntities.HAVENICA = " + String.valueOf(ModEntities.HAVENICA));
                try {
                    System.out.println("DEBUG: Attempting to create Havenica entity...");
                    HavenicaEntity havenica = (HavenicaEntity)ModEntities.HAVENICA.method_5883((class_1937)serverWorld);
                    if (havenica == null) {
                        System.out.println("ERROR: ModEntities.HAVENICA.create() returned null!");
                        havenica = new HavenicaEntity(ModEntities.HAVENICA, (class_1937)serverWorld);
                        System.out.println("DEBUG: Alternative creation used: " + (havenica != null));
                    } else {
                        System.out.println("DEBUG: Havenica entity created successfully: " + String.valueOf((Object)havenica));
                    }
                    if (havenica != null) {
                        havenica.method_5808(altarCenter.field_1352, altarPos.method_10264() + 1, altarCenter.field_1350, 0.0f, 0.0f);
                        havenica.method_5665((class_2561)class_2561.method_43470((String)"\u00a72\u00a7lHavenica, Guardian of the Grove"));
                        System.out.println("DEBUG: Set custom name: " + String.valueOf(havenica.method_5797()));
                        System.out.println("DEBUG: Attempting to spawn entity with spawnNewEntityAndPassengers...");
                        boolean spawned = serverWorld.method_30736((class_1297)havenica);
                        System.out.println("DEBUG: Spawn result: " + spawned);
                        if (!spawned) {
                            System.out.println("ERROR: spawnNewEntityAndPassengers() returned false!");
                        } else {
                            System.out.println("SUCCESS: Havenica spawned successfully!");
                            List nearbyHavenicas = serverWorld.method_8390(HavenicaEntity.class, new class_238(altarPos).method_1014(10.0), entity -> true);
                            System.out.println("DEBUG: Found " + nearbyHavenicas.size() + " Havenica entities nearby after spawn");
                        }
                        for (int ring = 0; ring < 5; ++ring) {
                            double ringRadius = (double)(ring + 1) * 2.0;
                            int particleCount = (int)(ringRadius * 8.0);
                            for (int i = 0; i < particleCount; ++i) {
                                double angle = (double)i / (double)particleCount * Math.PI * 2.0;
                                x = altarCenter.field_1352 + Math.cos(angle) * ringRadius;
                                z = altarCenter.field_1350 + Math.sin(angle) * ringRadius;
                                serverWorld.method_14199((class_2394)class_2398.field_11220, x, (double)(altarPos.method_10264() + 1), z, 5, 0.3, 0.5, 0.3, 0.1);
                                serverWorld.method_14199((class_2394)class_2398.field_11211, x, (double)(altarPos.method_10264() + 2), z, 3, 0.2, 0.3, 0.2, 0.05);
                            }
                        }
                    } else {
                        System.out.println("CRITICAL ERROR: Could not create Havenica entity at all!");
                    }
                }
                catch (Exception e) {
                    System.out.println("EXCEPTION during Havenica spawn: " + e.getMessage());
                    e.printStackTrace();
                }
                serverWorld.method_8396(null, altarPos, class_3417.field_14803, class_3419.field_15251, 3.0f, 0.4f);
            }
            if (cutsceneTick > 120 && cutsceneTick < 125) {
                for (int i = 0; i < 3; ++i) {
                    double angle = Math.random() * Math.PI * 2.0;
                    double radius = Math.random() * 5.0;
                    double x = altarCenter.field_1352 + Math.cos(angle) * radius;
                    double z = altarCenter.field_1350 + Math.sin(angle) * radius;
                    serverWorld.method_14199((class_2394)class_2398.field_23114, x, altarCenter.field_1351 + Math.random() * 3.0, z, 1, 0.1, 0.1, 0.1, 0.02);
                }
            }
            if (cutsceneTick >= 125) {
                this.endSpawningCutscene(cutscenePlayers, originalGameModes, originalPositions, originalFlying, originalYaw, originalPitch);
                return false;
            }
            return true;
        }
        return true;
    }

    private void spawnHavenOrbs(class_3218 world, class_2338 altarPos) {
        System.out.println("DEBUG: Spawning Haven Orbs");
        class_2338[] cardinalPositions = new class_2338[]{altarPos.method_10069(0, 2, -11), altarPos.method_10069(0, 2, 11), altarPos.method_10069(11, 2, 0), altarPos.method_10069(-11, 2, 0)};
        class_2338[] diagonalPositions = new class_2338[]{altarPos.method_10069(11, 2, -11), altarPos.method_10069(-11, 2, -11), altarPos.method_10069(11, 2, 11), altarPos.method_10069(-11, 2, 11)};
        for (class_2338 pos : cardinalPositions) {
            this.spawnHavenOrbEntityAt(world, pos, true);
        }
        for (class_2338 pos : diagonalPositions) {
            this.spawnHavenOrbEntityAt(world, pos, false);
        }
        world.method_8396(null, altarPos, class_3417.field_14703, class_3419.field_15245, 1.5f, 1.2f);
    }

    private void spawnHavenOrbEntityAt(class_3218 world, class_2338 pos, boolean isCardinal) {
        try {
            System.out.println("DEBUG: Spawning Haven Orb at " + String.valueOf(pos) + " (Cardinal: " + isCardinal + ")");
            if (ModEntities.HAVEN_CORE == null) {
                System.out.println("ERROR: ModEntities.HAVEN_CORE is null! Make sure it's registered.");
                this.spawnHavenOrbParticlesOnly(world, pos, isCardinal);
                return;
            }
            HavenCoreEntity havenCore = (HavenCoreEntity)ModEntities.HAVEN_CORE.method_5883((class_1937)world);
            if (havenCore != null) {
                havenCore.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
                boolean spawned = world.method_8649((class_1297)havenCore);
                System.out.println("DEBUG: Haven Orb spawn result: " + spawned);
                if (!spawned) {
                    System.out.println("ERROR: Failed to spawn Haven Orb entity, falling back to particles");
                    this.spawnHavenOrbParticlesOnly(world, pos, isCardinal);
                }
            } else {
                System.out.println("ERROR: ModEntities.HAVEN_CORE.create() returned null, falling back to particles");
                this.spawnHavenOrbParticlesOnly(world, pos, isCardinal);
            }
        }
        catch (Exception e) {
            System.out.println("EXCEPTION during Haven Orb spawn: " + e.getMessage());
            e.printStackTrace();
            this.spawnHavenOrbParticlesOnly(world, pos, isCardinal);
        }
    }

    private void spawnHavenOrbParticlesOnly(class_3218 world, class_2338 pos, boolean isCardinal) {
        for (int i = 0; i < 20; ++i) {
            double angle = (double)i / 20.0 * Math.PI * 2.0;
            double radius = 1.0;
            double x = (double)pos.method_10263() + 0.5 + Math.cos(angle) * radius;
            double z = (double)pos.method_10260() + 0.5 + Math.sin(angle) * radius;
            world.method_14199((class_2394)class_2398.field_11207, x, (double)pos.method_10264() + 0.5, z, 2, 0.1, 0.1, 0.1, 0.0);
            world.method_14199((class_2394)(isCardinal ? class_2398.field_22246 : class_2398.field_11240), x, (double)pos.method_10264() + 0.5, z, 1, 0.05, 0.05, 0.05, 0.02);
        }
        world.method_14199((class_2394)class_2398.field_28479, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.2, 0.2, 0.2, 0.0);
    }

    private void createOrbToAltarBeams(class_3218 world, class_2338 altarPos) {
        class_243[] orbPositions;
        class_243 altarCenter = new class_243((double)altarPos.method_10263() + 0.5, (double)(altarPos.method_10264() + 1), (double)altarPos.method_10260() + 0.5);
        for (class_243 orbPos : orbPositions = new class_243[]{new class_243((double)altarPos.method_10263() + 0.5, (double)(altarPos.method_10264() + 2), (double)altarPos.method_10260() - 10.5), new class_243((double)altarPos.method_10263() + 0.5, (double)(altarPos.method_10264() + 2), (double)altarPos.method_10260() + 11.5), new class_243((double)altarPos.method_10263() + 11.5, (double)(altarPos.method_10264() + 2), (double)altarPos.method_10260() + 0.5), new class_243((double)altarPos.method_10263() - 10.5, (double)(altarPos.method_10264() + 2), (double)altarPos.method_10260() + 0.5), new class_243((double)altarPos.method_10263() + 11.5, (double)(altarPos.method_10264() + 2), (double)altarPos.method_10260() - 7.5), new class_243((double)altarPos.method_10263() - 7.5, (double)(altarPos.method_10264() + 2), (double)altarPos.method_10260() - 7.5), new class_243((double)altarPos.method_10263() + 11.5, (double)(altarPos.method_10264() + 2), (double)altarPos.method_10260() + 11.5), new class_243((double)altarPos.method_10263() - 7.5, (double)(altarPos.method_10264() + 2), (double)altarPos.method_10260() + 11.5)}) {
            class_243 direction = altarCenter.method_1020(orbPos);
            double distance = direction.method_1033();
            direction = direction.method_1029();
            for (double d = 0.0; d < distance; d += 0.3) {
                class_243 particlePos = orbPos.method_1019(direction.method_1021(d));
                world.method_14199((class_2394)class_2398.field_29644, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.05, 0.05, 0.05, 0.0);
                if (!(d % 1.2 < 0.3)) continue;
                world.method_14199((class_2394)class_2398.field_11215, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.1, 0.1, 0.1, 0.02);
            }
        }
    }

    private void endSpawningCutscene(Set<class_3222> cutscenePlayers, Map<class_3222, class_1934> originalGameModes, Map<class_3222, class_243> originalPositions, Map<class_3222, Boolean> originalFlying, Map<class_3222, Float> originalYaw, Map<class_3222, Float> originalPitch) {
        HashSet<class_3222> playersToRestore = new HashSet<class_3222>(cutscenePlayers);
        for (class_3222 player : playersToRestore) {
            if (player == null || !player.method_5805()) continue;
            try {
                Boolean wasFlying;
                class_1934 originalMode = originalGameModes.get(player);
                if (originalMode != null) {
                    player.method_7336(originalMode);
                }
                class_243 originalPos = originalPositions.get(player);
                Float origYaw = originalYaw.get(player);
                Float origPitch = originalPitch.get(player);
                if (originalPos != null && origYaw != null && origPitch != null) {
                    player.method_14251(player.method_51469(), originalPos.field_1352, originalPos.field_1351, originalPos.field_1350, origYaw.floatValue(), origPitch.floatValue());
                }
                if ((wasFlying = originalFlying.get(player)) != null) {
                    player.method_31549().field_7479 = wasFlying;
                    player.method_31549().field_7478 = originalMode == class_1934.field_9220 || originalMode == class_1934.field_9219;
                    player.method_7355();
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a72\u00a7l\u300e \u00a7a\u00a7lTHE GUARDIAN AWAKENS \u00a72\u00a7l\u300f"), true);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76Havenica has been summoned to defend the grove!"), false);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7lThe battle begins!"), false);
            }
            catch (Exception e) {
                System.out.println("ERROR: Failed to restore player " + player.method_5477().getString());
                e.printStackTrace();
            }
        }
        System.out.println("DEBUG: Cutscene completed successfully!");
    }
}

