/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.block.custom;

import cassetu.mystbornhorizons.block.ModBlocks;
import cassetu.mystbornhorizons.block.entity.BasaltSpawnerBlockEntity;
import cassetu.mystbornhorizons.block.entity.ModBlockEntities;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class BasaltSpawnerBlock
extends class_2237 {
    public static final MapCodec<BasaltSpawnerBlock> CODEC = BasaltSpawnerBlock.method_54094(BasaltSpawnerBlock::new);
    public static final class_2746 ACTIVE = class_2746.method_11825((String)"active");
    public static final class_2758 WAVE = class_2758.method_11867((String)"wave", (int)1, (int)3);

    public BasaltSpawnerBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WAVE, (Comparable)Integer.valueOf(1)));
    }

    public MapCodec<BasaltSpawnerBlock> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ACTIVE, WAVE});
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BasaltSpawnerBlockEntity(pos, state);
    }

    public boolean method_9522(class_2680 state, class_2680 stateFrom, class_2350 direction) {
        return false;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 blockEntity;
        if (!world.field_9236 && (blockEntity = world.method_8321(pos)) instanceof BasaltSpawnerBlockEntity) {
            BasaltSpawnerBlockEntity spawnerEntity = (BasaltSpawnerBlockEntity)blockEntity;
            if (spawnerEntity.isOnCooldown()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"Spawner on cooldown"), true);
            } else if (!((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
                spawnerEntity.startTrial(player);
                world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)WAVE, (Comparable)Integer.valueOf(1)));
                world.method_8396(null, pos, class_3417.field_47206, class_3419.field_15245, 1.0f, 1.0f);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76Wave 1 Started!"), true);
            }
        }
        return class_1269.field_5812;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? null : BasaltSpawnerBlock.method_31618(type, ModBlockEntities.BASALT_SPAWNER, BasaltSpawnerBlockEntity::serverTick);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
            for (int i = 0; i < 5; ++i) {
                double x = (double)pos.method_10263() + random.method_43058();
                double y = (double)pos.method_10264() + random.method_43058();
                double z = (double)pos.method_10260() + random.method_43058();
                world.method_8406((class_2394)class_2398.field_11240, x, y, z, 0.0, 0.1, 0.0);
                world.method_8406((class_2394)class_2398.field_11239, x, y, z, 0.0, 0.05, 0.0);
            }
            int wave = (Integer)state.method_11654((class_2769)WAVE);
            if (wave >= 3) {
                world.method_8406((class_2394)class_2398.field_11237, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 0.5, 0.0, 0.1, 0.0);
            }
        }
    }

    public void completeTrial(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236) {
            world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WAVE, (Comparable)Integer.valueOf(1)));
            world.method_8396(null, pos, class_3417.field_47210, class_3419.field_15245, 1.0f, 1.0f);
            this.spawnLootChest(world, pos);
        }
    }

    private void spawnLootChest(class_1937 world, class_2338 pos) {
        for (int radius = 2; radius <= 4; ++radius) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (Math.abs(x) != radius && Math.abs(z) != radius) continue;
                    class_2338 chestPos = pos.method_10069(x, 0, z);
                    class_2338 groundPos = chestPos.method_10074();
                    if (!world.method_8320(chestPos).method_26215() || !world.method_8320(groundPos).method_26212((class_1922)world, groundPos)) continue;
                    world.method_8501(chestPos, class_2246.field_10034.method_9564());
                    class_2586 class_25862 = world.method_8321(chestPos);
                    if (class_25862 instanceof class_2595) {
                        class_2595 chestEntity = (class_2595)class_25862;
                        chestEntity.method_54867(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"mystbornhorizons", (String)"chests/basalt_spawner_reward")), world.method_8409().method_43055());
                    }
                    class_238 messageBox = new class_238(pos).method_1014(10.0);
                    List nearbyPlayers = world.method_8390(class_1657.class, messageBox, player -> !player.method_7325());
                    for (class_1657 player2 : nearbyPlayers) {
                        player2.method_7353((class_2561)class_2561.method_43470((String)("\u00a76Reward Chest spawned at: \u00a7e" + chestPos.method_10263() + ", " + chestPos.method_10264() + ", " + chestPos.method_10260())), true);
                    }
                    return;
                }
            }
        }
    }

    public boolean isValidSpawnLocation(class_1937 world, class_2338 spawnPos) {
        class_2338 groundPos = spawnPos.method_10074();
        class_2680 groundState = world.method_8320(groundPos);
        return groundState.method_27852(ModBlocks.GILDED_BASALT_TILING);
    }

    public void updateWave(class_1937 world, class_2338 pos, int newWave) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() == this && ((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)WAVE, (Comparable)Integer.valueOf(Math.min(3, newWave))));
            world.method_8396(null, pos, class_3417.field_47206, class_3419.field_15245, 1.0f, 0.8f + (float)newWave * 0.1f);
            if (newWave <= 3) {
                class_238 messageBox = new class_238(pos).method_1014(10.0);
                List nearbyPlayers = world.method_8390(class_1657.class, messageBox, player -> !player.method_7325());
                for (class_1657 player2 : nearbyPlayers) {
                    if (newWave == 2) {
                        player2.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aWave 1 Complete! \u00a76Wave 2 Started!"), true);
                        continue;
                    }
                    if (newWave != 3) continue;
                    player2.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aWave 2 Complete! \u00a76Wave 3 Started!"), true);
                }
            }
        }
    }
}

