/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.block.entity;

import cassetu.mystbornhorizons.block.ModBlocks;
import cassetu.mystbornhorizons.block.custom.BasaltSpawnerBlock;
import cassetu.mystbornhorizons.block.entity.ModBlockEntities;
import cassetu.mystbornhorizons.entity.ModEntities;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7225;

public class BasaltSpawnerBlockEntity
extends class_2586 {
    private int currentWave = 1;
    private int maxWaves = 3;
    private int mobsToSpawn = 0;
    private int mobsSpawned = 0;
    private int ticksSinceLastSpawn = 0;
    private int spawnDelay = 40;
    private boolean trialActive = false;
    private boolean onCooldown = false;
    private long cooldownEndTime = 0L;
    private UUID trialStarterId = null;
    private Set<UUID> participatingPlayers = new HashSet<UUID>();
    private Set<UUID> spawnedMobs = new HashSet<UUID>();
    private static final int SPAWN_RADIUS = 10;
    private static final int DETECTION_RADIUS = 15;
    private static final long COOLDOWN_DURATION = 72000L;

    public boolean isOnCooldown() {
        return this.onCooldown;
    }

    public long getCooldownTicksRemaining(long currentTime) {
        if (!this.onCooldown) {
            return 0L;
        }
        return Math.max(0L, this.cooldownEndTime - currentTime);
    }

    public BasaltSpawnerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.BASALT_SPAWNER, pos, state);
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, BasaltSpawnerBlockEntity blockEntity) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            blockEntity.tick(serverWorld, pos, state);
        }
    }

    private void tick(class_3218 world, class_2338 pos, class_2680 state) {
        if (this.onCooldown) {
            if (world.method_8510() >= this.cooldownEndTime) {
                this.onCooldown = false;
                this.method_5431();
            }
            return;
        }
        if (!this.trialActive) {
            return;
        }
        this.updateParticipatingPlayers(world, pos);
        if (this.mobsToSpawn <= 0 && this.areAllMobsDefeated(world, pos)) {
            if (this.currentWave >= this.maxWaves) {
                this.completeTrial(world, pos, state);
                return;
            }
            this.advanceToNextWave(world, pos, state);
        }
        if (this.mobsToSpawn > 0) {
            ++this.ticksSinceLastSpawn;
            if (this.ticksSinceLastSpawn >= this.spawnDelay) {
                this.spawnMob(world, pos);
                this.ticksSinceLastSpawn = 0;
            }
        }
        this.spawnTrialParticles(world, pos, state);
    }

    public boolean canStartTrial() {
        return !this.trialActive && !this.onCooldown;
    }

    public void startTrial(class_1657 player) {
        if (!this.canStartTrial()) {
            return;
        }
        this.trialActive = true;
        this.trialStarterId = player.method_5667();
        this.currentWave = 1;
        this.participatingPlayers.clear();
        this.participatingPlayers.add(player.method_5667());
        this.spawnedMobs.clear();
        this.setupWave(this.currentWave);
        this.method_5431();
    }

    private void setupWave(int wave) {
        this.mobsToSpawn = 2 + wave * 3;
        this.mobsSpawned = 0;
        this.spawnDelay = Math.max(15, 60 - wave * 8);
    }

    private void spawnMob(class_3218 world, class_2338 pos) {
        if (this.mobsToSpawn <= 0) {
            return;
        }
        class_2338 spawnPos = this.findValidSpawnPos(world, pos);
        if (spawnPos == null) {
            return;
        }
        class_1299<? extends class_1308> mobType = this.getMobTypeForWave(this.currentWave);
        if (mobType == null) {
            return;
        }
        class_1308 mob = (class_1308)mobType.method_5883((class_1937)world);
        if (mob != null) {
            mob.method_5808((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, 0.0f, 0.0f);
            mob.method_5943((class_5425)world, world.method_8404(spawnPos), class_3730.field_16469, null);
            String mobTypeName = mob.method_5864().method_5897().getString();
            mob.method_5665((class_2561)class_2561.method_43470((String)(mobTypeName + " Spawn")));
            mob.method_5880(false);
            mob.method_5971();
            class_2487 nbt = new class_2487();
            mob.method_5647(nbt);
            nbt.method_10556("IsSpawnerMob", true);
            mob.method_5651(nbt);
            if (mob instanceof class_1588) {
                class_1588 hostileMob = (class_1588)mob;
                class_1657 target = this.findNearestParticipatingPlayer(world, pos);
                if (target != null) {
                    hostileMob.method_5980((class_1309)target);
                }
            }
            world.method_8649((class_1297)mob);
            this.spawnedMobs.add(mob.method_5667());
            this.spawnMobParticles(world, spawnPos);
            world.method_8396(null, spawnPos, class_3417.field_14991, class_3419.field_15251, 0.8f, 1.0f);
            --this.mobsToSpawn;
            ++this.mobsSpawned;
            this.method_5431();
        }
    }

    private void spawnMobParticles(class_3218 world, class_2338 spawnPos) {
        class_5819 random = world.method_8409();
        for (int i = 0; i < 20; ++i) {
            double offsetX = (random.method_43058() - 0.5) * 2.0;
            double offsetZ = (random.method_43058() - 0.5) * 2.0;
            double offsetY = random.method_43058() * 2.0;
            world.method_8406((class_2394)class_2398.field_11239, (double)spawnPos.method_10263() + 0.5 + offsetX, (double)spawnPos.method_10264() + offsetY, (double)spawnPos.method_10260() + 0.5 + offsetZ, 0.0, 0.1, 0.0);
            world.method_8406((class_2394)class_2398.field_11237, (double)spawnPos.method_10263() + 0.5 + offsetX, (double)(spawnPos.method_10264() + 1) + offsetY, (double)spawnPos.method_10260() + 0.5 + offsetZ, 0.0, 0.2, 0.0);
            if (i >= 5) continue;
            world.method_8406((class_2394)class_2398.field_11240, (double)spawnPos.method_10263() + 0.5 + offsetX, (double)spawnPos.method_10264() + 0.5 + offsetY, (double)spawnPos.method_10260() + 0.5 + offsetZ, 0.0, 0.15, 0.0);
        }
    }

    private class_1299<? extends class_1308> getMobTypeForWave(int wave) {
        return switch (wave) {
            case 1 -> class_1299.field_6051;
            case 2 -> ModEntities.COPPERBULB;
            case 3 -> ModEntities.BASALTHOWLER;
            default -> class_1299.field_6051;
        };
    }

    private class_2338 findValidSpawnPos(class_3218 world, class_2338 center) {
        class_5819 random = world.field_9229;
        for (int i = 0; i < 30; ++i) {
            double angle = random.method_43058() * 2.0 * Math.PI;
            int radius = 3 + random.method_43048(7);
            int x = center.method_10263() + (int)(Math.cos(angle) * (double)radius);
            int z = center.method_10260() + (int)(Math.sin(angle) * (double)radius);
            for (int y = center.method_10264() + 4; y >= center.method_10264() - 4; --y) {
                class_2338 testPos = new class_2338(x, y, z);
                class_2338 groundPos = testPos.method_10074();
                class_2680 groundState = world.method_8320(groundPos);
                if (!groundState.method_27852(ModBlocks.GILDED_BASALT_TILING) || !world.method_8320(testPos).method_26215() || !world.method_8320(testPos.method_10084()).method_26215()) continue;
                return testPos;
            }
        }
        return null;
    }

    private boolean areAllMobsDefeated(class_3218 world, class_2338 pos) {
        this.spawnedMobs.removeIf(uuid -> {
            class_1308 mob = (class_1308)world.method_14190(uuid);
            return mob == null || !mob.method_5805();
        });
        return this.spawnedMobs.isEmpty();
    }

    private void updateParticipatingPlayers(class_3218 world, class_2338 pos) {
        class_238 detectionBox = new class_238(pos).method_1014(15.0);
        List nearbyPlayers = world.method_8390(class_1657.class, detectionBox, player -> !player.method_7325());
        for (class_1657 player2 : nearbyPlayers) {
            this.participatingPlayers.add(player2.method_5667());
        }
    }

    private class_1657 findNearestParticipatingPlayer(class_3218 world, class_2338 pos) {
        class_1657 nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (UUID playerId : this.participatingPlayers) {
            double distance;
            class_1657 player = world.method_18470(playerId);
            if (player == null || !((distance = player.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())) < nearestDistance)) continue;
            nearest = player;
            nearestDistance = distance;
        }
        return nearest;
    }

    private void advanceToNextWave(class_3218 world, class_2338 pos, class_2680 state) {
        ++this.currentWave;
        this.setupWave(this.currentWave);
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof BasaltSpawnerBlock) {
            BasaltSpawnerBlock block = (BasaltSpawnerBlock)class_22482;
            block.updateWave((class_1937)world, pos, this.currentWave);
        }
        world.method_8396(null, pos, class_3417.field_50101, class_3419.field_15245, 1.0f, 0.8f + (float)this.currentWave * 0.1f);
        this.method_5431();
    }

    private void completeTrial(class_3218 world, class_2338 pos, class_2680 state) {
        this.trialActive = false;
        this.onCooldown = true;
        this.cooldownEndTime = world.method_8510() + 72000L;
        this.spawnLootRewards(world, pos);
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof BasaltSpawnerBlock) {
            BasaltSpawnerBlock block = (BasaltSpawnerBlock)class_22482;
            block.completeTrial((class_1937)world, pos, state);
        }
        this.participatingPlayers.clear();
        this.trialStarterId = null;
        this.currentWave = 1;
        this.mobsToSpawn = 0;
        this.spawnedMobs.clear();
        this.method_5431();
    }

    private void spawnLootRewards(class_3218 world, class_2338 pos) {
    }

    private void cancelTrial(class_3218 world, class_2338 pos, class_2680 state) {
        this.trialActive = false;
        world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)BasaltSpawnerBlock.ACTIVE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BasaltSpawnerBlock.WAVE, (Comparable)Integer.valueOf(1)));
        this.participatingPlayers.clear();
        this.trialStarterId = null;
        this.currentWave = 1;
        this.mobsToSpawn = 0;
        this.spawnedMobs.clear();
        this.method_5431();
    }

    private void spawnTrialParticles(class_3218 world, class_2338 pos, class_2680 state) {
        if (world.method_8510() % 8L == 0L) {
            for (int i = 0; i < 12; ++i) {
                double angle = (double)i / 12.0 * 2.0 * Math.PI;
                double x = (double)pos.method_10263() + 0.5 + Math.cos(angle) * 3.0;
                double z = (double)pos.method_10260() + 0.5 + Math.sin(angle) * 3.0;
                double y = (double)pos.method_10264() + 1.5;
                world.method_8406((class_2394)class_2398.field_11240, x, y, z, 0.0, 0.05, 0.0);
                world.method_8406((class_2394)class_2398.field_11251, x, y, z, 0.0, 0.1, 0.0);
            }
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("currentWave", this.currentWave);
        nbt.method_10569("mobsToSpawn", this.mobsToSpawn);
        nbt.method_10569("mobsSpawned", this.mobsSpawned);
        nbt.method_10556("trialActive", this.trialActive);
        nbt.method_10556("onCooldown", this.onCooldown);
        nbt.method_10544("cooldownEndTime", this.cooldownEndTime);
        if (this.trialStarterId != null) {
            nbt.method_25927("trialStarterId", this.trialStarterId);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.currentWave = nbt.method_10550("currentWave");
        this.mobsToSpawn = nbt.method_10550("mobsToSpawn");
        this.mobsSpawned = nbt.method_10550("mobsSpawned");
        this.trialActive = nbt.method_10577("trialActive");
        this.onCooldown = nbt.method_10577("onCooldown");
        this.cooldownEndTime = nbt.method_10537("cooldownEndTime");
        if (nbt.method_25928("trialStarterId")) {
            this.trialStarterId = nbt.method_25926("trialStarterId");
        }
    }
}

