/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.command;

import cassetu.mystbornhorizons.util.EnhancedMobEquipment;
import cassetu.mystbornhorizons.world.CurseState;
import cassetu.mystbornhorizons.world.HavenicaDefeatState;
import cassetu.mystbornhorizons.world.NetherAccessState;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1588;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_7157;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;

public class MystbornCommands {
    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> MystbornCommands.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mystborn").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nether").then(class_2170.method_9247((String)"grant").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            NetherAccessState accessState = NetherAccessState.getOrCreate(player.method_5682());
            if (accessState.hasNetherAccess(player.method_5667())) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7e" + player.method_5477().getString() + " already has Nether access.")), false);
            } else {
                accessState.grantNetherAccess(player.method_5667(), player.method_5682());
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aGranted Nether access to " + player.method_5477().getString() + ".")), true);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76You have been granted access to the Nether!"), false);
            }
            return 1;
        })))).then(class_2170.method_9247((String)"revoke").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            NetherAccessState accessState = NetherAccessState.getOrCreate(player.method_5682());
            if (!accessState.hasNetherAccess(player.method_5667())) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7e" + player.method_5477().getString() + " doesn't have Nether access.")), false);
            } else {
                accessState.revokeNetherAccess(player.method_5667(), player.method_5682());
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cRevoked Nether access from " + player.method_5477().getString() + ".")), true);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cYour Nether access has been revoked!"), false);
            }
            return 1;
        })))).then(class_2170.method_9247((String)"check").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            NetherAccessState accessState = NetherAccessState.getOrCreate(player.method_5682());
            if (accessState.hasNetherAccess(player.method_5667())) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7a" + player.method_5477().getString() + " has Nether access.")), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7c" + player.method_5477().getString() + " does NOT have Nether access.")), false);
            }
            return 1;
        })))).then(class_2170.method_9247((String)"reset").executes(context -> {
            NetherAccessState accessState = NetherAccessState.getOrCreate(((class_2168)context.getSource()).method_9211());
            accessState.clearAll(((class_2168)context.getSource()).method_9211());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aCleared all Nether access permissions."), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"havenica").then(class_2170.method_9247((String)"status").executes(context -> {
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            HavenicaDefeatState state = HavenicaDefeatState.getOrCreate(world);
            if (state.isHavenicaDefeated()) {
                long defeatTime = state.getDefeatTime();
                long currentTime = world.method_8510();
                long timeSinceDefeat = currentTime - defeatTime;
                long daysPassed = timeSinceDefeat / 24000L;
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cHavenica was defeated " + daysPassed + " days ago. Enhanced mob spawning is ACTIVE.")), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aHavenica has not been defeated. Normal mob spawning."), false);
            }
            return 1;
        }))).then(class_2170.method_9247((String)"reset").executes(context -> {
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            world.method_17983().method_123("havenica_defeat_state", (class_18)new HavenicaDefeatState());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aHavenica defeat status has been reset. Mob spawning returned to normal."), true);
            return 1;
        }))).then(class_2170.method_9247((String)"setdefeated").then(class_2170.method_9244((String)"defeated", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean defeated = BoolArgumentType.getBool((CommandContext)context, (String)"defeated");
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            HavenicaDefeatState state = HavenicaDefeatState.getOrCreate(world);
            if (defeated) {
                state.setHavenicaDefeated(world);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7cHavenica marked as defeated. Enhanced mob spawning enabled."), true);
            } else {
                world.method_17983().method_123("havenica_defeat_state", (class_18)new HavenicaDefeatState());
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aHavenica marked as not defeated. Normal mob spawning."), true);
            }
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"curse").then(class_2170.method_9247((String)"status").executes(context -> {
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            CurseState curseState = CurseState.getOrCreate(world);
            if (curseState.isCurseActive()) {
                int mobsKilled = curseState.getMobsKilled();
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a74Forest's Curse is ACTIVE. Progress: " + mobsKilled + "/10 cursed mobs killed.")), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aForest's Curse is not active."), false);
            }
            return 1;
        }))).then(class_2170.method_9247((String)"start").executes(context -> {
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            CurseState curseState = CurseState.getOrCreate(world);
            if (!curseState.isCurseActive()) {
                curseState.activateCurse(world);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a74\u00a7lThe Forest's Curse has been activated!"), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7cThe Forest's Curse is already active."), false);
            }
            return 1;
        }))).then(class_2170.method_9247((String)"end").executes(context -> {
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            CurseState curseState = CurseState.getOrCreate(world);
            if (curseState.isCurseActive()) {
                curseState.endCurse(world);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a72\u00a7lThe Forest's Curse has been lifted!"), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aThe Forest's Curse is not currently active."), false);
            }
            return 1;
        })))).then(class_2170.method_9247((String)"lore").then(class_2170.method_9247((String)"book").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_1297 patt0$temp = source.method_9228();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                MystbornCommands.giveLoreBook(player);
                source.method_9226(() -> class_2561.method_43470((String)"\u00a72The Chronicles of Havenica has been given to you."), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)"\u00a7cThis command can only be used by players."), false);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"summon").then(class_2170.method_9247((String)"infected").executes(context -> {
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)context.getSource()).method_9222());
            class_1299[] mobTypes = new class_1299[]{class_1299.field_6051, class_1299.field_6145, class_1299.field_49148, class_1299.field_6079, class_1299.field_6091, class_1299.field_6117, class_1299.field_6137};
            class_1299 chosenType = mobTypes[world.method_8409().method_43048(mobTypes.length)];
            class_1297 patt0$temp = chosenType.method_5883((class_1937)world);
            if (patt0$temp instanceof class_1588) {
                class_1588 mob = (class_1588)patt0$temp;
                mob.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
                mob.method_5943((class_5425)world, world.method_8404(pos), class_3730.field_16462, null);
                HavenicaDefeatState state = HavenicaDefeatState.getOrCreate(world);
                state.setHavenicaDefeated(world);
                EnhancedMobEquipment.equipPostHavenicaMob((class_1308)mob, world);
                EnhancedMobEquipment.applyCorruptionEffects((class_1308)mob, world);
                world.method_14199((class_2394)class_2398.field_28803, mob.method_23317(), mob.method_23318() + 1.0, mob.method_23321(), 10, 1.0, 1.0, 1.0, 0.1);
                world.method_8649((class_1297)mob);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a72Infected " + mob.method_5864().method_5897().getString() + " summoned!")), false);
            }
            return 1;
        }))).then(class_2170.method_9247((String)"cursed").executes(context -> {
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)context.getSource()).method_9222());
            class_1299[] mobTypes = new class_1299[]{class_1299.field_6051, class_1299.field_6145, class_1299.field_49148, class_1299.field_6079, class_1299.field_6091, class_1299.field_6117, class_1299.field_6137};
            class_1299 chosenType = mobTypes[world.method_8409().method_43048(mobTypes.length)];
            class_1297 patt0$temp = chosenType.method_5883((class_1937)world);
            if (patt0$temp instanceof class_1588) {
                class_1588 mob = (class_1588)patt0$temp;
                mob.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
                mob.method_5943((class_5425)world, world.method_8404(pos), class_3730.field_16462, null);
                EnhancedMobEquipment.equipCursedMob((class_1308)mob, world);
                EnhancedMobEquipment.applyCurseEffects((class_1308)mob, world);
                world.method_14199((class_2394)class_2398.field_22246, mob.method_23317(), mob.method_23318() + 1.0, mob.method_23321(), 10, 1.0, 1.0, 1.0, 0.1);
                world.method_8649((class_1297)mob);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a74Cursed " + mob.method_5864().method_5897().getString() + " summoned!")), false);
            }
            return 1;
        }))));
    }

    private static void giveLoreBook(class_3222 player) {
        class_1799 book = new class_1799((class_1935)class_1802.field_8360);
        String page1 = "\u00a70\u00a7lThe Chronicles of Havenica\u00a7r\n\n\u00a78The Rise and Fall of the Forest Guardian\u00a7r\n\n\u00a77This tome contains the tragic tale of Havenica, the ancient guardian whose corruption brought darkness to the world.";
        String page2 = "\u00a70\u00a7lChapter 1: The Ancient Grove\u00a7r\n\n\u00a78In the primordial age, there existed a sacred grove at the heart of an endless forest. This nexus of life force was where Havenica first awakened...";
        String page3 = "\u00a70\u00a7lThe Guardian's Birth\u00a7r\n\n\u00a78Born from the collective will of the forest itself, Havenica emerged as the ultimate guardian\u2014a sentient embodiment of nature's protective instincts.";
        String page4 = "\u00a70\u00a7lChapter 2: The Golden Age\u00a7r\n\n\u00a78Under Havenica's protection, the forest flourished. The Haven Cores emerged\u2014eight crystalline entities that extended the guardian's influence.";
        String page5 = "\u00a70\u00a7lThe Haven Core Network\u00a7r\n\n\u00a78Four primary cores at cardinal points, four secondary at diagonals. They channeled Havenica's will while feeding energy back to their creator.";
        String page6 = "\u00a70\u00a7lThe Verdant Circle\u00a7r\n\n\u00a78Wise humans learned to coexist with Havenica's domain. They crafted the Forest Heart as both offering and key to commune with the guardian.";
        String page7 = "\u00a70\u00a7lChapter 3: The Corruption\u00a7r\n\n\u00a78Industrial expansion and dark rituals began to poison the forest. The corruption was insidious, working slowly to undermine harmony.";
        String page8 = "\u00a70\u00a7lThe Creeping Darkness\u00a7r\n\n\u00a78Each cleansing left residue. The corruption whispered to wildlife, tainted soil, and most dangerously, began affecting Havenica itself.";
        String page9 = "\u00a70\u00a7lSigns of Change\u00a7r\n\n\u00a78Havenica became more aggressive. The Haven Cores pulsed with angry red light. The Forest Heart produced unpredictable results.";
        String page10 = "\u00a70\u00a7lChapter 4: The Fall\u00a7r\n\n\u00a78During 'The Night of Screaming Wood,' Havenica's protective rage transformed into an overwhelming compulsion to destroy.";
        String page11 = "\u00a70\u00a7lThe Transformed Guardian\u00a7r\n\n\u00a78Havenica's bark turned sickly black-green with pulsing red veins. Its eyes burned with cold, hungry fire that consumed rather than illuminated.";
        String page12 = "\u00a70\u00a7lNew Abilities\u00a7r\n\n\u00a78Toxic Laser: poisonous beams. Root Network: life-draining patterns. Shockwave Blast: devastating area attacks. Gardens Wrath: reality-bending fury.";
        String page13 = "\u00a70\u00a7lThe Haven Cores' Corruption\u00a7r\n\n\u00a78The cores' green light turned sickly red. Instead of healing, they spread corruption. They gained malevolent intelligence.";
        String page14 = "\u00a70\u00a7lThe Final Ritual\u00a7r\n\n\u00a78The Verdant Circle attempted one last cleansing ritual, but Havenica's corruption was beyond redemption. The guardian destroyed its former allies.";
        String page15 = "\u00a70\u00a7lChapter 5: The Forest's Curse\u00a7r\n\n\u00a78When Havenica falls in battle, its accumulated corruption explodes outward, fundamentally altering the world's nature.";
        String page16 = "\u00a70\u00a7lCassetu's Voice\u00a7r\n\n\u00a78The curse spoke through Cassetu, a Verdant Circle member, delivering twisted messages: 'Something ancient stirs beneath our feet...'";
        String page17 = "\u00a70\u00a7lThe Whispers\u00a7r\n\n\u00a78'We've poisoned this place just by being here.' 'The earth itself rejects us now.' 'The world grows darker with each breath...'";
        String page18 = "\u00a70\u00a7lManifestation\u00a7r\n\n\u00a78'Can you feel it spreading? The taint seeps into everything.' The curse reveals its truth: 'The curse feeds on our fear.'";
        String page19 = "\u00a70\u00a7lMemory and Madness\u00a7r\n\n\u00a78'The forest remembers what we've done.' 'It knows we're here.' 'Do you hear them too? The voices in the wind?'";
        String page20 = "\u00a70\u00a7lThe Curse's Effects\u00a7r\n\n\u00a78Eternal twilight. Chaotic weather. Creatures become 'cursed' with enhanced bodies but twisted minds, echoing Havenica's fall.";
        String page21 = "\u00a70\u00a7lCursed Essence\u00a7r\n\n\u00a78Cursed creatures drop fragments of Havenica's tainted life force. Each essence cleansed brings the world closer to lifting the burden.";
        String page22 = "\u00a70\u00a7lPsychological Warfare\u00a7r\n\n\u00a78The curse clouds vision with dirt and corruption, representing Havenica's tainted perspective. Spores carry spiritual contamination.";
        String page23 = "\u00a70\u00a7lDistorted Purpose\u00a7r\n\n\u00a78The curse doesn't seek random destruction. It follows patterns reflecting Havenica's desperate attempts to restore 'natural order.'";
        String page24 = "\u00a70\u00a7lThe Tragic Guardian\u00a7r\n\n\u00a78Even corrupted, traces of purpose remain. The curse targets disrupted balance between civilization and wilderness.";
        String page25 = "\u00a70\u00a7lA Warning\u00a7r\n\n\u00a78Havenica's tale warns of the balance between protection and obsession, between love and possession.";
        String page26 = "\u00a70\u00a7lThe Scars Remain\u00a7r\n\n\u00a78Even when cleansed, the world bears permanent scars\u2014a reminder of what was lost when the great guardian fell to corruption.";
        String page27 = "\u00a70\u00a7lWhat Might Have Been\u00a7r\n\n\u00a78The tragedy serves as a monument to what the world might have been if that ancient harmony had been allowed to continue.";
        String page28 = "\u00a70\u00a7lEpilogue\u00a7r\n\n\u00a78Only through great sacrifice can the world cleanse Havenica's legacy, but the guardian's corruption will echo through the ages.";
        List<class_9262> pages = List.of(new class_9262((Object)class_2561.method_43470((String)page1), Optional.of(class_2561.method_43470((String)page1))), new class_9262((Object)class_2561.method_43470((String)page2), Optional.of(class_2561.method_43470((String)page2))), new class_9262((Object)class_2561.method_43470((String)page3), Optional.of(class_2561.method_43470((String)page3))), new class_9262((Object)class_2561.method_43470((String)page4), Optional.of(class_2561.method_43470((String)page4))), new class_9262((Object)class_2561.method_43470((String)page5), Optional.of(class_2561.method_43470((String)page5))), new class_9262((Object)class_2561.method_43470((String)page6), Optional.of(class_2561.method_43470((String)page6))), new class_9262((Object)class_2561.method_43470((String)page7), Optional.of(class_2561.method_43470((String)page7))), new class_9262((Object)class_2561.method_43470((String)page8), Optional.of(class_2561.method_43470((String)page8))), new class_9262((Object)class_2561.method_43470((String)page9), Optional.of(class_2561.method_43470((String)page9))), new class_9262((Object)class_2561.method_43470((String)page10), Optional.of(class_2561.method_43470((String)page10))), new class_9262((Object)class_2561.method_43470((String)page11), Optional.of(class_2561.method_43470((String)page11))), new class_9262((Object)class_2561.method_43470((String)page12), Optional.of(class_2561.method_43470((String)page12))), new class_9262((Object)class_2561.method_43470((String)page13), Optional.of(class_2561.method_43470((String)page13))), new class_9262((Object)class_2561.method_43470((String)page14), Optional.of(class_2561.method_43470((String)page14))), new class_9262((Object)class_2561.method_43470((String)page15), Optional.of(class_2561.method_43470((String)page15))), new class_9262((Object)class_2561.method_43470((String)page16), Optional.of(class_2561.method_43470((String)page16))), new class_9262((Object)class_2561.method_43470((String)page17), Optional.of(class_2561.method_43470((String)page17))), new class_9262((Object)class_2561.method_43470((String)page18), Optional.of(class_2561.method_43470((String)page18))), new class_9262((Object)class_2561.method_43470((String)page19), Optional.of(class_2561.method_43470((String)page19))), new class_9262((Object)class_2561.method_43470((String)page20), Optional.of(class_2561.method_43470((String)page20))), new class_9262((Object)class_2561.method_43470((String)page21), Optional.of(class_2561.method_43470((String)page21))), new class_9262((Object)class_2561.method_43470((String)page22), Optional.of(class_2561.method_43470((String)page22))), new class_9262((Object)class_2561.method_43470((String)page23), Optional.of(class_2561.method_43470((String)page23))), new class_9262((Object)class_2561.method_43470((String)page24), Optional.of(class_2561.method_43470((String)page24))), new class_9262((Object)class_2561.method_43470((String)page25), Optional.of(class_2561.method_43470((String)page25))), new class_9262((Object)class_2561.method_43470((String)page26), Optional.of(class_2561.method_43470((String)page26))), new class_9262((Object)class_2561.method_43470((String)page27), Optional.of(class_2561.method_43470((String)page27))), new class_9262((Object)class_2561.method_43470((String)page28), Optional.of(class_2561.method_43470((String)page28))));
        class_9302 bookContent = new class_9302(new class_9262((Object)"\u00a74The Chronicles of Havenica\u00a7r", Optional.of("\u00a74The Chronicles of Havenica\u00a7r")), "\u00a78Ancient Scribe\u00a7r", 0, pages, true);
        book.method_57379(class_9334.field_49606, (Object)bookContent);
        if (player.method_31548().method_7376() != -1) {
            player.method_31548().method_7394(book);
        } else {
            player.method_7328(book, false);
        }
    }
}

