/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.effect;

import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4081;

public class SporeVisionEffect
extends class_1291 {
    public SporeVisionEffect(class_4081 category, int color) {
        super(category, color);
    }

    public boolean method_5572(class_1309 entity, int amplifier) {
        if (entity.method_37908().method_8608() || !(entity instanceof class_1657)) {
            return super.method_5572(entity, amplifier);
        }
        class_1657 player = (class_1657)entity;
        class_3218 serverWorld = (class_3218)entity.method_37908();
        int effectLevel = amplifier + 1;
        this.createDenseSporeCloud(player, serverWorld, effectLevel);
        if (entity.field_6012 % 10 == 0) {
            this.createObscuringParticles(player, serverWorld, effectLevel);
        }
        if (entity.field_6012 % 20 == 0) {
            this.applyVisionImpairment(player, effectLevel);
        }
        if (entity.field_6012 % 40 == 0) {
            this.createPhantomHallucinations(player, serverWorld, effectLevel);
        }
        return super.method_5572(entity, amplifier);
    }

    private void createDenseSporeCloud(class_1657 player, class_3218 world, int level) {
        class_243 playerPos = player.method_19538();
        class_243 eyePos = player.method_33571();
        int particleIntensity = 15 + level * 10;
        double cloudRadius = 2.0 + (double)level * 0.8;
        for (int i = 0; i < particleIntensity; ++i) {
            double offsetX = player.method_59922().method_43059() * cloudRadius;
            double offsetY = player.method_59922().method_43059() * (cloudRadius * 0.7) + 0.5;
            double offsetZ = player.method_59922().method_43059() * cloudRadius;
            world.method_14199((class_2394)class_2398.field_28803, eyePos.field_1352 + offsetX, eyePos.field_1351 + offsetY, eyePos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.01);
            if (i % 3 != 0) continue;
            world.method_14199((class_2394)class_2398.field_11219, eyePos.field_1352 + offsetX, eyePos.field_1351 + offsetY, eyePos.field_1350 + offsetZ, 1, 0.0, 0.0, 0.0, 0.008);
        }
        class_243 lookDirection = player.method_5828(1.0f);
        for (int i = 0; i < 8 + level * 3; ++i) {
            class_243 sporePos = eyePos.method_1019(lookDirection.method_1021(0.5 + (double)i * 0.3));
            world.method_14199((class_2394)class_2398.field_28803, sporePos.field_1352 + player.method_59922().method_43059() * 0.8, sporePos.field_1351 + player.method_59922().method_43059() * 0.8, sporePos.field_1350 + player.method_59922().method_43059() * 0.8, 3 + level, 0.0, 0.0, 0.0, 0.015);
        }
    }

    private void createObscuringParticles(class_1657 player, class_3218 world, int level) {
        class_243 eyePos = player.method_33571();
        for (int i = 0; i < 25 + level * 15; ++i) {
            double angle = player.method_59922().method_43058() * Math.PI * 2.0;
            double distance = 0.8 + player.method_59922().method_43058() * (1.2 + (double)level * 0.4);
            double height = (player.method_59922().method_43058() - 0.5) * 1.8;
            double x = eyePos.field_1352 + Math.cos(angle) * distance;
            double y = eyePos.field_1351 + height;
            double z = eyePos.field_1350 + Math.sin(angle) * distance;
            world.method_14199((class_2394)class_2398.field_11237, x, y, z, 3, 0.0, 0.0, 0.0, 0.005);
            if (i % 4 == 0) {
                world.method_14199((class_2394)class_2398.field_11233, x, y, z, 3, 0.0, 0.0, 0.0, 0.003);
            }
            if (level < 3 || i % 6 != 0) continue;
            world.method_14199((class_2394)class_2398.field_22247, x, y, z, 2, 0.1, 0.1, 0.1, 0.008);
        }
    }

    private void applyVisionImpairment(class_1657 player, int level) {
        if (level >= 1) {
            player.method_6092(new class_1293(class_1294.field_5916, 60 + level * 20, 0, false, false, false));
        }
        if (level >= 2 && player.method_59922().method_43057() < 0.6f) {
            player.method_6092(new class_1293(class_1294.field_5919, 30 + level * 10, 0, false, false, false));
        }
        if (level >= 3) {
            player.method_6092(new class_1293(class_1294.field_5909, 80, 1, false, false, false));
            if (player.method_59922().method_43057() < 0.4f) {
                player.method_6092(new class_1293(class_1294.field_38092, 40, 0, false, false, false));
            }
        }
    }

    private void createPhantomHallucinations(class_1657 player, class_3218 world, int level) {
        if (player.method_59922().method_43057() > 0.3f + (float)level * 0.15f) {
            return;
        }
        class_243 playerPos = player.method_33571();
        class_243 lookDir = player.method_5828(1.0f);
        int hallucinationCount = player.method_59922().method_43048(1 + level) + 1;
        for (int i = 0; i < hallucinationCount; ++i) {
            double distance = 2.0 + player.method_59922().method_43058() * (6.0 + (double)level * 2.0);
            double angleOffset = (player.method_59922().method_43058() - 0.5) * Math.PI * 0.9;
            double heightOffset = (player.method_59922().method_43058() - 0.5) * 3.0;
            double yaw = Math.atan2(lookDir.field_1350, lookDir.field_1352) + angleOffset;
            class_243 phantomPos = new class_243(playerPos.field_1352 + Math.cos(yaw) * distance, playerPos.field_1351 + heightOffset, playerPos.field_1350 + Math.sin(yaw) * distance);
            this.createPhantomMob(world, phantomPos, level);
        }
    }

    private void createPhantomMob(class_3218 world, class_243 pos, int level) {
        int mobType = world.method_8409().method_43048(4);
        switch (mobType) {
            case 0: {
                this.createPhantomSkeleton(world, pos, level);
                break;
            }
            case 1: {
                this.createPhantomZombie(world, pos, level);
                break;
            }
            case 2: {
                this.createPhantomSpider(world, pos, level);
                break;
            }
            case 3: {
                this.createPhantomEnderman(world, pos, level);
            }
        }
    }

    private void createPhantomSkeleton(class_3218 world, class_243 pos, int level) {
        world.method_14199((class_2394)class_2398.field_23114, pos.field_1352, pos.field_1351 + 1.8, pos.field_1350, 4, 0.15, 0.1, 0.15, 0.02);
        world.method_14199((class_2394)class_2398.field_23114, pos.field_1352, pos.field_1351 + 1.4, pos.field_1350, 3, 0.2, 0.1, 0.2, 0.02);
        world.method_14199((class_2394)class_2398.field_23114, pos.field_1352, pos.field_1351 + 1.0, pos.field_1350, 3, 0.2, 0.1, 0.2, 0.02);
        world.method_14199((class_2394)class_2398.field_23114, pos.field_1352, pos.field_1351 + 0.6, pos.field_1350, 3, 0.15, 0.1, 0.15, 0.02);
        world.method_14199((class_2394)class_2398.field_23114, pos.field_1352, pos.field_1351 + 0.2, pos.field_1350, 2, 0.1, 0.05, 0.1, 0.02);
        world.method_14199((class_2394)class_2398.field_23956, pos.field_1352 + 0.3, pos.field_1351 + 1.6, pos.field_1350, 2, 0.05, 0.05, 0.05, 0.01);
        world.method_14199((class_2394)class_2398.field_23956, pos.field_1352 - 0.3, pos.field_1351 + 1.6, pos.field_1350, 2, 0.05, 0.05, 0.05, 0.01);
        if (level >= 2) {
            world.method_14199((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351 + 1.5, pos.field_1350, 6, 0.3, 0.2, 0.3, 0.02);
        }
    }

    private void createPhantomZombie(class_3218 world, class_243 pos, int level) {
        world.method_14199((class_2394)class_2398.field_11246, pos.field_1352, pos.field_1351 + 1.7, pos.field_1350, 5, 0.25, 0.1, 0.25, 0.03);
        world.method_14199((class_2394)class_2398.field_11246, pos.field_1352, pos.field_1351 + 1.3, pos.field_1350, 6, 0.3, 0.2, 0.3, 0.03);
        world.method_14199((class_2394)class_2398.field_11246, pos.field_1352, pos.field_1351 + 0.9, pos.field_1350, 5, 0.25, 0.1, 0.25, 0.03);
        world.method_14199((class_2394)class_2398.field_11246, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 4, 0.2, 0.1, 0.2, 0.03);
        world.method_14199((class_2394)class_2398.field_11246, pos.field_1352, pos.field_1351 + 0.1, pos.field_1350, 3, 0.15, 0.05, 0.15, 0.03);
        world.method_14199((class_2394)class_2398.field_20537, pos.field_1352, pos.field_1351 + 1.8, pos.field_1350, 3, 0.1, 0.0, 0.1, 0.01);
        if (level >= 2) {
            world.method_14199((class_2394)class_2398.field_22248, pos.field_1352, pos.field_1351 + 1.0, pos.field_1350, 8, 0.4, 0.4, 0.4, 0.04);
        }
    }

    private void createPhantomSpider(class_3218 world, class_243 pos, int level) {
        world.method_14199((class_2394)class_2398.field_11237, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 8, 0.4, 0.1, 0.4, 0.02);
        for (int i = 0; i < 8; ++i) {
            double angle = (double)i / 8.0 * Math.PI * 2.0;
            double legX = pos.field_1352 + Math.cos(angle) * 0.9;
            double legZ = pos.field_1350 + Math.sin(angle) * 0.9;
            world.method_14199((class_2394)class_2398.field_11237, legX, pos.field_1351 + 0.1, legZ, 2, 0.05, 0.05, 0.05, 0.01);
        }
        world.method_14199((class_2394)class_2398.field_11249, pos.field_1352, pos.field_1351 + 0.3, pos.field_1350, 4, 0.2, 0.1, 0.2, 0.02);
        if (level >= 2) {
            world.method_14199((class_2394)class_2398.field_11214, pos.field_1352, pos.field_1351 + 0.7, pos.field_1350, 6, 0.3, 0.2, 0.3, 0.03);
        }
    }

    private void createPhantomEnderman(class_3218 world, class_243 pos, int level) {
        world.method_14199((class_2394)class_2398.field_23190, pos.field_1352, pos.field_1351 + 2.8, pos.field_1350, 3, 0.1, 0.1, 0.1, 0.02);
        world.method_14199((class_2394)class_2398.field_23190, pos.field_1352, pos.field_1351 + 2.4, pos.field_1350, 4, 0.15, 0.1, 0.15, 0.02);
        world.method_14199((class_2394)class_2398.field_23190, pos.field_1352, pos.field_1351 + 2.0, pos.field_1350, 4, 0.15, 0.1, 0.15, 0.02);
        world.method_14199((class_2394)class_2398.field_23190, pos.field_1352, pos.field_1351 + 1.6, pos.field_1350, 4, 0.15, 0.1, 0.15, 0.02);
        world.method_14199((class_2394)class_2398.field_23190, pos.field_1352, pos.field_1351 + 1.2, pos.field_1350, 4, 0.15, 0.1, 0.15, 0.02);
        world.method_14199((class_2394)class_2398.field_23190, pos.field_1352, pos.field_1351 + 0.8, pos.field_1350, 3, 0.1, 0.1, 0.1, 0.02);
        world.method_14199((class_2394)class_2398.field_23190, pos.field_1352, pos.field_1351 + 0.4, pos.field_1350, 3, 0.1, 0.05, 0.1, 0.02);
        world.method_14199((class_2394)class_2398.field_11214, pos.field_1352 + 0.3, pos.field_1351 + 2.6, pos.field_1350, 2, 0.05, 0.05, 0.05, 0.01);
        world.method_14199((class_2394)class_2398.field_11214, pos.field_1352 - 0.3, pos.field_1351 + 2.6, pos.field_1350, 2, 0.05, 0.05, 0.05, 0.01);
        if (level >= 2) {
            world.method_14199((class_2394)class_2398.field_11216, pos.field_1352, pos.field_1351 + 1.5, pos.field_1350, 6, 0.3, 0.3, 0.3, 0.03);
        }
    }

    public boolean method_5552(int duration, int amplifier) {
        return true;
    }
}

