/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.entity.ai;

import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1547;
import net.minecraft.class_1604;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3417;

public class CursedMobTrackerGoal
extends class_1352 {
    private final class_1308 mob;
    private final double speed;
    private final double detectionRange;
    private final double meleeAttackRange;
    private final double rangedAttackRange;
    private class_1657 targetPlayer;
    private int updateCountdown;
    private int attackCooldown;
    private int rangedAttackTime = -1;
    private final int maxRangedAttackTime = 20;
    private int pathRecalculationCooldown;
    private int stuckTimer;
    private double lastX;
    private double lastY;
    private double lastZ;

    public CursedMobTrackerGoal(class_1308 mob, double speed, double detectionRange) {
        this.mob = mob;
        this.speed = speed;
        this.detectionRange = detectionRange;
        this.meleeAttackRange = (double)mob.method_17681() * 2.0 + 1.0;
        this.rangedAttackRange = 15.0;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.updateCountdown > 0) {
            --this.updateCountdown;
            return false;
        }
        this.updateCountdown = 10;
        if (!this.isCursedMob()) {
            return false;
        }
        this.targetPlayer = this.findNearestPlayer();
        return this.targetPlayer != null;
    }

    public boolean method_6266() {
        if (!this.isCursedMob()) {
            return false;
        }
        if (this.targetPlayer == null || !this.targetPlayer.method_5805()) {
            return false;
        }
        double distanceSq = this.mob.method_5858((class_1297)this.targetPlayer);
        return distanceSq < this.detectionRange * this.detectionRange * 1.5;
    }

    public void method_6269() {
        this.mob.method_5942().method_6335((class_1297)this.targetPlayer, this.speed);
        this.mob.method_5980((class_1309)this.targetPlayer);
        this.attackCooldown = 0;
        this.rangedAttackTime = -1;
    }

    public void method_6270() {
        this.targetPlayer = null;
        this.mob.method_5942().method_6340();
        this.mob.method_5980(null);
        this.rangedAttackTime = -1;
    }

    public void method_6268() {
        if (this.targetPlayer == null) {
            return;
        }
        double distanceSq = this.mob.method_5858((class_1297)this.targetPlayer);
        double distance = Math.sqrt(distanceSq);
        this.mob.method_5988().method_6226((class_1297)this.targetPlayer, 30.0f, 30.0f);
        boolean isRangedMob = this.isRangedMob();
        if (isRangedMob) {
            this.handleRangedCombat(distance);
        } else {
            this.handleMeleeCombat(distance);
        }
        if (this.mob.field_6012 % 10 == 0) {
            this.mob.method_5942().method_6335((class_1297)this.targetPlayer, this.speed);
        }
        this.mob.method_5980((class_1309)this.targetPlayer);
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    private void handleMeleeCombat(double distance) {
        if (distance > this.meleeAttackRange) {
            this.mob.method_5942().method_6335((class_1297)this.targetPlayer, this.speed);
        } else {
            this.mob.method_5942().method_6340();
            if (this.attackCooldown <= 0) {
                this.performMeleeAttack();
                this.attackCooldown = 20;
            }
        }
    }

    private void handleRangedCombat(double distance) {
        if (distance < 8.0) {
            this.mob.method_5942().method_6340();
        } else if (distance > this.rangedAttackRange) {
            this.mob.method_5942().method_6335((class_1297)this.targetPlayer, this.speed);
        } else {
            this.mob.method_5942().method_6340();
            if (this.attackCooldown <= 0) {
                this.performRangedAttack(distance);
            }
        }
    }

    private void performMeleeAttack() {
        if (this.targetPlayer == null) {
            return;
        }
        this.mob.method_6104(class_1268.field_5808);
        this.mob.method_6121((class_1297)this.targetPlayer);
    }

    private void performRangedAttack(double distance) {
        if (this.targetPlayer == null) {
            return;
        }
        class_1799 mainHandStack = this.mob.method_6047();
        if (mainHandStack.method_7909() instanceof class_1753) {
            if (this.rangedAttackTime == -1) {
                this.rangedAttackTime = 0;
            }
            ++this.rangedAttackTime;
            if (this.rangedAttackTime >= 20) {
                this.shootArrow(distance);
                this.rangedAttackTime = -1;
                this.attackCooldown = 30;
            }
        } else if (mainHandStack.method_7909() instanceof class_1764) {
            this.shootCrossbow();
            this.attackCooldown = 40;
        } else if (this.mob instanceof class_1547) {
            this.shootArrow(distance);
            this.attackCooldown = 30;
        }
    }

    private void shootArrow(double distance) {
        class_1799 weaponStack = this.mob.method_6047();
        class_1799 arrowStack = this.mob.method_18808(weaponStack);
        class_1665 arrow = class_1675.method_18813((class_1309)this.mob, (class_1799)arrowStack, (float)1.0f, (class_1799)weaponStack);
        if (arrow != null) {
            double dx = this.targetPlayer.method_23317() - this.mob.method_23317();
            double dy = this.targetPlayer.method_23323(0.3333333333333333) - arrow.method_23318();
            double dz = this.targetPlayer.method_23321() - this.mob.method_23321();
            double distanceXZ = Math.sqrt(dx * dx + dz * dz);
            arrow.method_7485(dx, dy + distanceXZ * 0.2, dz, 1.6f, (float)(14 - this.mob.method_37908().method_8407().method_5461() * 4));
            this.mob.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.mob.method_59922().method_43057() * 0.4f + 0.8f));
            this.mob.method_37908().method_8649((class_1297)arrow);
            this.mob.method_6104(class_1268.field_5808);
        }
    }

    private void shootCrossbow() {
        if (this.mob instanceof class_1604) {
            this.mob.method_6104(class_1268.field_5808);
        } else {
            this.shootArrow(Math.sqrt(this.mob.method_5858((class_1297)this.targetPlayer)));
        }
    }

    private boolean isRangedMob() {
        if (this.mob instanceof class_1547) {
            return true;
        }
        if (this.mob instanceof class_1604) {
            return true;
        }
        class_1799 mainHand = this.mob.method_6047();
        return mainHand.method_7909() instanceof class_1811;
    }

    private boolean isCursedMob() {
        if (!this.mob.method_16914() || this.mob.method_5797() == null) {
            return false;
        }
        return this.mob.method_5797().getString().contains("Cursed");
    }

    private class_1657 findNearestPlayer() {
        class_1937 class_19372 = this.mob.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_1657 nearest = null;
        double nearestDistance = this.detectionRange * this.detectionRange;
        for (class_1657 player : serverWorld.method_18456()) {
            double distance;
            if (!player.method_5805() || player.method_7325() || player.method_7337() || !((distance = this.mob.method_5858((class_1297)player)) < nearestDistance)) continue;
            nearest = player;
            nearestDistance = distance;
        }
        return nearest;
    }
}

